% Check Parameters for WCDMA Physical Channel Mapping

% Check for Number of Physical Channels
if(~isscalar(numPhCH) | ~isreal(numPhCH) | floor(numPhCH) ~= numPhCH | numPhCH<=0 | numPhCH>3)
    errordlg('Number of physical channels must be an integer number between 1 and 3.');
elseif(numPhCH ~= 1)
    errordlg('Only 1 Physical Channel is currently supported');
end

% Check for Number of bits in CCTrCh
if(any(floor(numBitsCCTrCh) ~= numBitsCCTrCh) | numBitsCCTrCh<1 | ~isreal(numBitsCCTrCh))
    errordlg('Number of bits per CCTrCH must be a positive integer number.');
end

% Check Slot Format Parameter
if(~isscalar(slotFormat) | ~isreal(slotFormat) | floor(slotFormat) ~= slotFormat | slotFormat >16 | slotFormat<0),
    errordlg('The Slot format parameter must be an integer between 0 and 16.');
end