#include <user.h>
#include <p18f24k50.h>
#include <fat16.h>

  #pragma romdata EEDATA = 0xf00000
  rom char data[]= {'A','D','A','T',48,48,48,48,'C','S','V',32};
  #pragma romdata

extern FAJL_FEJLEC ff;


void read_eprom(unsigned char* p,unsigned char kezdcim,unsigned char hossz)
{
	unsigned char i;
	EECON1bits.EEPGD=0;
	EECON1bits.CFGS=0;
	EEADR=kezdcim;
	for(i=0;i<hossz;i++)
	{
		EECON1bits.RD=1;
		*p=EEDATA;p++;
		EEADR++;
	}
}

void write_eprom(unsigned char* p,unsigned char kezdcim,unsigned char hossz)
{
	unsigned char i;
	EEADR=kezdcim;
	EECON1bits.EEPGD=0;
	EECON1bits.CFGS=0;
	INTCONbits.GIE=0;
	EECON1bits.WREN=1;
	for(i=0;i<hossz;i++)
	{
		EECON1bits.RD=1;//read addres
		EEDATA=*p++;
		EECON2=0x55;
		EECON2=0xAA;
		EECON1bits.WR=1;
		while(EECON1bits.WR){};
		EEADR+=1;
	}
	EECON1bits.WREN=0;
	INTCONbits.GIE=1;
}
/*************************/
void HLVD_Init()
{
	ANSELAbits.ANSA5=1;		//digital off
	TRISAbits.RA5=1;		//pin input
	HLVDCON=0b00011111; 	//fesz alacsonyabb detekt  modul on
	PIR2bits.HLVDIF=0;
	IPR2bits.HLVDIP=1;		//high priority
	PIE2bits.HLVDIE=1;		//irq enable
	INTCON |= 0xc0;			//gie peie
}
/**************************/
void HLVD_IRQ()
{
	closefile();
	write_eprom( ff.filenev,0,12);
	PIR2bits.HLVDIF=0;
	Sleep();	
}