//CONFIG1H 
#pragma config FOSC		= HSMP 		//0xF3 	HS oscillator (medium power 4-16 MHz).
#pragma config PLLCFG	= ON 		//0xFF 	Oscillator multiplied by 4xPLL
#pragma config PRICLKEN = ON		//0xFF 	Primary clock is always enabled.
#pragma config FCMEN 	= OFF 		//0xBF 	Fail-Safe Clock Monitor disabled.
#pragma config IESO 	= OFF 		//0x7F 	Oscillator Switchover mode disabled.
//CONFIG2L 
#pragma config PWRTEN 	= ON 		//0xFE  Power up timer enabled.
#pragma config BOREN 	= ON 		//0xFB 	Brown-out Reset enabled and controlled by software (SBOREN is enabled).
#pragma config BORV 	= 285 		//0xE7 	VBOR set to 2.85 V nominal.
//CONFIG2H 
#pragma config WDTEN 	= OFF 		//0xFC 	Watch dog timer is always disabled. SWDTEN has no effect.
#pragma config WDTPS	= 256 		//0xE3 	1:256.
//CONFIG3H 
#pragma config CCP2MX	= PORTC1 	//0xFF 	CCP2 input/output is multiplexed with RC1.
#pragma config PBADEN	= OFF 		//0xFD 	PORTB<5:0> pins are configured as digital I/O on Reset.
#pragma config CCP3MX	= PORTB5 	//0xFF 	P3A/CCP3 input/output is multiplexed with RB5.
#pragma config HFOFST	= OFF 		//0xF7 	HFINTOSC output and ready status are delayed by the oscillator stable status.
#pragma config T3CMX	= PORTC0 	//0xFF 	T3CKI is on RC0.
#pragma config P2BMX	= PORTD2 	//0xFF 	P2B is on RD2.
#pragma config MCLRE	= EXTMCLR 	//0xFF 	MCLR pin enabled, RE3 input pin disabled.
//CONFIG4L 
#pragma config STVREN	= ON 		//0xFF 	Stack full/underflow will cause Reset.
#pragma config LVP		= OFF 		//0xFB 	Single-Supply ICSP disabled.
#pragma config XINST	= OFF 		//0xBF 	Instruction set extension and Indexed Addressing mode disabled (Legacy mode).
#pragma config DEBUG	= OFF 		//0xFF 	Disabled.
//CONFIG5L
#pragma config CP0      = OFF       // Kdvdelem kikapcsolva
#pragma config CP1      = OFF
#pragma config CP2      = OFF
#pragma config CP3      = OFF
//CONFIG5H 
#pragma config CPB      = OFF   	// Boot Blokk kdvdelem kikapcsolva
#pragma config CPD      = OFF		// Eeprom kdvdelem kikapcsolva
//CONFIG6L 
#pragma config WRT0     = OFF   	// rsvdelem kikapcsolva
#pragma config WRT1     = OFF
#pragma config WRT2     = OFF
#pragma config WRT3     = OFF
//CONFIG6H 
#pragma config WRTB     = OFF   	// Boot Blokk rsvdelem bekapcsolva
#pragma config WRTC     = OFF		// Configuration Register Write Protection
#pragma config WRTD     = OFF		// Data EEPROM Write Protection 
//CONFIG7L 
#pragma config EBTR0    = OFF       // Tblzatolvass ne legyen letiltva
#pragma config EBTR1    = OFF
#pragma config EBTR2    = OFF
#pragma config EBTR3    = OFF
//CONFIG7H 
#pragma config EBTRB    = OFF       //Boot blokk tblaolvass ne legyen letiltva

#define	X_FREQ	64
#define DelayUs(x) { unsigned int i=x/(40/X_FREQ) ; while(i--); }
#define DelayMs(x) { unsigned int i=x; while(i--){unsigned int a=830/(40/X_FREQ);  while(a--); }  }

/*CONFIG1H = 0b00110011;		
CONFIG2L = 0b00000110;				
CONFIG2H = 0b00100000;
CONFIG3H = 0b10000001;
CONFIG4L = 0b10000001;
CONFIG5L = 0; // Code Protection
CONFIG5H = 0; // Data EEPROM Code Protection
CONFIG6L = 0; // Write Protection
CONFIG6H = 0; // Data EEPROM Write Protection
CONFIG7L = 0; // Table Read Protection
CONFIG7H = 0; // Boot Block Table Read Protection*/
