#define WirePin        LATBbits.LATB0
#define WirePinRead    PORTBbits.RB0
#define WireDir        TRISBbits.TRISB0

#define DQ		LATBbits.LATB0
#define DQ_R	PORTBbits.RB0
#define DQ_TRIS	TRISBbits.TRISB0 

void Delay_Us(unsigned int us){	// 1/(64000000/4) == 0.00000000625 * 16 = 0.0000001 == 1us
	unsigned char i;
	while(us--){ 
		for(i=16; i==0; i--) Delay1TCY();
	}
}

volatile int iobyte=0;

void ow_reset(void){
	unsigned int pdbyte;
	DQ_TRIS = 0;                        // Set DQ pin as output
	DQ = 1;                                  // Start with the line high
	pdbyte = 0x00;                        // Clear the PD byte
	Delay_Us( 1 );                      // Drive Low for 1us
	DQ = 0;
	Delay_Us( 500 );                  // Drive Low for 500us
	DQ = 1;
	Delay_Us( 700 );                  // Release line and wait 70us for PD Pulse
	
	DQ_TRIS = 1;                        // Set DQ pin as input
	Delay_Us( 1 );                      // Wait 1us
	if( DQ_R == 0) {
	    pdbyte = 0x01;                    // Set PDBYTE to 1 if get a PD Pulse
	}
	Delay_Us( 400 );                  // Wait 400us after PD Pulse
}

void dsrxbyte(void){
	unsigned int  x, count, temp;
    count = 0x08;                          //Set count = 8
    for( x=0; x<8 ;x++ ){
        DQ_TRIS = 0;                        // Set DQ pin as output
        Delay_Us( 1 );                      // Wait 1us
        DQ = 0;                                 // Bring DQ low for 6us
        Delay_Us( 6 );
        DQ = 1;                                 // Bring DQ low for 4us
        Delay_Us( 4 );
        DQ_TRIS = 1;                        // Set DQ pin as input
        Delay_Us( 1 );                      // Wait 1us
        if( DQ_R == 1 ){
            iobyte = iobyte | ( 2^x );          // Logig OR
        }else{
            temp = ~ ( 2^x );
            iobyte = iobyte & temp;          // Logig AND
        }
    }
	return iobyte;
}

void dstxbyte(void){
    unsigned int x, temp, count = 8;
    for( x=0; x<8 ;x++ ){
        DQ_TRIS = 0;                        // Set DQ pin as output
        Delay_Us( 1 );                      // Wait 1us
        DQ = 0;                                 // Set DQ pin low
        Delay_Us( 3 );                     // Wait 3us
        temp = iobyte & ( 2^x );           // Logig AND
        if( temp == ( 2^x ) ){
            DQ = 1;                             // Set DQ pin high
        }
        Delay_Us( 60 );                   // Wait 60us
        DQ = 1;                                 // Set DQ pin high
        Delay_Us( 2 );                     // Wait 2us
    }
}
