#define WirePin        LATBbits.LATB0
#define WirePinR       PORTBbits.RB0
#define WireDir        TRISBbits.TRISB0

void prvWireInit( void ){
	WireDir = 1;
	WirePin = 1;
}

void prvWireReset( void ){
	WireDir = 0;
	WirePin = 0;
	Delay_Us( 550 );  
	WirePin = 1;
	WireDir = 1;				// Set DS18B20 pin as input
	Delay_Us( 50 );
}

int prvWirePresence( void ){	
	int i;
	int Bit = 0;
	//WireDir = 1;				// Set DS18B20 pin as input

	for( i=480; i>0; i-- ){
            Delay_Us( 1 );
            if ( WirePinR == 0 ) Bit = 1;
	}
	//while(WirePinR);
	return Bit;
}

void prvWireSendBit( unsigned char Bit ){
	WireDir = 0;
	WirePin = 0;                                                             // Set DS18B20 pin as output
	Delay_Us( 2 );                                                           // Trec - Release time
	WirePin = Bit;
	Delay_Us( 60 );                                                          // Tslot - Time slot
    WireDir= 1;                                                              // Set DS18B20 pin as input
	Delay_Us( 2 );                                                            // Trec - Release time
}

char prvWireGetBit( void ){	
	char Bit;
	WireDir = 0;                                                            // Set DS18B20 pin as output
	WirePin = 0;                                                             // Trec - Release time
	Delay_Us( 2 );
	WireDir = 1;                                                             // Set DS18B20 pin as input
	Delay_Us( 20 );                                                          // Read data valid
	Bit = WirePinR;
	Delay_Us( 100 );
	return Bit;
}

void prvWireWriteByte( unsigned char Byte ){
	int i;
	for ( i=0; i<8; i++ )
	{
	prvWireSendBit( Byte & 0x01 );
	Byte = Byte >> 1;
	}
}

char  prvWireReadByte(void){
	int i;
	char Byte;
	Byte = 0;
	for( i=0; i<8; i++ )
	Byte = Byte | ( ( 1&prvWireGetBit( ) ) << i );                 // Logic AND - Bits shifted left "i" positions - Logic OR
	return Byte;
}
