/*  Vltoztpusok s unik definilsa ******************************/
typedef unsigned char       uint8;   // 8 bites, eljel nlkli szm
typedef unsigned int        uint16;  //16 bites, eljel nlkli szm
typedef unsigned long       uint32;  //32 bites, eljel nlkli szm
typedef signed char         int8;    // 8 bites, eljeles szm
typedef signed int          int16;   //16 bites, eljeles szm
typedef signed long         int32;   //32 bites, eljeles szm

///Uni tpus sz s bjt elrssel 16 bites adatokhoz
typedef union _union16 { 
  uint16 word;
  struct {
    uint8 lo_byte;
    uint8 hi_byte;
  };
} union16;

///Uni tpus duplasz, sz s bjt elrssel 32 bites adatokhoz
typedef union _union32 {
  uint32 dword;
  struct {
    uint16 lo_word;
    uint16 hi_word;
  };
  uint8 byte[4];
} union32;

#define I2C_SCL		TRISBbits.TRISB1
#define I2C_SDA 	TRISBbits.TRISB0
#define I2C_ACK		0	//pozitv nyugtzs
#define I2C_NAK		1	//negatv nyugtzs

/* Makrk az SSPCON1 regiszter belltshoz  */
#define   SSPENB    			0b00100000  	/* Enable serial port and configures SCK, SDO, SDI*/
#define   SLAVE_7   			0b00000110     	/* I2C Slave mode, 7-bit address*/
#define   SLAVE_10  			0b00000111    	/* I2C Slave mode, 10-bit address*/
#define   MASTER    			0b00001000     	/* I2C Master mode */
#define   MASTER_FIRMW			0b00001011		//I2C Firmware Controlled Master mode (slave Idle)
#define   SLAVE_7_STSP_INT 		0b00001110		//I2C Slave mode, 7-bit address with Start and Stop bit interrupts enabled
#define   SLAVE_10_STSP_INT 	0b00001111		//I2C Slave mode, 10-bit address with Start and Stop bit interrupts enabled

/* Makrk az SSPSTAT regiszter belltshoz */
#define   SLEW_ON   			0b00000000  	/* Slew rate vezrls engedlyezve (400kHz md) */
#define   SLEW_OFF  			0b10000000  	/* Slew rate vezrls letiltva  (100kHz md) */
#define   SMBUS_ENABLE 			0b01000000  	/* SMBUS specifikus bemenet engedlyezse */
#define   SMBUS_DISABLE			0b00000000  	/* SMBUS specifikus bemenet tiltsa  */

#define i2c_idle()  while ((SSPCON2 & 0x1F) | (SSPSTATbits.R_W))
#define i2c_start() SSPCON2bits.SEN=1; while(SSPCON2bits.SEN)
#define i2c_rstart() SSPCON2bits.RSEN=1; while(SSPCON2bits.RSEN)
#define i2c_stop()  SSPCON2bits.PEN=1; while(SSPCON2bits.PEN)
#define i2c_ack(ackbit)   SSPCON2bits.ACKDT=ackbit; SSPCON2bits.ACKEN=1; while(SSPCON2bits.ACKEN)
#define Fosc 48000000L
void i2c_init(uint16 bitrate_kHz);
uint8 i2c_getc(uint8 ack2send);
uint8 i2c_putc(uint8 data);
void i2c_write1(uint8 addr,uint8 data);
void i2c_write2(uint8 addr,uint8 d1, uint8 d2);
void i2c_writeN(uint8 addr, uint8* data, uint8 cnt);
void i2c_read1(uint8 addr,uint8* p1);
void i2c_read2(uint8 addr,uint8* p1, uint8* p2);
void i2c_readN(uint8 addr,uint8* p1, uint8 cnt);


/** Az I2C modul konfigurlsa s engedlyezse a bitrate_kHz 
 * paramter ltal megadott adatsebessggel.
 * \param bitrate_kHz a kHz egysgekben megadott adattviteli sebessg
 */
void i2c_init(unsigned int bitrate_kHz) {
  #define clk_tmp Fosc/4000L
  SSPADD = clk_tmp/bitrate_kHz -1;
  SSPSTAT = SLEW_OFF | SMBUS_DISABLE;
  SSPCON1 = MASTER;
  SSPCON2 = 0x00;
  I2C_SCL = 1;
  I2C_SDA = 1;
  SSPCON1 |= SSPENB; 			// az MSSP egysg engedlyezse
}

/** Mvelet: Beolvas egy bjtot az I2C buszrl, maj kikldi az \em ack2Send 
 * paramterrel megadott nyugtz bitet a slave eszkznek.
 * \param ack2Send a nyugtz bit (0: ACK, 1: NAK), amelyet a beolvass vgn kikldnk a slave-nek
 * \return a beolvasott bjt
 */

uint8 i2c_getc(uint8 ack2send) {
  i2c_idle();
  SSPCON2bits.RCEN = 1;                 // a master engedlyezse egy bjt vtelre
  while ( !SSPSTATbits.BF );            // megvrjuk, amg a bjt berkezik 
  i2c_ack(ack2send);					// kikldjk a nyugtz bitet
  return ( SSPBUF );                    // visszatrnk a bjttal
}

/** Mvelet: Kir egy bjtot az I2C buszra, maj megvrja nyugtzst
 * \param data ki1rand adatbjt
 * \return a nyugtzs eredmnye ((0: ACK, 1: NAK)
 */
uint8 i2c_putc(uint8 data) {
  SSPBUF = data;                        // kirakunk egy bjtot SSPBUF-ba
  while( SSPSTATbits.BF );              // megvrjuk,amg az rslezajlik  
  i2c_idle();                           // megvrjuk a busz aktivits vgt
  return ( SSPCON2bits.ACKSTAT );       // a nyugtz bittel trnk vissza
}

/** Tranzakci: Egy bjt rsa 
 * \param addr  a slave I2C cme
 * \param data  a kikldeni kvnt bjt
 */
void i2c_write1(uint8 addr,uint8 data) {
  i2c_start();
  i2c_putc(addr & 0xFE);
  i2c_putc(data);
  i2c_stop();
}

/** Tranzakci: Kt bjt rsa
 * \param addr a slave I2C cme
 * \param d1  az els kikldeni kvnt bjt
 * \param d2  a msodik kikldeni kvnt bjt
 */
void i2c_write2(uint8 addr,uint8 d1, uint8 d2) {
  i2c_start();
  i2c_putc(addr & 0xFE);
  i2c_putc(d1);
  i2c_putc(d2);
  i2c_stop();
}

/** Tranzakci: Adott szm adatbjt rsa 
 * \param addr a slave I2C cme
 * \param *data a krand adatok mutatja
 * \param cnt a kirand adatbjtok szma
 */
void i2c_writeN(uint8 addr, uint8* data, uint8 cnt) {
  uint8 i;
  i2c_start();
  i2c_putc(addr & 0xFE);
  for (i=0; i < cnt; i++) {
    i2c_putc(*data);
    data++;
  }
  i2c_stop();
}

/** Tranzakci: Egy bjtot olvas az \em addr cm eszkzrl. 
 *  A beolvasott adat a \em p1 mutatval megcmzett helyre kerl.
 * \param addr a slave I2C cme
 * \param *p1 a beolvasott adat eltrolsi helynek mutatja
 */
void i2c_read1(uint8 addr,uint8* p1) {
  i2c_start();
  i2c_putc(addr | 0x01);
  *p1 = i2c_getc(I2C_NAK);
  i2c_stop();
}

/** Tranzakci: Kt bjtot olvas az \em addr cm eszkzrl. 
 *  A beolvasott adatok a \em p1 s \em p2 mutatval megcmzett 
 *  bjtokba kerlnek elhelyezsre.
 * \param addr a slave I2C cme
 * \param *p1 az els beolvasott adat eltrolsi helynek mutatja
 * \param *p2 a msodik beolvasott adat eltrolsi helynek mutatja
 */
void i2c_read2(uint8 addr,uint8* p1, uint8* p2) {
  i2c_start();
  i2c_putc(addr | 0x01);
  *p1 = i2c_getc(I2C_ACK);
  *p2 = i2c_getc(I2C_NAK);
  i2c_stop();
}

/** Tranzakci: A \em cnt paramterrel megadott darabszm bjtot olvas 
 *  az \em addr cm eszkzrl. A beolvasott adat a \em p1 mutatval megcmzett 
 *  helytl kezdden kerlnek elhelyezsre, egyms utn.
 * \param addr a slave I2C cme
 * \param *p1 a beolvasott adatok eltrolsi helynek mutatja
 * \param cnt a beolvasand adatbjtok szma
 */ 
void i2c_readN(uint8 addr,uint8* p1, uint8 cnt) {
  uint8 i;
  i2c_start();
  i2c_putc(addr | 0x01);
  for (i=0; i < cnt; i++) {
    if(i != cnt-1) *p1 = i2c_getc(I2C_ACK);
    else  *p1 = i2c_getc(I2C_NAK);
    p1++;
  }
  i2c_stop();
}

