#include <p18f4550.h>
#include "header.h"
#include <stdio.h>
#include <delays.h>				//Ksleltetsek
#include <stdlib.h>
#include "lcd.c"
//#include "ds1820.h"
#include "i2c.c"

#define LED LATDbits.LATD0
#define EEPROM 0xA0			//az EEPROM I2C cme, fldre kttt cmvonalakkal
#define BLKSIZE 64			//blokkmret: egy memrialap 16 bjtos

/** Vrakozs arra, hogy az EEPROM befejezze az rst. Amg az rs tart,
 *  addig az EEPROM nem kld nyugtz jelet a cmnek kikldsekor.
 *  A fggvny blokkol tpus, addig nem tr vissza, amg az EEPROM foglalt.
 * \param addr a vizsglni kvnt slave eszkz I2C cme.
 */
void MCP24LC515_wait(uint8 addr) {
  uint8 ack;
  do {
    i2c_start();
    ack = i2c_putc(addr);					//ACK bit figyelse
    i2c_stop();
  } while (ack == I2C_NAK);
}

/** Egy memrialap (64 bjt) rsa a bemen adatbufferbl, az EEPROM egy
 *  megadott lapcmtl kezdden.
 *  \param addr az EEPROM I2C cme
 *  \param memaddr a memrialap kezdcme, ahov runk
 *  \param *pbuf mutat az adatbuffer kezdethez
 */
void MCP24LC515_write(uint8 addr,  union16 memaddr, uint8* pbuf) {
  pbuf[1] = memaddr.lo_byte;				//a lapcmet is a bufferbe tesszk
  pbuf[0] = memaddr.hi_byte;
  if (memaddr.hi_byte & 0x80) {				// ha MSB='1', belltjuk a blokkvlaszt bitet
    addr = addr | 0x08;
  }
  MCP24LC515_wait(addr);					//Vrunk, ha az EEPROM elfoglalt
  i2c_writeN(addr,pbuf,BLKSIZE+2);			//Az adatbuffer kirsa (cm+adatok)
}

/** Egy memrialap (64 bjt) olvassa az EEPROM egy megadott lapcmtl kezdden,
 *  s eltrolsa az adatbufferbe.
 *  \param addr az EEPROM I2C cme
 *  \param memaddr a beolvasni kvnt memrialap kezdcme
 *  \param *pbuf mutat az adatbuffer kezdethez
 */
void MCP24LC515_read(uint8 addr,union16 memaddr,uint8* pbuf) {
  if (memaddr.hi_byte & 0x80) {				// ha MSB='1', belltjuk a blokkvlaszt bitet
    addr = addr | 0x08;
  }
  MCP24LC515_wait(addr);
  i2c_write2(addr,memaddr.hi_byte,memaddr.lo_byte);		//lapcm belltsa
  i2c_readN(addr,pbuf,BLKSIZE);				//memrialap olvassa
}


void Delay_ms(unsigned int ms);

void main(){ 
	uint8  buf[BLKSIZE+2];		//2 extra bjt kell a cmnek
	union16 MemAddr,ReadAddr;
	
	TRISA = 0;
	TRISB = 0;
	TRISC = 0;
	TRISD = 0;
	TRISE = 0;
	ADCON1 = 0x0F;  //Minden port legyen digitlis
	CMCON = 7;		//comparators kikapcsolva
	INTCONbits.GIE = 0;

	lcd_init();
	
	i2c_init(400);                    	//400 kHz-es I2C bitrta 
	MemAddr.word = 0;			//A memria 0 cmtl kezdnk
	
	buf[3] = 0xff;		// Irunk bele adatot.
	MCP24LC515_write(EEPROM,MemAddr,buf);//Memria lap rsa
    MemAddr.word += BLKSIZE;
	
	printf("I2C MEM TESZT       ");
	lcd_write(0xC0,0,1,1);   
	printf("                    ");
	lcd_write(0x94,0,1,1);
	printf("                    ");
	lcd_write(0xD4,0,1,1);
	printf("Adat                ");
	lcd_write(0x80,0,1,1);	
	
	while(1){
		LED = !LED; 
		Delay_ms(500);
	}
}
void Delay_ms(unsigned int ms){ //Bemenet*ms vrakozs
   unsigned int i=0;
   for (i=0;i<=ms;i++) Delay1KTCYx(12);
}
