#include <Wire.h>

const uint8_t I2C_ADDRESS = 4;
const uint8_t NUM_PIXELS = 16;

void sendData( uint8_t * buf, uint8_t size )
{
  Wire.beginTransmission(I2C_ADDRESS);
    Wire.write(buf, size);
  Wire.endTransmission();
}

void setup() {
  Wire.begin();
}

void setPixelColor(uint8_t pixel, uint32_t color)
{
  uint8_t buf[5];
  buf[0] = 'P';
  buf[1] = pixel;
  buf[2] = (color >> 16) & 255;
  buf[3] = (color >> 8) & 255;
  buf[4] = (color) & 255;
  sendData(buf, sizeof(buf));
}

void show()
{
  uint8_t buf[1];
  buf[0] = 'S';
  sendData(buf, sizeof(buf));
}

void setLength(uint8_t l)
{
  uint8_t buf[2];
  buf[0] = 'S';
  buf[1] = l;
  sendData(buf, sizeof(buf));
}

// Convert separate R,G,B into packed 32-bit RGB color.
// Packed format is always RGB, regardless of LED strand color order.
uint32_t color32(uint8_t r, uint8_t g, uint8_t b) {
  return ((uint32_t)r << 16) | ((uint32_t)g <<  8) | b;
}

// Input a value 0 to 255 to get a color value.
// The colours are a transition r - g - b - back to r.
uint32_t wheel(byte WheelPos) {
  WheelPos = 255 - WheelPos;
  if(WheelPos < 85) {
   return color32(255 - WheelPos * 3, 0, WheelPos * 3);
  } else if(WheelPos < 170) {
    WheelPos -= 85;
   return color32(0, WheelPos * 3, 255 - WheelPos * 3);
  } else {
   WheelPos -= 170;
   return color32(WheelPos * 3, 255 - WheelPos * 3, 0);
  }
}

void rainbow(uint8_t wait) {
  uint16_t i, j;

  for(j=0; j<256; j++) {
    for(i=0; i<NUM_PIXELS; i++) {
      setPixelColor(i, wheel((i+j) & 255));
    }
    show();
    delay(wait);
  }
}

// Slightly different, this makes the rainbow equally distributed throughout
void rainbowCycle(uint8_t wait) {
  uint16_t i, j;

  for(j=0; j<256*5; j++) { // 5 cycles of all colors on wheel
    for(i=0; i< NUM_PIXELS; i++) {
      setPixelColor(i, wheel(((i * 256 / NUM_PIXELS) + j) & 255));
    }
    show();
    delay(wait);
  }
}

uint32_t divide(uint32_t color, uint8_t div)
{
  uint16_t r = (color >> 16 ) & 255;
  uint16_t g = (color >> 8 ) & 255;
  uint16_t b = color & 255;
  r = r * div / 255;
  g = g * div / 255;
  b = b * div / 255;
  
  return ((uint32_t)r << 16) + ( g << 8 ) + b;
}

void knightRider(uint8_t wait)
{
  for (int j=0; j < 192; j++) {     // cycle all 256 colors in the wheel
    for (int i=0; i < NUM_PIXELS; i++) {
      int p = i + j;
      int col = (p / 9) * 9;
      int rem = p % 9;
      
      uint32_t c1 = wheel(3*col);
      uint32_t c;
      
      switch(rem)
      {
      case 0:
        c = divide(c1, 0);
        break;
      case 1:
        c = divide(c1, 4);
        break;
      case 2:
        c = divide(c1, 32);
        break;
      case 3:
        c = divide(c1, 75);
        break;
      case 4:
        c = divide(c1, 75);
        break;
      case 5:
        c = divide(c1, 32);
        break;
      case 6:
        c = divide(c1, 4);
        break;
      case 7:
        c = divide(c1, 0);
        break;
      case 8:
        c = divide(c1, 0);
        break;
      }
      
      setPixelColor(i, c);    //turn every third pixel on
    }
    show();
       
    delay(wait);
  }
}


void loop() {
  setLength(NUM_PIXELS);
  
  knightRider(100);
  rainbow(20);
  rainbowCycle(20);
}

