' EEPROM, READ and WRITE Commands
'
' Demonstate commands for EEPROM. Works on PIC16C84 targets only!!!
' Initialized address 0..5 and 9. Writes 10..63. This leaves addesses
' 6..8 undefined (assuming your programmer doesn't unconditionally
' program all EEPROM locations).

Symbol	SO = 0				' Serial Output

EEPROM	("vwxyz")			' EEPROM[0..4] = 118..122
EEPROM	9,(100)				' EEPROM[9] = 100

Loop:	B0 = 255 : read B0,B0		' B0 = Sizeof(EEPROM) ('84 = 64)
					' Report Size
	serout SO,N2400,(13,"Size = ",#B0,10,13)
	B0 = B0 - 1			' Adjust Size

	For B1 = 10 To B0		' Check WRITE Command
		B2 = B1 + 100			' EEPROM[10..63] = 110..163
		write B1,B2
	Next B1

	For B1 = 0 To B0		' Check READ Command
		Read B1,B2			' Dump EEPROM Contents
		serout SO,N2400,(#B2," ")
	Next B1
	serout SO,N2400,(10,10)

	goto Loop			' Forever

