// egy egyszer teszt az uart driverhez (megszaktsos mdhoz)
// az RX-en vett adatot 1-el megnvelve tovbbkldi TX-re
// belltsok az uart.h-ban vannak (rajel, baudrate stb.)
#ifdef   __18CXX
#include <p18cxxx.h>
#include "bootloaders.h"
#elif    __XC
#include <xc.h>
#elif    defined(__PICC18__)
#include <htc.h>
#endif

#include "uart.h"

//=============================================================================
void main()
{
  unsigned char c;
  UartInit();
  while(1)
  {
    if(uRxLength)
    {
      c = UartRx();
      c++;
      if(uTxBufFree)
        UartTx(c);
    }
  }
}

//=============================================================================
#if defined(__18CXX)
#pragma code
#pragma interrupt YourHighPriorityISRCode
void YourHighPriorityISRCode()
#else
void interrupt YourHighPriorityISRCode()
#endif
{
  UartRxIntProcess();
  UartTxIntProcess();
}

//==============================================================================
#ifdef   __18CXX
#pragma interruptlow YourLowPriorityISRCode
void YourLowPriorityISRCode()
#else
void interrupt low_priority YourLowPriorityISRCode()
#endif
{
}

