#include <p18f442.h>
#include <stdio.h>
#include <delays.h>
//#include "usart.h"
#include "header.h"
#include "lcd.c"
#include "uart.h"
#include "uart.c"

#define LED 	LATAbits.LATA2

volatile unsigned char Result, ResultOK, Error=0;
volatile unsigned int Wait=0, x=0;
volatile unsigned long DataSize=0;
void main(void){ 
	
	TRISA = 0; 
	PORTA = 0;
	TRISB = 0; 
	PORTB = 0;
	TRISC = 0b10000000;
	PORTC = 0;
	TRISD = 0; 
	PORTD = 0;
	TRISE = 0; 
	PORTE = 0;
	RCONbits.IPEN = 1;			// Ktszint megszaktsi md belltsa
	INTCONbits.GIEH = 1;		// A magas priorits interrupt
    INTCONbits.GIEL = 0;		// Az alacsony priorits interrupt
	INTCONbits.GIE = 1;			// Megszaktsok engedlyezse
	
	PIE1bits.RCIE = 1;	// USART Receive Interrupt Enable bit
	IPR1bits.RCIP = 1;	// USART Receive Interrupt Priority bit
	
	PIE1bits.TXIE = 0;	// USART Transmit Interrupt enabled bit
	IPR1bits.TXIP = 0;	// USART Transmit Interrupt Priority bit
	
	ADCON1 = 0x0F;  //Minden port legyen digitlis
	CCP1CON = 0;
	
	/*********************************************
	*	LCD inicializls
	**********************************************/
    lcd_init();             // Az LCD modulinicializlsa 
    lcd_init_cgram();       // Az kezetes betk feltltse
    stdout = _H_USER;       // Az LCD legyen a standard kimenetnt
    /****************************LCD*************************************/

	UartInit();
		  
	while (1){
		
		printf("RX/TX               ");
		lcd_write(0xC0,0,1,1);   
		printf("Result: 0x%x        ", Result);
		lcd_write(0x94,0,1,1);
		printf("x:%u Hiba:%i        ", x, Error);
		lcd_write(0xD4,0,1,1);
		printf("Size:%lu            ", DataSize);
		lcd_write(0x80,0,1,1);
					
		
			if(uRxLength)
			{
			  Result = UartRx();
			  Result++;
			  if(uTxBufFree)
				UartTx(Result);
			}

		
	}//while
	
}//main

#pragma code
#pragma interrupt YourHighPriorityISRCode
void YourHighPriorityISRCode()
{
  UartRxIntProcess();
  UartTxIntProcess();
}

//==============================================================================
#pragma interruptlow YourLowPriorityISRCode
void YourLowPriorityISRCode()
{
}

//==============================================================================
#pragma code InterruptVectorHigh = 0x08
void InterruptVectorHigh(void)
{
  _asm goto YourHighPriorityISRCode _endasm
}

//==============================================================================
#pragma code low_vector_section = 0x18
void InterruptVectorLow(void)
{
  _asm goto YourLowPriorityISRCode _endasm
}
