#include <p18f442.h>
#include <stdio.h>
#include <delays.h>
#include "usart.h"
#include "header.h"
#include "lcd.c"

#define LED 	LATAbits.LATA2

void Delay_ms(unsigned int ms);
void init_usart(void);
void write_uart(unsigned char data);
unsigned char read_uart(void);

volatile unsigned char Result, ResultOK, Error=0;
volatile unsigned int Wait=0, x=0;
volatile unsigned long DataSize=0;

#include "interrupt.h"

void main(void){ 
	char mybuff [] = "Szervusz! Mit parancsolsz kedves gazdam? \r\n";
	unsigned char upload, ByteWordMode;
	unsigned int i;
	
	TRISA = 0; 
	PORTA = 0;
	TRISB = 0; 
	PORTB = 0;
	TRISC = 0b10000000;
	PORTC = 0;
	TRISD = 0; 
	PORTD = 0;
	TRISE = 0; 
	PORTE = 0;
	RCONbits.IPEN = 1;			// Ktszint megszaktsi md belltsa
	INTCONbits.GIEH = 1;		// A magas priorits interrupt
    INTCONbits.GIEL = 0;		// Az alacsony priorits interrupt
	INTCONbits.GIE = 1;			// Megszaktsok engedlyezse
	
	PIE1bits.RCIE = 1;	// USART Receive Interrupt Enable bit
	IPR1bits.RCIP = 1;	// USART Receive Interrupt Priority bit
	
	PIE1bits.TXIE = 0;	// USART Transmit Interrupt enabled bit
	IPR1bits.TXIP = 0;	// USART Transmit Interrupt Priority bit
	
	ADCON1 = 0x0F;  //Minden port legyen digitlis
	CCP1CON = 0;
	
	/*********************************************
	*	LCD inicializls
	**********************************************/
    lcd_init();             // Az LCD modulinicializlsa 
    lcd_init_cgram();       // Az kezetes betk feltltse
    stdout = _H_USER;       // Az LCD legyen a standard kimenetnt
    /****************************LCD*************************************/
	
	init_usart();
	
	//putsUSART(mybuff);
	//Delay_ms(1000);
	//putrsUSART("Hello World!\r\n");
	
	LED = 1; // zemksz
	
	while (1){
		
		printf("RX/TX               ");
		lcd_write(0xC0,0,1,1);   
		printf("Result: 0x%x        ", Result);
		lcd_write(0x94,0,1,1);
		printf("x:%u Hiba:%i        ", x, Error);
		lcd_write(0xD4,0,1,1);
		printf("Size:%lu            ", DataSize);
		lcd_write(0x80,0,1,1);
					
		if(ResultOK){	// Ha van adat
			ResultOK = 0;
			PORTB = Result;
			//Result=0;
			TXREG = 0xff;
			while(!PIR1bits.TXIF);
			x++;
		}
					
		Wait++;
		if(Wait>1000){ upload = 0; }
		//Delay1KTCYx(10);
		Delay_ms(10);			
	}//while
	
}//main

/*********************************************
+		Ksleltets
**********************************************/
void Delay_ms(unsigned int ms){ //Bemenet*ms vrakozs
   unsigned int i=0;
   for (i=0;i<=ms;i++) Delay1KTCYx(10);
}

void init_usart(void){
	TRISC = 0b10000000;
	TXSTA = 0b00100100;
	RCSTA = 0b00010000;
	//Baud rate kiszmolsa (pl:9600 baud rate)
	/*((FOSC/Desired Baud Rate)/64)  1
	= ((40000000/9600)/64)  1
	= 64*/
	SPBRG = 21;	// 115200
	RCSTAbits.SPEN = 1;
}
void write_uart(unsigned char data){
	TXREG = data;
	while(!PIR1bits.TXIF);
}
unsigned char read_uart(void){
	RCSTAbits.CREN = 1;
	while(!PIR1bits.RCIF);
	return RCREG;
}
