#ifdef   __18CXX
#include <p18cxxx.h>
#include "uart.h"

//=============================================================================
void main()
{
  unsigned char c;
  UartInit();
  while(1)
  {
    if(uRxLength)
    {
      c = UartRx();
      c++;
      if(uTxBufFree)
        UartTx(c);
    }
  }
}

//=============================================================================
#pragma code
#pragma interrupt YourHighPriorityISRCode
void YourHighPriorityISRCode()
{
  UartRxIntProcess();
  UartTxIntProcess();
}

//==============================================================================
#pragma interruptlow YourLowPriorityISRCode
void YourLowPriorityISRCode()
{
}

//==============================================================================
#pragma code InterruptVectorHigh = 0x08
void InterruptVectorHigh(void)
{
  _asm goto YourHighPriorityISRCode _endasm
}

//==============================================================================
#pragma code low_vector_section = 0x18
void InterruptVectorLow(void)
{
  _asm goto YourLowPriorityISRCode _endasm
}
