//==============================================================================
// bufferelt UART be/ki driver by Roberto Benjami v0.8
//
// az Uart paramtereket itt lehet belltani
// - Inicializls: UartInit()
// - Vtel: ch = UartRx() (csak akkor ad rtkelhet eredmnyt, ha a hvs eltt uRxLength > 0)
// - Ads: UartTx(unsigned char ch) (ha a hvs eltt uTxBufFree == 0 -> nem rdemes elkldeni, mert meg van telve)
// - polling zemmd esetn a f programhurokban hivogatni: UartRxProcess(), UartTxProcess()
// - megszaktsbl: UartRxIntProcess(), UartTxIntProcess()
// - a tlcsordulst tudja jelezni a driver (uRxBufferOverFlow, uTxBufferOverFlow)
// - tlcsorduls esetn neknk kell nullzni a tlcsordils jelzst
//   (a driver mkdshez ez nem szksges, csak neknk jelent plusz inft, ha rteslnk a tlcsordulsrl)

#ifndef __UART_H
#define __UART_H

//------------------------------------------------------------------------------
// Rendszer rajel (UART oszt belltshoz)
#define SystemClock   40000000

//------------------------------------------------------------------------------
// Soros port kvnt sebessge
#define BAUDRATE      9600

//------------------------------------------------------------------------------
// csak 8 bites sebessgbellt regiszterrel rendelkezik a PIC
// (ha 16 bites, azaz ltezik SPBRGH regiszter is, akkor kommenteljk ki)
#define UBRG8BIT

//------------------------------------------------------------------------------
// Vteli buffer mrete (0, 4, 8, 16, 32, 64, 128, 256)
// - ha 0, akkor a vtel tiltva lesz, a vteli fggvnyek nem lesznek lefordtva
#define URXBUFFERSIZE 64

//------------------------------------------------------------------------------
// Ads buffer mrete (0, 4, 8, 16, 32, 64, 128, 256)
#define UTXBUFFERSIZE 64
// - ha 0, akkor az ads tiltva lesz, az adshoz tartoz fggvnyek nem lesznek lefordtva

//------------------------------------------------------------------------------
// Vteli s ads buffer cme
// - ha nem adjuk meg, a fordtprogramra bzzuk
// - ha csak a vtelt adjuk meg, az adst kzvetlen utna cmzi
// #define URXBUFFERADDR 0x600
// #define UTXBUFFERADDR 0x700

//------------------------------------------------------------------------------
// Uart lbak I/O belltsa (inicializlskor)
#ifdef   __18CXX
#define UARTRX(f)   f(C, 7)
#define UARTTX(f)   f(C, 6)
#else
#define UARTRX        C, 7
#define UARTTX        C, 6
#endif

//------------------------------------------------------------------------------
// megszaktsos zemmd engedlyezse (kln a vtelhez s az adshoz)
#define UARTRXINTMODE
#define UARTTXINTMODE

//------------------------------------------------------------------------------
// UART inicializlskor trtnjen meg a globlis IRQ engedlyezse is
#define UARTINITGLOBALIRQENG

//------------------------------------------------------------------------------
// melyik priorits megszaktst hasznlja a soros port
// lehetsges rtkei:
// - -1 : nincs a tbbszint priorits hasznlva (ilyenkor minden a HIGH interruptban megy)
// -  0 : tbbszint priorits engedlyezve, alacsony priorits
// -  1 : tbbszint priorits engedlyezve, magas priorits
#define RXPR18        -1
#define TXPR18        -1

//------------------------------------------------------------------------------
// Teszt (vteli buffer programbl is fetlthet lesz, ha engedlyezzk)
// #define UARTDEBUG

//==============================================================================
// Innentl kezdve nem kell belenylni !
//
//==============================================================================
#if URXBUFFERSIZE != 0
extern volatile unsigned char uRxLength; // vteli bufferban lev byte-ok szma
extern volatile unsigned char uRxBufFree;// vteli bufferben mennyi a szabad hely
extern volatile char uRxBufferOverFlow;  // vteli buffer tlcsorduls (eldobott adat)
#else   // #if URXBUFFERSIZE != 0
#define uRxLength 0
#define uRxBufFree 0
#define uRxBufferOverFlow 0
#endif  // #if URXBUFFERSIZE != 0

#if UTXBUFFERSIZE != 0
extern volatile unsigned char uTxLength; // ads bufferben lev byte-ok szma
extern volatile unsigned char uTxBufFree;// ads bufferben mennyi a szabad hely
extern volatile char uTxBufferOverFlow;  // ads buffer tlcsorduls (eldobott adat)
#else   // #if UTXBUFFERSIZE != 0
#define uTxLength 0
#define uTxBufFree 0
#define uTxBufferOverFlow 0
#endif  // #if UTXBUFFERSIZE != 0

void UartInit(void);                   // inicializls

#if URXBUFFERSIZE != 0
unsigned char UartRx(void);            // egy karakter vtele (ha van mit)
unsigned char UartRxTop(void);         // a vteli buffer legelsnek berakott eleme, de nem trldik a bufferbl
void UartRxProcess(void);              // uart vtel polling vagy megszakts kiszolgl fggvny
#define UartRxIntProcess() if(PIE1bits.RCIE && PIR1bits.RCIF)UartRxProcess()
#ifdef  UARTDEBUG
void UartRxWrite(unsigned char ch);    // tesztelshez fel lehet tlteni a vteli buffert
#else
#define UartRxWrite(ch)  ;
#endif
#else   // #if URXBUFFERSIZE != 0
#define UartRx() 0
#define UartRxTop() 0
#define UartRxWrite(ch)  ;
#define UartRxProcess() ;
#define UartRxIntProcess() ;
#endif  // #if URXBUFFERSIZE != 0

#if UTXBUFFERSIZE != 0
void UartTx(unsigned char ch);         // egy karakter kldse (bufferelt mdon)
void UartTxProcess(void);              // uart ads polling vagy megszakts kiszolgl fggvny
#define UartTxIntProcess() if(PIE1bits.TXIE && PIR1bits.TXIF)UartTxProcess()
#else   // #if UTXBUFFERSIZE != 0
#define UartTx(ch) ;
#define UartTxProcess() ;
#define UartTxIntProcess() ;
#endif  // #if UTXBUFFERSIZE != 0

#endif // __UART_H
