unsigned char chk_busy;
unsigned char i,ch;
const rom unsigned char betwk[] = {0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,		// - [0x00]
                                   0x00,0x00,0x01,0x02,0x14,0x08,0x00,0x00,		// pipa
                                   0xe,0x11,0x11,0x11,0xa,0xa,0x4,0x4,			// Cm
									0x0,0x17,0x0,0x17,0x7,0x0,0x17,0x0,			// Adat
                                   0x02,0x04,0x11,0x11,0x11,0x13,0x0D,0x00,		//
                                   0x0A,0x00,0x11,0x11,0x11,0x13,0x0D,0x00,		//
                                   0x05,0x0A,0x11,0x11,0x11,0x13,0x0D,0x00,		//
                                   0x05,0x0A,0x0E,0x11,0x11,0x11,0x0E,0x00};	//

//#define CLOCK_FREQ 48000000
//-- A hardverfgg rszletek elklntse
#define RSHIGH()         LATD |= 0x01;
#define RSLOW()          LATD &= 0xFE;
#define RWHIGH()         LATD |= 0x02;
#define RWLOW()          LATD &= 0xFD;
#define EHIGH()          LATD |= 0x04;
#define ELOW()           LATD &= 0xFB;
#define BUSY_FLAG PORTDbits.RD7;
#define DATA_DIR_RD()    TRISDbits.TRISD4 = 1; TRISDbits.TRISD5 = 1;  TRISDbits.TRISD6 = 1; TRISDbits.TRISD7 = 1;
#define DATA_DIR_WR()    TRISDbits.TRISD4 = 0; TRISDbits.TRISD5 = 0;  TRISDbits.TRISD6 = 0; TRISDbits.TRISD7 = 0;
#define OUTPUT_DATA(x) {LATD = (LATD & 0x0F) | x;} //4 als bit magas szintre lltva

//-- Az E vezrljel pulzlsa 
void epulse(void){
    Delay10TCYx(2);  
    EHIGH();  Delay10TCYx(2); 
    ELOW(); Delay10TCYx(1);
}

//-- Egy bjt (parancs vagy adat) kirsa
void lcd_write(unsigned char cmd, 
               unsigned char data_flag, 
               unsigned char chk_busy, 
               unsigned char dflag){
char bflag,c;
  if (chk_busy) {
    RSLOW();                 //RS = 0 a foglaltsg figyelshez
    DATA_DIR_RD();           //adatvonalak vtelre lltsa
    RWHIGH();                //R/W = 1 olvasshoz
    do {
      EHIGH(); 
      Delay10TCYx(2);
      bflag = BUSY_FLAG;     //fels 4 bit olvassa
      ELOW(); Delay10TCYx(2);
      epulse();              //als flbjt kilptetse
    } while(bflag);
  } else {
    Delay10KTCYx(12);        //Foglaltsg figyels helyett ksleltets
  }
  DATA_DIR_WR();             //Adatvonalak rsra lltsa
  if (data_flag) { 
    RSHIGH();                //RS=1, ha adatklds kvetkezik
  }
  else RSLOW();              //RS=0, ha parancsot kldnk
  RWLOW();                   //R/W = 0, rshoz
  c = cmd & 0xF0;            //fels 4 bit kirsa
  OUTPUT_DATA(c);
  epulse();
  if (dflag) {
    c = (cmd & 0x0F)<<4;     //als 4 bit kirsa
    OUTPUT_DATA(c);
    epulse();
  }
}

//-- Az LCD modul inicializlsa
void lcd_init(void) {
//-- Az LCD-t vezrl vonalak inicializlsa
  DATA_DIR_WR();
  ELOW();
  RSLOW();
  RWLOW(); 
//-- Az LCD modul szoftveres reset-else s inicializlsa
  Delay10KTCYx(60);          //50 ms vrakozs az LCD felledsre 
  lcd_write(0x30,0,0,0);     //8 bites zemmd      
  Delay10KTCYx(6);           //5 ms vrakozs
  lcd_write(0x30,0,0,0);     // 4 bites zemmd
  lcd_write(0x30,0,0,0);     // 8 bites zemmd
  lcd_write(0x20,0,0,0);     // 4 bites zemmdba kapcsolunk
//-- Innen kezdve a 4 bites zemmd l (kldsnl dflag=1 kell)
  lcd_write(0x28,0,0,1);     // 2 soros display, 5x7 font
//-- Innen kezdve figyelhet a BF jelzbit (chk_busy=1)
  lcd_write(0x08,0,1,1);     // display letilts
  lcd_write(0x01,0,1,1);     // kpernytrls
  lcd_write(0x0C,0,1,1);     // display be, cursor, s villogs ki
  stdout = _H_USER;          // a felhasznli fggvny legyen a
                             // standard kimenet, ami az LCD-re r
}

void lcd_init_cgram(void) {
    lcd_write(0x40,0,1,1);  // kurzor a CGRAM elejre
    for(i=0; i<64; i++) {
      lcd_write(betwk[i],1,1,1);    // definilhat karakterek feltltse
    }                               // kezetes karakterekkel
    lcd_write(0x80,0,1,1);          // kurzor vissza, a DDRAM elejre	
}

//-- LCD-re egy karaktert kir fggvny a _H_USER stream szmra
void _user_putc(char cx) {
    switch(cx) {
	    case '':  cx = 0x00; break;
	    case '':  cx = 0x01; break;
	    case '':  cx = 0x02; break;
	    case '':  cx = 0x03; break;
	    case '':  cx = 0x04; break;
	    case '':  cx = 0x05; break;
	    case '':  cx = 0x06; break;
	    case '':  cx = 0x07; break;
	    case '':  cx = 0xEF; break;
    } 
    lcd_write(cx,1,1,1);
}

void lcd_clear(void){
	printf("                    ");
	lcd_write(0xC0,0,1,1);   
	printf("                    ");
	lcd_write(0x94,0,1,1);
	printf("                    ");
	lcd_write(0xD4,0,1,1);
	printf("                    ");
	lcd_write(0x80,0,1,1);  
}

void lcd_clear(void);

