
//#define _DIRECT_DRIVE

#include <pwm.h>
#include <timers.h>
#include <math.h>

#include "Compiler.h"
#include "GenericTypeDefs.h"

#include "user.h"
#include "sensors.h"

#include <p18cxxx.h>  // for Nop()

#define DELAY Nop(); Nop(); Nop();


#pragma udata



// these reflect the value of the potentiometers 
// that define the pwm frequency and define the 
// desired speed of the motor. 

extern unsigned int SENSOR_DC; // pwm frequency
extern volatile unsigned char timer0_cycle;

       

// Timer2 prescale and PR of 255 yields 11.72 kHz pwm frequency
#define T2_PRE_SCALE    T2_PS_1_4    // 1:1, 1:4, 1:16
#define DEFAULT_PWM_PR2 255
#define DEFAULT_PWM_DC  512


#pragma code

static unsigned int DIFF(unsigned int A, unsigned int B)
  {
     if (A>B) return (A-B);
     return (B-A);
  }


          
void UserInit(void)
  { 
    P_PHASE_TRIS;
    P_HALL_TRIS;
    
    PHASE_A_OFF;
    PHASE_B_OFF;
    PHASE_C_OFF;
    
    sensors_init();    
    
    // timer 0 serves as a "wall clock"
    OpenTimer0( 
        TIMER_INT_ON & 
        T0_SOURCE_INT &
        T0_16BIT &
        T0_PS_1_32
      );  
      // 1_32 => 0.17476267 seconds for overflow
      // 228 Hz => 228 cycles/second * 0.17476267 seconds/overflow =  40 cycles/overflow
          
    
    // http://www.camotruck.net/rollins/electronics/pic_timer.html    
    // PWM Period   = [(PR2) + 1]  4  TOSC  (TMR2 Prescale Value) 

    // Timer2 works with the PWM system.
    OpenTimer2( 
        TIMER_INT_OFF & 
        T2_PRE_SCALE
      ); 
      
    OpenPWM1( DEFAULT_PWM_PR2 ); // 0 to 255
    SetDCPWM1(DEFAULT_PWM_DC);   // 0 to 1023

    INTCON=0;    //make sure interrupts are disable
    INTCONbits.GIE=1;  //enable global interrupts
    INTCONbits.PEIE=1;  //enable peripheral interrupts
    INTCONbits.TMR0IE=1; //enable TMR0 overflow interrupt enable bit
    //INTCON=0xe0;   //all 4 lines above combined
    
    
    INTCONbits.RBIE=0; // DON'T! enable port B interrupts.
    INTCON2bits.RBIP=0; // this relates to the KB interrupts!
   
    //TRISBbits.TRISB1 = 1;    // make RB1 and input
    //INTCON3bits.INT1IE = 1;  // enable the interrupt for INT1/RB1
    INTCON3bits.INT1IE  = 0;  // disable the interrupt for INT1/RB1
    INTCON3bits.INT2IE  = 0;  // disable the interrupt for INT2/RB2
    
    // PWM pin is #17 (RC2/CCP1/P1A)
    
    ECCP1DEL = 0; // clear out this register
    ECCP1DELbits.PRSEN = 1;  // set the event to auto-clear
    
    TRISBbits.TRISB0   = 1;  // make RB0 and input
    INTCONbits.INT0IE  = 1;  // enable the interrupt for INT0/RB0
            
    CCP1ASbits.ECCPAS2 = 1;  // use FLT0 (INT0/RB0)
    CCP1ASbits.ECCPAS1 = 0;  // this will auto-shutdown if value at
    CCP1ASbits.ECCPAS0 = 0;  // RB0 is low.
    
    CCP1ASbits.PSSAC1 = 0;   // PWM low  => 0/1
    CCP1ASbits.PSSAC0 = 1;   // PWM high => 0/0
    
  }//end UserInit


/*  STATE     HALL_A  HALL_B  HALL_C   PHASE_A  PHASE_B  PHASE_C
 *  0           0       1       1        0        +        -
 *  1           0       0       1        +        0        -
 *  2           1       0       1        +        -        0
 *  3           1       0       0        0        -        +
 *  4           1       1       0        -        0        +
 *  5           0       1       0        -        +        0
 */
     
/*
 * HALL: Green, Yellow, Blue 
 * MOTOR: Blue, Yellow, Green 
 */
     
static int hall_state(void)
  {
   if (HALL_A)
     {             
       // state 2 3 4 
       if (HALL_B)
         {
           // state 4
           return 4;
         }
       else
         {
           // state 2 3
           if (HALL_C)
             // state 2
             return 2;
           else
             return 3;
         }
     }
   else
     {
       // state 0 1 5
       if (HALL_B)
         {
           //state 0 5
           if (HALL_C)
             return 0;
           else
             return 5;
         }
       else
         {
           //state 1
           return 1;
         }
     }   
  }

void UserMain(void)
  {
    int pwm_dc_old = 0;   
    int pwm_dc_new = 0;
    
    int hs = 0;
 
    while(1)
      {
        sensors_update();

        // check to see if we should update the PWM Duty Cycle
        pwm_dc_new = SENSOR_DC;

        if (DIFF(pwm_dc_old,pwm_dc_new)>2u)
          { 
            SetDCPWM1(pwm_dc_new); 
            pwm_dc_old = pwm_dc_new;
          }
          
        // move to the next state
        hs = (hall_state() + 1)% 6;
            
        switch (hs)
          {
            case 0:  PHASE_A_OFF; DELAY; PHASE_B_HOT; DELAY; PHASE_C_GND; break;
            case 1:  PHASE_A_HOT; DELAY; PHASE_B_OFF; DELAY; PHASE_C_GND; break;
            case 2:  PHASE_A_HOT; DELAY; PHASE_B_GND; DELAY; PHASE_C_OFF; break;
            case 3:  PHASE_A_OFF; DELAY; PHASE_B_GND; DELAY; PHASE_C_HOT; break;
            case 4:  PHASE_A_GND; DELAY; PHASE_B_OFF; DELAY; PHASE_C_HOT; break;
            case 5:  PHASE_A_GND; DELAY; PHASE_B_HOT; DELAY; PHASE_C_OFF; break;            
          }
            
           
      }
  }