
#ifndef __MY_HARDWARE_H_
#define __MY_HARDWARE_H_


#include <p18f4550.h>

#define PTR_BASE          WORD	
#define	__attribute__(a)
#define ROM               rom
#define strcpypgm2ram(a, b)    strcpypgm2ram(a,(far rom char*)b)

/* Valid Options: 8, 16, 32, or 64 bytes. */
#define EP0_BUFF_SIZE    8

#define USB_MAX_EP_NUMBER    1

#include "GenericTypeDefs.h"
#include "USB/usb_device.h"
#include "USB/usb.h"
#include "USB/usb_function_generic.h"

#define U1ADDR UADDR
#define U1IE UIE
#define U1IR UIR
#define U1EIR UEIR
#define U1EIE UEIE
#define U1CON UCON
#define U1EP0 UEP0
#define U1CONbits UCONbits
#define U1EP1 UEP1
#define U1CNFG1 UCFG
#define U1STAT USTAT
#define U1EP0bits UEP0bits

#endif



//	The USB specifications require that USB peripheral devices must never source
//	current onto the Vbus pin.  Additionally, USB peripherals should not source
//	current on D+ or D- when the host/hub is not actively powering the Vbus line.
//	When designing a self powered (as opposed to bus powered) USB peripheral
//	device, the firmware should make sure not to turn on the USB module and D+
//	or D- pull up resistor unless Vbus is actively powered.  Therefore, the
//	firmware needs some means to detect when Vbus is being powered by the host.
//	A 5V tolerant I/O pin can be connected to Vbus (through a resistor), and
// 	can be used to detect when Vbus is high (host actively powering), or low
//	(host is shut down or otherwise not supplying power).  The USB firmware
// 	can then periodically poll this I/O pin to know when it is okay to turn on
//	the USB module/D+/D- pull up resistor.  When designing a purely bus powered
//	peripheral device, it is not possible to source current on D+ or D- when the
//	host is not actively providing power on Vbus. Therefore, implementing this
//	bus sense feature is optional.  This firmware can be made to use this bus
//	sense feature by making sure "USE_USB_BUS_SENSE_IO" has been defined in the
//	HardwareProfile.h file.    

/** TRIS ***********************************************************/
#define INPUT_PIN           1
#define OUTPUT_PIN          0

/** USB ************************************************************/

// MIKE: Select one of these two for the self vs bus power:
// self power = power provided by usb
// bus sense = battery powered
//#define USE_SELF_POWER_SENSE_IO	
/*
#define USE_USB_BUS_SENSE_IO

#define tris_usb_bus_sense  TRISDbits.TRISD4    // Input
#define USB_BUS_SENSE       PORTDbits.RD4   
#define tris_self_power     TRISDbits.TRISRD4    // Input
#define self_power          1
*/

#define USE_USB_BUS_SENSE_IO

// MIKE: change this from TRISAbits.TRISA1/PORTAbits.RA1 to RD3 or RD2
#define tris_usb_bus_sense  TRISDbits.TRISD4    // Input
    
#if defined(USE_USB_BUS_SENSE_IO)
    #define USB_BUS_SENSE       PORTDbits.RD4
#else
    #define USB_BUS_SENSE       1
#endif
    
#define tris_self_power     TRISDbits.TRISRD4    // Input
    
#if defined(USE_SELF_POWER_SENSE_IO)
    #define self_power          PORTDbits.RD4
#else
    #define self_power          1
#endif
    