
#include <timers.h>


#include <p18f4550.h>
#include <pwm.h>

#include "GenericTypeDefs.h"

#include "user.h"                    
#include "sensors.h"

/* You will need to configure these for your oscillator */
#pragma config PLLDIV=5
#pragma config CPUDIV=OSC1_PLL2
#pragma config USBDIV=2
#pragma config FOSC=HSPLL_HS

#pragma config FCMEN=OFF
#pragma config IESO=OFF
#pragma config VREGEN=OFF
#pragma config CCP2MX=ON

#pragma config WDT=OFF
#pragma config WDTPS=32768

#pragma config PBADEN=OFF
#pragma config PWRT=OFF
#pragma config MCLRE=ON
#pragma config LPT1OSC=OFF
#pragma config BOR=ON		
#pragma config BORV=1
#pragma config STVREN=ON
#pragma config LVP=OFF
#pragma config ICPRT= OFF
#pragma config XINST=OFF
#pragma config DEBUG=OFF
#pragma config WRTB=ON




/** VARIABLES ******************************************************/
#pragma udata

volatile unsigned char timer0_cycle = 0u;

/** PRIVATE PROTOTYPES *********************************************/
void YourHighPriorityISRCode(void);
void YourLowPriorityISRCode(void);


/** VECTOR REMAPPING ***********************************************/
#define REMAPPED_HIGH_INTERRUPT_VECTOR_ADDRESS	0x08
#define REMAPPED_LOW_INTERRUPT_VECTOR_ADDRESS	0x18

#pragma code REMAPPED_HIGH_INTERRUPT_VECTOR = REMAPPED_HIGH_INTERRUPT_VECTOR_ADDRESS
void Remapped_High_ISR (void)
  {
     _asm goto YourHighPriorityISRCode _endasm
  }
#pragma code REMAPPED_LOW_INTERRUPT_VECTOR = REMAPPED_LOW_INTERRUPT_VECTOR_ADDRESS
void Remapped_Low_ISR (void)
  {
     _asm goto YourLowPriorityISRCode _endasm
  }

#pragma code

#pragma interrupt YourHighPriorityISRCode
void YourHighPriorityISRCode()
  {
    static int dummy;
    
		//Check which interrupt flag caused the interrupt.

    // FLT0/INT0
    if (INTCONbits.INT0IF)
      {
        INTCONbits.INT0IF = 0; // clear the interrupt
      }

  	// TMR0 Overflow
  	if (INTCONbits.TMR0IF)
  	  {        
   		  INTCONbits.TMR0IF = 0;     // clear the interrupt
   		  timer0_cycle = 1;  
   		}
  
  }	//This return will be a "retfie fast", since this is in a #pragma interrupt section 
#pragma interruptlow YourHighPriorityISRCode
void YourLowPriorityISRCode()
  {
  }	//This return will be a "retfie", since this is in a #pragma interruptlow section 

/**************************************************************************************************/

#pragma code

void main(void)
  {  

    LED_TRIS;
    LED_GREEN_ON;
        
    UserInit();
    
    UserMain();
  }
