

#include <p18f4550.h>
#include <adc.h>
#include "sensors.h"
#include "user.h"
#include "GenericTypeDefs.h"


#define CH_DC   ADC_CH0
#define CH_TICKS    ADC_CH1           

#define STATE_DC_NEW    1        
#define STATE_DC_BUSY   2
#define STATE_DC_READ   3 /* removed for performance */

#define STATE_TICKS_NEW      4        
#define STATE_TICKS_BUSY     5
#define STATE_TICKS_READ     6 /* removed for performance */



#pragma udata

unsigned int SENSOR_DC=0u;
unsigned int SENSOR_TICKS=0u;


static unsigned char state = STATE_DC_NEW; // private variable
    
#pragma code

void sensors_init(void)
  {
    // Initialize voltage sensors
    OpenADC( 
        ADC_FOSC_64 // clock
        & ADC_RIGHT_JUST //Results in least significant bits
        & ADC_20_TAD // collection time interval
        ,
        CH_DC & CH_TICKS
        & ADC_INT_OFF // not interrupts (use polling)
        & ADC_VREFPLUS_VDD // use +5 for reference voltage
        & ADC_VREFMINUS_VSS // use 0 for reference
        ,
        13 // bits 0 through "n" of the ADCON1 register
      );
      
  }


void sensors_update(void)
  {
    // Modify this to check on the voltage or only the current
    switch (state)
      {
        case STATE_DC_NEW:
            SetChanADC( CH_DC );
            ConvertADC(); 
            state = STATE_DC_BUSY;            
          break;
                    
        case STATE_DC_BUSY:
            if (BusyADC()) break;
            state = STATE_DC_READ;
          break;
        
        case STATE_DC_READ:
            SENSOR_DC = ReadADC();
            state = STATE_TICKS_NEW; 
          break; 

        case STATE_TICKS_NEW:
            SetChanADC( CH_TICKS );
            ConvertADC(); 
            state = STATE_TICKS_BUSY;            
          break;
          
        case STATE_TICKS_BUSY:
            if (BusyADC()) break;
            state = STATE_TICKS_READ;
          break;
        
        case STATE_TICKS_READ:
            SENSOR_TICKS = ReadADC();
            state = STATE_DC_NEW; 
          break; 

      }
  }
  

