

#ifndef _USER_H
#define _USER_H


#include "GenericTypeDefs.h"


#define P_CH   PORTBbits.RB5
#define P_CL   PORTBbits.RB4
#define P_BH   PORTBbits.RB3
#define P_BL   PORTBbits.RB2
#define P_AH   PORTDbits.RD3   
#define P_AL   PORTDbits.RD2    

#define P_ON   1
#define P_OFF  0

#define PHASE_A_OFF  P_AL = P_OFF; P_AH = P_OFF;
#define PHASE_A_HOT  P_AL = P_OFF; P_AH = P_ON;
#define PHASE_A_GND  P_AH = P_OFF; P_AL = P_ON;

#define PHASE_B_OFF  P_BL = P_OFF; P_BH = P_OFF;
#define PHASE_B_HOT  P_BL = P_OFF; P_BH = P_ON;
#define PHASE_B_GND  P_BH = P_OFF; P_BL = P_ON;

#define PHASE_C_OFF  P_CL = P_OFF; P_CH = P_OFF;
#define PHASE_C_HOT  P_CL = P_OFF; P_CH = P_ON;
#define PHASE_C_GND  P_CH = P_OFF; P_CL = P_ON;

#define P_PHASE_TRIS TRISBbits.TRISB5 = 0; \
                     TRISBbits.TRISB4 = 0; \
                     TRISBbits.TRISB3 = 0; \
                     TRISBbits.TRISB2 = 0; \
                     TRISDbits.TRISD3 = 0; \
                     TRISDbits.TRISD2 = 0;


// D0 = 19
// D1 = 20
// D4 = 27
#define P_HALL_A   PORTDbits.RD1
#define P_HALL_B   PORTDbits.RD0
#define P_HALL_C   PORTDbits.RD4 

// off is 1
// on is 0
#define HALL_HI    1u
#define HALL_LO    0u

#define HALL_A     (P_HALL_A == HALL_HI)
#define HALL_B     (P_HALL_B == HALL_HI)
#define HALL_C     (P_HALL_C == HALL_HI)

#define P_HALL_TRIS TRISDbits.TRISD0 = 1; \
                    TRISDbits.TRISD1 = 1; \
                    TRISDbits.TRISD4 = 1; 


void UserInit(void);
void UserMain(void);


#define LED_ON   1u
#define LED_OFF  0u

#define LED_TRIS TRISCbits.TRISC7 = 0

#define LED_GREEN       PORTCbits.RC7
#define LED_GREEN_ON    LED_GREEN=LED_ON
#define LED_GREEN_OFF   LED_GREEN=LED_OFF
#define LED_GREEN_FLIP  PORTCbits.RC7 = !LATCbits.LATC7 

#endif 
