#ifndef _C_TMR_H_
#define _C_TMR_H_

#include "c_main.h"
#include "i_io.h"
#include "i_app.h"
#include "i_main.h"
#include "i_sio.h"
#include "i_led.h"
#include "i_spi.h"
#include "i_io.h"
#include "i_iic_master.h"
#include "i_usb.h"
#include "i_nrf24l01.h"
#include "i_task.h"
#include "i_eep_manager.h"
#include "i_bmp085.h"
#include "i_lcd_driverhd44780.h"
#include "i_SHT1x.h"
#include "i_rtc.h"
#include "i_ad.h"

#define TIMERCNT 8 //number how much timers are supported
#define PRESCALE       		256

#ifndef SYS_FREQ
	#error SYS_FREQ not defined
#endif
#ifndef PB_DIV
	#error PB_DIV not defined
#endif
#ifndef PRESCALE
	#error PRESCALE not defined
#endif

#define PR1_CONFIG	(SYS_FREQ/PB_DIV/PRESCALE/1000)
#define PR2_CONFIG	(SYS_FREQ/PB_DIV/PRESCALE/10000)

#define TMR1_FUNCTIONS()		isr_io1ms();\
					isr_app1ms();\
					isr_task1ms();\
					isr_main_1ms();\
					isr_sio1ms();\
					isr_led1ms();\
					isr_io1ms();\
					isr_eepmanager1ms();\
					isrSHT_TimeOut_1ms();\
					isr_lcd1ms();\
					isr_usb1ms();\
					isr_iic_master1ms();\
					isr_bmp085_1ms();\
					isr_nrf24l01_1ms();\
					isr_rtc_1ms();\
					isr_ad_1ms();\
					isr_spi_1ms();
#define TMR2_FUNCTIONS()		isr_app100us();\
								isr_lcd_driver100us();
#define TMR3_FUNCTIONS()		isr_appCustom();

#endif
