#ifndef _C_LCD_HD44780_PINS_H_
#define _C_LCD_HD44780_PINS_H_

	#error You have included an example configuraton of c_lcd_driverhd44780.h

#define LCD_PORT_SYNC() Nop();Nop();Nop();Nop()
#define LCD_ASYNC_INIT
#define LCD_ASYNC_INTERFACE
#define LCD_ASYNC_INTERFACE_ITEMS 32
#define LCD_DELAY_TIME 500
#define LCD_USE_BACKLIGHT
#define LCD_USE_USER_BACKLIGHT

//#define LCD_1_LINE
#define LCD_2_LINE

//Port labak
#define		LCD_DATA7_TRIS	TRISBbits.TRISB0	//UPPER NIBBLE
#define		LCD_DATA6_TRIS	TRISBbits.TRISB1	//UPPER NIBBLE
#define		LCD_DATA5_TRIS	TRISBbits.TRISB2	//UPPER NIBBLE
#define		LCD_DATA4_TRIS	TRISBbits.TRISB3	//UPPER NIBBLE

#define		LCD_PORT7		PORTBbits.RB0
#define		LCD_PORT6		PORTBbits.RB1
#define		LCD_PORT5		PORTBbits.RB2
#define		LCD_PORT4		PORTBbits.RB3

#define		LCD_LAT7		LATBbits.LATB0
#define		LCD_LAT6		LATBbits.LATB1
#define		LCD_LAT5		LATBbits.LATB2
#define		LCD_LAT4		LATBbits.LATB3

#define		E_TRIS			TRISAbits.TRISA2		// LCD Enable control line
#define		E_PORT			PORTAbits.RA2		// LCD Enable control line
#define		E_LAT			LATAbits.LATA2		// LCD Enable control line

#define		R_W_TRIS		TRISAbits.TRISA1		// LCD Read/Write control line
#define		R_W_PORT		PORTAbits.RA1		// LCD Read/Write control line
#define		R_W_LAT			LATAbits.LATA1		// LCD Read/Write control line

#define		RS_TRIS			TRISAbits.TRISA0		// LCD Register Select control line
#define		RS_PORT			PORTAbits.RA0		// LCD Register Select control line
#define		RS_LAT			LATAbits.LATA0		// LCD Register Select control line

	#ifdef LCD_USE_BACKLIGHT
		#ifndef LCD_USE_USER_BACKLIGHT
			#define		BACKLIGHT_TRIS	TRISDbits.TRISD1
			#define 	BACKLIGHT		PORTDbits.RD1
			#define		BACKLIGHT_TRIS	TRISDbits.TRISD1
		#else
			extern void lcd_backlight_on(void);
			extern void lcd_backlight_off(void);
		#endif
	#else
		#define 	BACKLIGHT		noPort
		#define		BACKLIGHT_TRIS	noPort
	#endif

#endif
