#ifndef _MAL_H_
#define _MAL_H_

#include	<p32xxxx.h>
#include <plib.h>

	typedef enum _ResetReason {
		ResetReason_Unknown = 0,
		ResetReason_Power_on_Reset,
		ResetReason_Brown_out_Reset,
		ResetReason_MCLR_reset_during_normal_operation,
		ResetReason_Software_reset_during_normal_operation,
		ResetReason_MCLR_reset_during_sleep,
		ResetReason_MCLR_reset_during_idle,
		ResetReason_WDT_Time_out_reset,
		ResetReason_Configuration_Word_Mismatch_Reset,
	} ResetReason;

	extern volatile unsigned int gieTemp;
	extern volatile unsigned int isrLockCnt;

	#define MAL_NOP() Nop()

	#ifndef ClrWdt
		#define ClrWdt()	WDTCONSET = 0x0001;
	#endif
	
	#define lock_isr() 	{isrLockCnt++; gieTemp = INTDisableInterrupts();}
	#define unlock_isr() {INTRestoreInterrupts(gieTemp); isrLockCnt--;}

	extern void mal_reset(void);
	extern ResetReason mal_reset_reason(void);
	
#endif
