#ifndef _DS18B20_H_
#define _DS18B20_H_

#include "onewire.h"

#define DS18B20_FAMILY_CODE			0x28

#define DS18B20_CONVERT_T			0x44
#define DS18B20_WRITE_SCRATCHPAD	0x4E
#define DS18B20_READ_SCRATCHPAD		0xBE
#define DS18B20_COPY_SCRATCHPAD		0x48
#define DS18B20_RECALL_EE			0xB8
#define DS18B20_READ_POWER_SUPPLY	0xB4	

typedef struct _DS18B20_device_struct {
	uint16 temperature;
	uint8 thigh;
	uint8 tlow;
	uint8 configuration;
	uint8 reserved1;	//0xFF
	uint8 reserved2;
	uint8 reserved3;	//0x10
	uint8 crc;
} DS18B20_device_struct;

typedef union _DS18B20_device {
	DS18B20_device_struct value;
	uint8 byte[8];
	uint16 integer[4];
	uint32 longint[2];
} DS18B20_device;

typedef enum _DS18B20_POWERING {
	DS18B20_PARASITIC = 0,
	DS18B20_EXTERNAL_SUPPPLY = 1,
	DS18B20_NO_POWER
} DS18B20_POWERING;

typedef enum _DS18B20_resolution {
	DS18B20_9bit,
	DS18B20_10bit,
	DS18B20_11bit,
	DS18B20_12bit
} DS18B20_resolution;

extern void ds18b20_init(OW_device ow_device);
extern void ds18b20_set_powering(DS18B20_POWERING new_ds18b20_powering);
extern DS18B20_POWERING ds18b20_detect_powering(OW_device ow_device);
extern int ds18b20_get_temperature_nb(OW_device ow_device, float *temperature);
extern void ds18b20_set_resolution(OW_device ow_device, DS18B20_resolution resolution);

extern int ds18b20_get_temperature_nb_restart(OW_device ow_device, float *temperature, uint8 restart);

#endif
