#ifndef _ONEWIRE_H_
#define _ONEWIRE_H_

#include "mal.h"
#include "k_stdtype.h"

#define	HIGH	1
#define	LOW		0
#define	OUTPUT	0
#define	INPUT 	1
#define	SET		1
#define	CLEAR	0

#define OW_SEARCH_ROM		0xF0
#define OW_READ_ROM			0x33
#define OW_MATCH_ROM		0x55
#define OW_SKIP_ROM			0xCC
#define OW_ALARM_SEARCH		0xEC

#define DELAY_6Us	5
#define DELAY_9Us	7
#define DELAY_10Us	8
#define DELAY_55Us	46
#define DELAY_60Us	51
#define DELAY_64Us	54
#define DELAY_70Us	59
#define DELAY_410Us	351
#define DELAY_480Us	411

typedef struct _OW_device_struct {
	uint8 family;
	uint8 serial_number[6];
	uint8 crc;
} OW_device_struct;

typedef union _OW_device {
	OW_device_struct value;
	uint8 byte[8];
} OW_device;

typedef enum _OW_ADDRESSING_MODE {
	OW_SKIP_ROM_ADDRESS,
	OW_MATCH_ROM_ADDRESS
} OW_ADDRESSING_MODE;

extern void drive_OW_low(void);
extern void drive_OW_high(void);
extern uint8 read_OW(void);
extern uint8 OW_reset_pulse(void);
extern void OW_write_bit (uint8 write_bit);
extern uint8 OW_read_bit(void);
extern void OW_write_byte (uint8 write_data);
extern uint8 OW_read_byte(void);
extern void set_OW_addressing_mode(OW_ADDRESSING_MODE new_OW_addressing_mode);
extern void OW_address_device(OW_device ow_device);
extern uint8 OW_read_rom(OW_device *ow_device);

#endif
