#ifndef _RTC_H_
#define _RTC_H_

#include "k_stdtype.h"

typedef struct _TimeDate {
	signed char sec;
	signed char min;
	signed char hour;
	signed char day;
	signed char month;
	signed int year;
	unsigned char dofw_calendar;
	unsigned char week_calendar;
} TimeDate;

extern unsigned int rtcGetTimeDate(TimeDate *ptr);
extern unsigned int rtcSetTimeDate(TimeDate *ptr);

extern void inc_year(TimeDate *ptr);
extern void dec_year(TimeDate *ptr);
extern void inc_month(TimeDate *ptr);
extern void dec_month(TimeDate *ptr);
extern void inc_day(TimeDate *ptr);
extern void dec_day(TimeDate *ptr);
extern void inc_hour(TimeDate *ptr);
extern void dec_hour(TimeDate *ptr);
extern void inc_min(TimeDate *ptr);
extern void dec_min(TimeDate *ptr);
extern void inc_sec(TimeDate *ptr);
extern void dec_sec(TimeDate *ptr);

extern void rtcCalculateWeekAndDay(TimeDate *ptr);

extern void rtcUTCtoLocalTime(TimeDate *ptr, sint8 timeZone, uint8 useDayLightSaving);
extern void rtcLocalTimeToUTC(TimeDate *ptr, sint8 timeZone, uint8 useDayLightSaving);

extern unsigned char is_leap_year(unsigned int year);

#endif
