#ifndef _E_SIO_H_
#define _E_SIO_H_

#include "k_stdtype.h"
#include "c_sio.h"

#define SIO_SEED_LENGTH 4
#define MINIMUM_PACKET_SIZE 12		//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, ChkSum, CrcHL, CrcLH, CrcLL, ... payload .., Stop

#define CMD_START	0x55
#define CMD_END		0xAA

#define PACKET_START_POS 		0
#define PACKET_LENGTHH_POS 		1
#define PACKET_LENGTHL_POS 		2
#define PACKET_ADDRESSH_POS		3
#define PACKET_ADDRESSL_POS		4
#define PACKET_COMMANDH_POS		5
#define PACKET_COMMANDL_POS		6
#define PACKET_CRCHH_POS		7
#define PACKET_CRCHL_POS		8
#define PACKET_CRCLH_POS		9
#define PACKET_CRCLL_POS		10
#define PACKET_PAYLOAD_POS		11

#define SIO_BUFFER_CNT	64			//[byte]

typedef enum _SIO_Commands {
	CMD_VERSIONID 			= 0x0002,	//in: NA											out: VersionH, VersionL
	CMD_VERSIONSTR			= 0x0004,   //in: NA											out: Str
	CMD_RDPARAM 			= 0x0008,	//in: ParamIdxH,ParamIdxL,							out: Value
	CMD_WRPARAM 			= 0x0009,	//in: ParamIdxH,ParamIdxL,Value						out: Value
	CMD_RDPARAMW 			= 0x000A,	//in: ParamIdxH,ParamIdxL,							out: ValueH,ValueL
	CMD_WRPARAMW 			= 0x000B,	//in: ParamIdxH,ParamIdxL,ValueH,ValueL				out: ValueH,ValueL
	CMD_RDPARAML 			= 0x000C,	//in: ParamIdxH,ParamIdxL,							out: Value1..Value4
	CMD_WRPARAML 			= 0x000D,	//in: ParamIdxH,ParamIdxL,Value1..Value4			out: Value1..Value4
	CMD_RDPARAMF 			= 0x001C,	//in: ParamIdxH,ParamIdxL,							out: 4 byte Float //This is not revered
	CMD_WRPARAMF 			= 0x001D,	//in: ParamIdxH,ParamIdxL,4 byte Float				out: 4 byte Float //This is not revered
	CMD_RDPARAMBUF 			= 0x002D,	//in: ParamIdxH,ParamIdxL,							out: Value1..ValueN
	CMD_WRPARAMBUF 			= 0x002E,	//in: ParamIdxH,ParamIdxL,Value1..ValueN			out: Value1..ValueN
	CMD_RESET 				= 0x000F,	//in: NA											out: NA
	CMD_GETSEED				= 0x0047,	//in: NA											out: Data0..Datan
	CMD_CHECKKEY			= 0x0048,	//in: Level, Key									out: Result
	CMD_GETVALIDID			= 0x0049,   //in: NA											out: Data0..Datan
} SIO_Commands;

typedef enum _SIO_COM {
	SIO_RS232,
	SIO_I2C,
	SIO_CAN,
	SIO_RADIO,
	SIO_USB,
	SIO_RADIO_ESP8266,
	SIO_GSM_SMS,
	SIO_TEST,
} SIO_COM;

typedef struct _SioParamIDXs {
	int idx;
	unsigned int * ptr;
	#ifdef SIO_ACCESS_LEVEL
		uint8 sio_access_level;
	#endif
} SioParamIDXs;

extern SioParamIDXs sioParamIDX[];
#ifdef SIO_ACCESS_LEVEL
	extern uint8 sio_access_level_current;
#endif

extern void RdVersionID(void);
extern void RdVersionStr(void);
extern void RdParamBuf(uint8 *payload, uint16 payloadLength);
extern void WrParamBuf(uint8 *payload, uint16 payloadLength);
extern void RdParam(uint8 *payload, uint16 payloadLength);
extern void WrParam(uint8 *payload, uint16 payloadLength);
extern void RdParamW(uint8 *payload, uint16 payloadLength);
extern void WrparamW(uint8 *payload, uint16 payloadLength);
extern void RdParamL(uint8 *payload, uint16 payloadLength);
extern void WrParamL(uint8 *payload, uint16 payloadLength);
extern void RdParamF(uint8 *payload, uint16 payloadLength);
extern void WrParamF(uint8 *payload, uint16 payloadLength);
extern void GetSeed(uint8 *payload, uint16 payloadLength);
extern void CheckKey(uint8 *payload, uint16 payloadLength);
extern void GetValidId(uint8 *payload, uint16 payloadLength);

extern void Param_Rd(uint16 idx); //user must implement
extern void Param_Wr(uint16 idx); //user must implement
extern void ParamBuff_Rd(uint16 idx, uint8 *data, uint16 *length); //user must implement
extern void ParamBuff_Wr(uint16 idx, uint8 *data, uint16 length); //user must implement
extern void sio_getSeed(uint8 *data);
extern uint8 sio_checkKey(uint8 *key, uint8 newLevel);

extern int getCharWrapper(void);
extern void flushBufferWrapper(void);

extern void sioSendPacketWrapper(uint16 command, uint8 *data, uint16 length);

extern void sio_calulate_crc32_start(void);
extern void sio_calulate_crc32_add(unsigned char tempCh);
extern uint32 sio_calulate_crc32_get(void);

#endif
