#ifndef _SPI_H_
#define _SPI_H_

#include "k_stdtype.h"

typedef enum _SPIStateEnum {
	SPI_READY_STATE,
	SPI_BUSY_STATE,
	SPI_ERROR_STATE
} SPIStateEnum;

extern void spi_reconfigure(unsigned char SMP, unsigned char CKP, unsigned char CKE, unsigned int BRG);

extern SPIStateEnum readWriteSPI(unsigned char *bufferOut, unsigned char *bufferIn, unsigned int size);
extern SPIStateEnum getSpiState(void);
extern void getBufferInSPI(unsigned char *bufferIn, unsigned int size);

extern void readWriteSPI_nb(unsigned char *bufferOut, unsigned char *bufferIn, unsigned int size);

extern uint16 SPICalutateBRG(uint32 spi_clk);


#endif
