#ifndef __SUNPOS_H
#define __SUNPOS_H

// This file is available in electronic form at http://www.psa.es/sdg/sunpos.htm
	// Declaration of some constants 
	#define pi    3.14159265358979323846
	#define twopi (2*pi)
	#define rad   (pi/180)
	#define dEarthMeanRadius     6371.01	// In km
	#define dAstronomicalUnit    149597890	// In km

	typedef struct _cTime
	{
		int iYear;
		int iMonth;
		int iDay;
		float dHours;
		float dMinutes;
		float dSeconds;
	} cTime;

	typedef struct _cLocation
	{
		float dLongitude;
		float dLatitude;
	} cLocation;

	typedef struct _cSunCoordinates
	{
		float dZenithAngle;
		float dAzimuth;
	} cSunCoordinates;

	extern void sunpos(cTime udtTime, cLocation udtLocation, cSunCoordinates *udtSunCoordinates);

#endif
