#include <string.h>
#include <stdlib.h>
#include "global.h"
#include "app.h"
#include "i_app.h"
#include "w_app.h"
#include "int_app.h"
#include "mal.h"

#include "k_stdtype.h"
#include "c_sio.h"
#include "led.h"
#include "sio.h"
#include "sleep.h"
#include "task.h"
#include "nmeaparser.h"
#include "serial_usart1.h"

void appSingleShoot1(void);
void appSingleShoot2(void);
TaskId appSingleShoot2TaskId = -1;
uint8 app_pwm = 0;
unsigned char period = 10;
unsigned char duty = 1;
unsigned char pwmTmp = 0;


void init_app(void) {
	addSingleShootTask(appSingleShoot1, "appSingleShoot1");
	TRISDbits.TRISD4 = 0;
}

void do_app(void) {
	static unsigned char appSingleShoot = 1;
	if (appSingleShoot) {
		appSingleShoot = 0;
		
		status.w = 0;
		status.led = 1;
		status.blinking = 0;
		setNormalLED();
	}
	{//USART1 -> GPS
		int ch = getChar_usart1();
		if (ch != -1) {
			putCharNmeaParser(ch);
		}
	}
	if (app_pwm) {
		LATDbits.LATD4 = 1;
		_sync();
	} else {
		LATDbits.LATD4 = 0;
		_sync();
	}
}

void appSingleShoot1(void) {
	{ //Celsius
		unsigned char ch = 0;
		unsigned char data[8] = {
			0b00001100, 
			0b00010010, 
			0b00010010, 
			0b00001100, 
			0b00000000, 
			0b00000000, 
			0b00000000, 
			0b00000000
		};
		lcd_set_character(ch, data);
	}
	{ // Smile
		unsigned char ch = 1;
		unsigned char data[8] = {
			0b00000010, 
			0b00000001, 
			0b00001001, 
			0b00000001, 
			0b00001001, 
			0b00000001, 
			0b00000010, 
			0b00000000
		};
		lcd_set_character(ch, data);
	}
	{//Battery
		unsigned char ch = 2;
		unsigned char data[8] = {
			0b00001110, 
			0b00010001, 
			0b00010001, 
			0b00010001, 
			0b00010001, 
			0b00010001, 
			0b00010001, 
			0b00011111
		};
		lcd_set_character(ch, data);
	}	
	{//GPS
		unsigned char ch = 3;
		unsigned char data[8] = {
			0b00001110, 
			0b00010001, 
			0b00001010, 
			0b00000100, 
			0b00000000, 
			0b00001110, 
			0b00000000, 
			0b00000000
		};
		lcd_set_character(ch, data);
	}	
	lcd_gotoxy(0, 0);
	printf((const char *)"Time v2.0.3");
	lcd_gotoxy(0, 1);
	printf((const char *)"\01");
	appSingleShoot2TaskId = addTask(appSingleShoot2, 3000, 1, "appSingleShoot2");
}

void appSingleShoot2(void) {
	lcd_clearscreen();
	enableGui();
	removeTask(appSingleShoot2TaskId);
}

void isr_app1ms(void) {

}

void isr_app100us(void) {
	{
		if (pwmTmp < duty) {
			app_pwm = 1;
		} else {
			app_pwm = 0;
		}

		pwmTmp++;
		if (pwmTmp >= period) {
			pwmTmp = 0;
		}
	}
}

//Implemented by onewire.c
//void isr_appCustom(void) {
//}

uint8 backToSleep(void) {
}

void _mon_putc (char c){
	lcd_put_char(c);
}
