#include "global.h"
#include <string.h>
#include "c_sio.h"
#include "e_sio.h"

#include "main.h"
#include "gui.h"
#include "sleep.h"

typedef enum _ParamIDX {
	ParamIDX_tick_count = 0x0000,
	ParamIDX_status = 0x0001,
	ParamIDX_loopCnt = 0x0002,
	ParamIDX_securityLevel = 0x0003,
	ParamIDX_time_sec = 0x0004,
	ParamIDX_time_min = 0x0005,
	ParamIDX_time_hour = 0x0006,
	ParamIDX_time_day = 0x0007,
	ParamIDX_time_month = 0x0008,
	ParamIDX_time_year = 0x0009,
	ParamIDX_time_dofw_calendar = 0x000A,
	ParamIDX_time_week_calendar = 0x000B,
} ParamIDX;

SIOSTATUS status;
uint16 sio_time_sec = 0;
uint16 sio_time_min = 0;
uint16 sio_time_hour = 0;
uint16 sio_time_day = 0;
uint16 sio_time_month = 0;
uint16 sio_time_year = 0;
uint16 sio_time_dofw_calendar = 0;
uint16 sio_time_week_calendar = 0;

SioParamIDXs sioParamIDX[] = {
	{ParamIDX_tick_count,		(unsigned int *) &tick_count,					0},
	{ParamIDX_status,			(unsigned int *) &status,						0},
	{ParamIDX_loopCnt,			(unsigned int *) &loopCnt,						0},
	{ParamIDX_securityLevel,	(unsigned int *) &sio_access_level_current,		0},
	{ParamIDX_time_sec, (unsigned int *) &sio_time_sec,							0},
	{ParamIDX_time_min, (unsigned int *) &sio_time_min,							0},
	{ParamIDX_time_hour, (unsigned int *) &sio_time_hour,						0},
	{ParamIDX_time_day, (unsigned int *) &sio_time_day,							0},
	{ParamIDX_time_month, (unsigned int *) &sio_time_month,						0},
	{ParamIDX_time_year, (unsigned int *) &sio_time_year,						0},
	{ParamIDX_time_dofw_calendar, (unsigned int *) &sio_time_dofw_calendar,		0},
	{ParamIDX_time_week_calendar, (unsigned int *) &sio_time_week_calendar,		0},
};

void Param_Rd(uint16 idx) { // called befor parameter is read
	switch ((ParamIDX)idx) {
		case ParamIDX_tick_count : {
			break;
		}
		case ParamIDX_status : {
			break;
		}
		case ParamIDX_loopCnt : {
			break;
		}
		case ParamIDX_securityLevel : {
			break;
		}
		case ParamIDX_time_sec : {
			break;
		}
		case ParamIDX_time_min : {
			break;
		}
		case ParamIDX_time_hour : {
			break;
		}
		case ParamIDX_time_day : {
			break;
		}
		case ParamIDX_time_month : {
			break;
		}
		case ParamIDX_time_year : {
			break;
		}
		case ParamIDX_time_dofw_calendar : {
			break;
		}
		case ParamIDX_time_week_calendar : {
			break;
		}
	}
}

void Param_Wr(uint16 idx) { //called after parameter is updated
	switch ((ParamIDX)idx) {
		case ParamIDX_tick_count : {
			break;
		}
		case ParamIDX_status : {
			break;
		}
		case ParamIDX_loopCnt : {
			break;
		}
		case ParamIDX_securityLevel : {
			break;
		}
		case ParamIDX_time_sec : {
			break;
		}
		case ParamIDX_time_min : {
			break;
		}
		case ParamIDX_time_hour : {
			break;
		}
		case ParamIDX_time_day : {
			break;
		}
		case ParamIDX_time_month : {
			break;
		}
		case ParamIDX_time_year : {
			break;
		}
		case ParamIDX_time_dofw_calendar : {
			break;
		}
		case ParamIDX_time_week_calendar : {
			TimeDate sio_timeDateGuiTemp;
			sio_timeDateGuiTemp.sec = sio_time_sec;
			sio_timeDateGuiTemp.min = sio_time_min;
			sio_timeDateGuiTemp.hour = sio_time_hour;
			sio_timeDateGuiTemp.day = sio_time_day;
			sio_timeDateGuiTemp.month = sio_time_month;
			sio_timeDateGuiTemp.year = sio_time_year;
			sio_timeDateGuiTemp.dofw_calendar = sio_time_dofw_calendar;
			sio_timeDateGuiTemp.week_calendar = sio_time_week_calendar;
			fillEepromDefinedValue(&sio_timeDateGuiTemp);
			break;
		}
	}
}

void ParamBuff_Rd(uint16 idx, uint8 *data, uint16 *length) {
}

void ParamBuff_Wr(uint16 idx, uint8 *data, uint16 length) {
}

uint16 getsioParamIDXItemCnt(void) {
	return (sizeof(sioParamIDX) / sizeof(*sioParamIDX));
}
