#include <string.h>
#include "ds1307.h"
#include "rtc.h"

void ds1307_convertToDs1307Format(TimeDate *ptrFrom, DS1307_Time *ptrTo) {
	if ((ptrFrom != NULL) && (ptrTo != NULL)) {
		ptrTo->sec = ptrFrom->sec;
		ptrTo->min = ptrFrom->min;
		ptrTo->hour = ptrFrom->hour;
		ptrTo->day = ptrFrom->day;
		ptrTo->month = ptrFrom->month;
		ptrTo->year = ptrFrom->year;
		ptrTo->dayOfWeek = ptrFrom->dofw_calendar;
	}
}

void ds1307_convertToTimeDateFormat(DS1307_Time *ptrFrom, TimeDate *ptrTo) {
	if ((ptrFrom != NULL) && (ptrTo != NULL)) {
		ptrTo->sec = ptrFrom->sec;
		ptrTo->min = ptrFrom->min;
		ptrTo->hour = ptrFrom->hour;
		ptrTo->day = ptrFrom->day;
		ptrTo->month = ptrFrom->month;
		ptrTo->year = ptrFrom->year;
		ptrTo->dofw_calendar = ptrFrom->dayOfWeek;
		rtcCalculateWeekAndDay(ptrTo);
	}
}
