#include <string.h>
#include "int_ds1307.h"
#include "c_ds1307.h"

#include "iic_master.h"

#ifdef DS1307_IN_PCF8563_MODE
	#define DS1307_IIC_ADDRESS 0x51
#else
	#define DS1307_IIC_ADDRESS 0x68
#endif

int ds1307_write(unsigned char wordAddress, unsigned char *data, unsigned char length) {
	int result = NACK;
	if ((data != NULL) && (length != 0) && (length <= 7)) {
		unsigned char tempData[8];
		tempData[0] = wordAddress;
		memcpy(tempData + 1, data, length);
		result = writeIIC(DS1307_IIC_ADDRESS, tempData, length + 1, 0);
	}
	return result;
}

int ds1307_read(unsigned char wordAddress, unsigned char *data , unsigned char length) {
	int result = NACK;
	if ((data != NULL) && (length != 0)) {
		result = writeIIC(DS1307_IIC_ADDRESS, &wordAddress, 1, 1 );
		if (result != NACK) {
			result = readIIC(DS1307_IIC_ADDRESS, data, length);
		}
	}
	return result;
}
