#include "global.h"
#include "eeprom.h"
#include "c_eeprom.h"

#include "mal.h"
#include "dee_emulation_pic32.h"
#include "k_stdtype.h"

uint8 deeInited = 0;

void write_eeprom(unsigned int adr, unsigned char data) {
	if (deeInited == 0) {
		if(DataEEInit()) {
			deeInited = 0;
		} else {
			deeInited = 1;
		}
	}
	if (deeInited) {
		DataEEWrite(data, adr);
	}
}

unsigned char read_eeprom(unsigned int adr) {
	unsigned int result = 0x00;
	if (deeInited == 0) {
		if(DataEEInit()) {
			deeInited = 0;
		} else {
			deeInited = 1;
		}
	}
	if (deeInited) {
		DataEERead(&result, adr);
	}
	return (unsigned char)result;
}

void write_eeprom_float(unsigned int adr, float data) {
	unsigned char x = 0;

	for (x = 0; x < sizeof(float) / sizeof(unsigned char); x++) {
		write_eeprom (adr + x, ((unsigned char *)&data)[x]);
	}
}

float read_eeprom_float (unsigned int adr) {
	float result = 0;
	unsigned char x = 0;
	for (x = 0; x < sizeof(float) / sizeof(unsigned char); x++) {
		((unsigned char *)&result)[x] = read_eeprom (adr + x);
	}
	return result;
}

void write_eeprom_word(unsigned int adr, unsigned int data) {
	unsigned char x = 0;

	for (x = 0; x < sizeof(unsigned int) / sizeof(unsigned char); x++) {
		write_eeprom (adr + x, ((unsigned char *)&data)[x]);
	}
}

unsigned int read_eeprom_word(unsigned int adr) {
	unsigned int result = 0;
	unsigned char x = 0;
	for (x = 0; x < sizeof(unsigned int) / sizeof(unsigned char); x++) {
		((unsigned char *)&result)[x] = read_eeprom (adr + x);
	}
	return result;
}
