#include <math.h>
#include "gpshelper.h"

#define PI 3.1415926535897932384626433832795028841971693993751058209

static const double DEG_TO_RAD = PI / 180.0;
static const double RAD_TO_DEG = 180.0 / PI;

double distanceLatLat(LatLong a, LatLong b) {
	double distance = 0.0;
 
	double dlon = b.longitudeRad - a.longitudeRad;
	double dlat = b.latitudeRad - a.latitudeRad;
	double a_temp =  pow(sin(dlat * 0.5), 2.0)+ cos(a.latitudeRad) * cos(b.latitudeRad) * pow(sin(dlon * 0.5), 2.0);
	double c = 2.0 * atan2(sqrt(a_temp), sqrt(1.0 - a_temp));
	distance = getEarthRadius(a) * c;
	
	return distance;
}

double bearingLatLat(LatLong a, LatLong b) {
	double bearing = 0;

	bearing = atan2(sin(b.longitudeRad-a.longitudeRad)*cos(b.latitudeRad), (cos(a.latitudeRad)*sin(b.latitudeRad))-(sin(a.latitudeRad)*cos(b.latitudeRad)*cos(b.longitudeRad-a.longitudeRad)));
	//bearing = radianToDegree(bearing);
	bearing = fmod((bearing + (2.0 * PI)), (2.0 * PI));
	
	return bearing;
}

double getEarthRadius (LatLong latLong) {
	double result = 6372.797560856*1000.0; //m
	return result;
}

double degreeToRadian(double degree) {
	double result = degree * PI / 180.0;
	return result;
}

double radianToDegree(double radian) {
	double result = radian * 180.0 / PI;
	return result;
}

LatLong addDistance(LatLong source, double bearing, double distance) {
	LatLong result;
	double dR = distance / getEarthRadius(source);
	result.latitudeRad = asin(sin(source.latitudeRad) * cos(dR) + cos(source.latitudeRad) * sin(dR) * cos(bearing));
  	result.longitudeRad = source.longitudeRad + atan2(sin(bearing) * sin(dR) * cos(source.latitudeRad), cos(dR) - sin(source.latitudeRad) * sin(result.latitudeRad));
	return result;
}

LatLong parseDoubles(double degreeLat, double minLat, double secLat, double degreeLong, double minLong, double secLong) {
	LatLong result;
	result.latitudeRad = degreeLat;
	result.latitudeRad += minLat / 60.0;
	result.latitudeRad += secLat / (3600.0);
	result.latitudeRad = degreeToRadian(result.latitudeRad);

	result.longitudeRad = degreeLong;
	result.longitudeRad += minLong / 60.0;
	result.longitudeRad += secLong / (3600.0);
	result.longitudeRad = degreeToRadian(result.longitudeRad);

	return result;
}

double calcRelBearing(double bearing, double heading) {
	double relBearing;
	relBearing = bearing - heading;
	if(relBearing > 180.0) {
		relBearing = bearing - (heading + 360.0);
	}
	if(relBearing < -180.0) {
		relBearing = bearing - (heading - 360.0);
	}
	return(relBearing);
}

int inrangeLatLat(LatLong currentPos, LatLong desiredPos, double range) {
	int result = 0;
	double distance = distanceLatLat(currentPos, desiredPos);
	if (distance <= range) {
		result = 1;
	} else {
		result = 0;
	}
	return result;
}
