#include <string.h>
#include <stdlib.h>
#include "nmeaparser.h"

#include "task.h"
#include "k_stdtype.h"
#include "tmr.h"

unsigned char nmeaBuffer[256];
unsigned char *tokenBuffer[16];
unsigned int nmeaBufferCnt = 0;

unsigned char dollarReceived = 0;
int parsedState = 0;
uint8 parsed_nmea_time_valid = 0;
int parsed_altitude = 0;
uint8 parsed_altitude_valid = 0;
uint8 gps_nmeaDetected = 0;

unsigned char checkSumCalc = 0;
unsigned char checkSumMsg = 0;
LatLong parsedLatLong;
NMEA_Time parsednmea_time;
TaskId doParsingTaskNr = 0;
Timer lastGpsValidMessage;

void nmeaAddCharToBuffer(unsigned char ch);
int gps1StrToDouble(unsigned char *str, double *degree, double *min);
int gps2StrToDouble(unsigned char *str, double *degree, double *min);
uint8 gpsTimeToInt(unsigned char *str, NMEA_Time *nmea_time);
uint8 gpsDateToInt(unsigned char *str, NMEA_Time *nmea_time);
uint8 gpsAltitudeToInt(unsigned char *str, int *parsed_altitude);
unsigned char * getTokenCnt(unsigned char *dataIn, unsigned int item, unsigned char token);
unsigned char gpsExtractCheckSum(unsigned char *str, unsigned int length);
unsigned char gpsCalculateCheckSum(unsigned char *str, unsigned int length);
unsigned int str2int(unsigned char *str, unsigned int cnt);
void gps_triggerNmeaSentenceDetected(void);
void gps_triggerNmeaSentenceMissDetected(void);

void doParsing(void);

void init_nmeaparser(void) {
	memset(nmeaBuffer, 0x00, sizeof(nmeaBuffer) / sizeof(*nmeaBuffer) );
	parsedLatLong.latitudeRad = 0.0;
	parsedLatLong.longitudeRad = 0.0;
	memset(tokenBuffer, 0xAA, sizeof(tokenBuffer) );
	
	removeTimer(&lastGpsValidMessage);	
	addTimer(&lastGpsValidMessage);
}

void do_nmeaparser(void) {
}

void doParsing(void) {
	{
		unsigned int i = 0;
		for (i = 0; i < (sizeof(tokenBuffer) / sizeof(*tokenBuffer)); i++) {
			unsigned char *item = NULL;
			item = getTokenCnt(nmeaBuffer, i, ',');
			if (item == NULL) {
				break;
			}
			tokenBuffer[i] = item;
		}
	}
	{
		checkSumMsg = gpsExtractCheckSum(nmeaBuffer, nmeaBufferCnt);
		checkSumCalc = gpsCalculateCheckSum(nmeaBuffer, nmeaBufferCnt);
	}
	if (checkSumCalc == checkSumMsg) {
		if (strncmp(tokenBuffer[0], "$GPGGA", 6) == 0) {
			gps_triggerNmeaSentenceDetected();
			{
				double degreeLat = 0.0;
				double minLat = 0.0;
				double secLat = 0.0;
				double degreeLong = 0.0;
				double minLong = 0.0;
				double secLong = 0.0;
				int result = -1;
				//gpsTimeToInt(tokenBuffer[1], &parsednmea_time);
				result = gps1StrToDouble(tokenBuffer[2], &degreeLat, &minLat);
				if (result == 1) {
					result = gps2StrToDouble(tokenBuffer[4], &degreeLong, &minLong);
					if (result == 1) {
						parsedLatLong = parseDoubles(degreeLat, minLat, secLat, degreeLong, minLong, secLong);
						if (tokenBuffer[3][0] == 'N') {
						} else if (tokenBuffer[3][0] == 'S') {
							parsedLatLong.latitudeRad = -parsedLatLong.latitudeRad;
						}
						if (tokenBuffer[5][0] == 'E') {
						} else if (tokenBuffer[5][0] == 'W') {
							parsedLatLong.longitudeRad = -parsedLatLong.longitudeRad;
						}
						parsed_altitude_valid = gpsAltitudeToInt(tokenBuffer[9], &parsed_altitude);
						parsedState = 1;
					} else {
					}
				} else {
				}
			}
		} else if (strncmp(tokenBuffer[0], "$GPRMC", 6) == 0) {
			gps_triggerNmeaSentenceDetected();
			{
				uint8 resultgpsDateToInt = gpsDateToInt(tokenBuffer[9], &parsednmea_time);
				uint8 resultgpsTimeToInt = gpsTimeToInt(tokenBuffer[1], &parsednmea_time);
				if ((resultgpsDateToInt == 1) && (resultgpsTimeToInt == 1)) {
					parsed_nmea_time_valid = 1;
				} else {
					parsed_nmea_time_valid = 0;
				}
			}
		} else {
			gps_triggerNmeaSentenceMissDetected();
		}
	}
	//TODO drop only that part of buffer that is processed.
	memset(nmeaBuffer, 0x00, sizeof(nmeaBuffer) / sizeof(*nmeaBuffer) );
	nmeaBufferCnt = 0;
}

unsigned char gpsExtractCheckSum(unsigned char *str, unsigned int length) {
	unsigned char result = 0;
	unsigned char markFound = 0;
	unsigned int markPos = 0;
	unsigned int i = 0;
	for (i = 0; i < length; i++) {
		if (str[i] == '*') {
			markFound = 1;
			markPos = i;
		}
	}
	if (markFound) {
		unsigned int x = 0;
		for (x = 0; x < 2; x++) {
			unsigned char ch = 0;
			result *= 16;
			ch = str[markPos + 1 + x];
			if ((ch >= '0') && (ch <= '9')) {
				result += ch - '0';
			} else if ((ch >= 'A') && (ch <= 'F')) {
				result += (ch - 'A' + 0x0A);
			}
		}
	}
	return result;
}

unsigned char gpsCalculateCheckSum(unsigned char *str, unsigned int length) {
	unsigned char result = 0;
	unsigned int i = 0;
	unsigned char ch = 0;
	for (i = 1; i < length; i++) {
		ch = str[i];
		if (ch == '*') {
			break;
		} else {
			result ^= ch;
		}
	}
	return result;
}

unsigned char * getTokenCnt(unsigned char *dataIn, unsigned int item, unsigned char token) {
	unsigned char * result = NULL;
	unsigned int i = 0;
	unsigned char ch = 0;
	unsigned int tokenCnt = 0;
	if (dataIn != NULL) {
		if (item == 0) {
			result = dataIn;
		} else {
			while (1) {
				ch = dataIn[i];
				i++;
				if (i == 0) {
					break;
				}
				if (ch != 0x00) {
					if (ch == token) {
						tokenCnt++;
						if (tokenCnt == item) {
							result = dataIn + i;
							break;
						}
					} else {
					}
				} else {
					break;
				}
			}
		}
	}
	return result;
}

void putCharNmeaParser(unsigned char ch) {
	if (ch == 0xA) {
		//drop this char
	} else {
		if (dollarReceived == 0) {
			if (ch == '$') {
				dollarReceived = 1;
				nmeaAddCharToBuffer(ch);
			}
		} else {
			if (ch == 0x0D) {
				dollarReceived = 0;
				doParsingTaskNr = addTriggerTask(doParsing, "doParsing");
				triggerTask(doParsingTaskNr);
			}
			nmeaAddCharToBuffer(ch);
		}
	}
}

void nmeaAddCharToBuffer(unsigned char ch) {
	if (nmeaBufferCnt < (sizeof(nmeaBuffer) / sizeof(*nmeaBuffer))) {
		nmeaBuffer[nmeaBufferCnt] = ch;
		nmeaBufferCnt++;
	} else {
		nmeaBufferCnt = 0;
	}
}

int getAltitude(int *altitude) {
	int result = -1;
	if (altitude != NULL) {
		*altitude = parsed_altitude;
		result = parsed_altitude_valid;
		parsed_altitude_valid = 0;
	}
	return result;
}

int getDateTime(NMEA_Time *nmea_time) {
	int result = -1;
	if (nmea_time != NULL) {
		*nmea_time = parsednmea_time;
		result = parsed_nmea_time_valid;
		parsed_nmea_time_valid = 0;
	}
	return result;
}

int getLatLongNmeaParses(LatLong *latLong) {
	int result = -1;
	if (latLong != NULL) {
		/* Leonberg */
		/*
		double degreeLat = 48.0;
		double minLat = 48.0;
		double secLat = 0.0;
		double degreeLong = 9.0;
		double minLong = 1.0;
		double secLong = 0.0;
		*/
		/* Budapest */
		/*double degreeLat = 47.0;
		double minLat = 30.0;
		double secLat = 0.0;
		double degreeLong = 19.0;
		double minLong = 5.0;
		double secLong = 0.0;
		*latLong = parseDoubles(degreeLat, minLat, secLat, degreeLong, minLong, secLong);*/
		*latLong = parsedLatLong;
		result = parsedState;
		parsedState = 0;
	}
	return result;
}

int gps1StrToDouble(unsigned char *str, double *degree, double *min) {
	int result = -1;
	if ((str != NULL) && (degree != NULL) && (min != NULL)) {
		if ((str[0] != 0x00) && (str[0] != ',')) {
			*degree = (str[0] - '0') * 10.0;
			*degree += (str[1] - '0') * 1.0;
			*min = (str[2] - '0') * 10.0;
			*min += (str[3] - '0') * 1.0;
			*min += (str[5] - '0') * 0.1;
			*min += (str[6] - '0') * 0.01;
			*min += (str[7] - '0') * 0.001;
			*min += (str[8] - '0') * 0.0001;
			result = 1;
		} else {
			result = 0;
		}
	}
	return result;
}

uint8 gpsDateToInt(unsigned char *str, NMEA_Time *nmea_time) {
	uint8 result = 0;
	if ((str != NULL) && (nmea_time != NULL)) {
		if (str[0] == ',') {
			result = 0;
		} else {
			nmea_time->year = str2int(str + 4, 2) + 2000;
			nmea_time->month = str2int(str + 2, 2);
			nmea_time->day = str2int(str, 2);
			if ((nmea_time->year == 0) || (nmea_time->month == 0) || (nmea_time->day == 0)) {
				result = 0;
			} else {
				result = 1;
			}
		}
	} else {
		result = 0;
	}
	return result;
}

uint8 gpsTimeToInt(unsigned char *str, NMEA_Time *nmea_time) {
	uint8 result = 0;
	if ((str != NULL) && (nmea_time != NULL)) {
		if (str[0] == ',') {
			result = 0;
		} else {
			nmea_time->sec = str2int(str + 4, 2);
			nmea_time->min = str2int(str + 2, 2);
			nmea_time->hour = str2int(str, 2);
			if ((nmea_time->sec > 60) || (nmea_time->min > 60) || (nmea_time->hour > 24)) {
				result = 0;
			} else {
				result = 1;
			}
		}
	} else {
		result = 0;
	}
	return result;
}

uint8 gpsAltitudeToInt(unsigned char *str, int *parsed_altitude) {
	uint8 result = 0;
	if ((str != NULL) && (parsed_altitude != NULL)) {
		if (str[0] != ',') {
			*parsed_altitude = str2int(str, 0);
			result = 1;
		} else {
			result = 0;
		}
	} else {
		result = 0;
	}
	return result;
}

unsigned int str2int(unsigned char *str, unsigned int cnt) {
	int result = 0;
	if (str != NULL) {
		unsigned int x = 0;
		if (cnt == 0) {
			uint8 sign = 0;
			if (str[x] == '-') {
				sign = 1;
			}
			for (x = sign; x < 10; x++) {//limited to maximum 10 digits
				if ((str[x] >= '0') && (str[x] <= '9')) {
					result *= 10;
					result += str[x] - '0';
				} else {
					break;
				}
			}
			if (sign) {
				result *= -1;
			}
		} else {
			for (x = 0; x < cnt; x++) {
				result *= 10;
				result += str[x] - '0';
			}
		}
	}
	return result;
}

int gps2StrToDouble(unsigned char *str, double *degree, double *min) {
	int result = -1;
	if ((str != NULL) && (degree != NULL) && (min != NULL)) {
		if ((str[0] != 0x00) && (str[0] != ',')) {
			*degree = (str[0] - '0') * 100.0;
			*degree += (str[1] - '0') * 10.0;
			*degree += (str[2] - '0') * 1.0;
			*min = (str[3] - '0') * 10.0;
			*min += (str[4] - '0') * 1.0;
			*min += (str[6] - '0') * 0.1;
			*min += (str[7] - '0') * 0.01;
			*min += (str[8] - '0') * 0.001;
			*min += (str[9] - '0') * 0.0001;
			result = 1;
		} else {
			result = 0;
		}
	}
	return result;
}

void gps_triggerNmeaSentenceMissDetected(void) {
	if (gps_nmeaDetected != 0) {
		gps_nmeaDetected--;
	}
}

void gps_triggerNmeaSentenceDetected(void) {
	writeTimer(&lastGpsValidMessage, 1000);
	if (gps_nmeaDetected < 30) {
		gps_nmeaDetected += 5;
	}
}

uint8 gps_isPresent(void) {
	uint8 result = 0;
	if (readTimer(&lastGpsValidMessage) != 0) {
		if (gps_nmeaDetected >= 15) {
			result = 1;
		}
	}
	return result;
}
