#include <stdio.h>
#include <string.h>
#include <math.h>
#include "gui.h"
#include "i_gui.h"
#include "w_gui.h"

#include "mal.h"
#include "ds1307.h"
#include "tmr.h"
#include "lcd_hd44780.h"
#include "c_eep_manager.h"
#include "eep_manager.h"
#include "temperature.h"
#include "daylight.h"
#include "app.h"
#include "task.h"
#include "nevnap.h"
#include "specialday.h"
#include "SHT1x.h"
#include "bmp085.h"
#include "nmeaparser.h"
#include "bmp085_conversion.h"
#include "sunrise.h"

//DS device stores always the UTC time
//LCD shows the local time with daylight saving

sint8 timeZone = 1; //+1 hour to UTC
unsigned char guiEnabled = 0;
uint8 nevnapMaStr[32];
TimeDate timeDateGui_GPS;
int gps_altitude = 0;
uint8 gps_altitude_valid = 0;
int averaged_pressure_altitude = 0;
float pressureAtCurrentHeight = 0.0;
uint8 isGPSPresent = 0;
uint8 isGPSTimeSignalPresent = 0;
uint8 isGPSPositionSignalPresent = 0;
uint8 isRTCPresent = 0;
uint8 isRTCSignalPresent = 0;
DS1307_Time ds1307_Time;
NMEA_Time nmea_time;
LatLong latLong;
float sunsetTime = 0.0;
float sunriseTime = 0.0;

void loadRTCWithGPSTime(void);
void singleShootGui(void);
void do_gui500ms(void);
sint8 checkIfTodayIsASpecialDay(uint8 month, uint8 day);
void printSpecialDayStr(sint8 specialDayItem);
void printNormalDayStr(TimeDate timeDateGui);
void printBatteryIcon(uint8 lines);
uint16 liPoAdCntToPercent(uint16 cnt);

void init_gui(void) {
	addSingleShootTask(singleShootGui, "singleShootGui");
}

void do_gui(void) {
}

void singleShootGui(void) {
	setSource(TemperatureSource_SHT11);
	addTask(do_gui500ms, 500, 1, "do_gui500ms");

	//E_MEASUREMENT
	TRISFbits.TRISF1 = 0;
	LATFbits.LATF1 = 0;
}

void do_gui500ms(void) {
	{//Calculation
		static uint8 doSunRiseSunSetCnt = 0;
		doSunRiseSunSetCnt++;
		if (doSunRiseSunSetCnt >= 20) {
			doSunRiseSunSetCnt = 0;
			{
				TimeDate timeDateGui;
	
				int sunset_year = 2015;
				int sunset_month = 8;
				int sunset_day = 28;
				float lat = 48.7758460;
				float lng = 9.1829320;
				int localOffset = 1;
				int daylightSavings = 0;

				rtcGetTimeDate(&timeDateGui);
				sunset_year = (int)timeDateGui.year;
				sunset_month = (int)timeDateGui.month;
				sunset_day = (int)timeDateGui.day;
				
				if (isDaylightSavings((unsigned int)timeDateGui.year, (unsigned int)timeDateGui.month, (unsigned int)timeDateGui.day, (unsigned int)timeDateGui.hour, (unsigned int)timeDateGui.min, (unsigned int)timeDateGui.sec) == DayLightGui_Summer) {
					daylightSavings = 1;
				}

				if (isGPSPositionSignalPresent) {
					//lat = radianToDegree(latLong.latitudeRad);
					//lng = radianToDegree(latLong.longitudeRad);
				}
		
				sunriseTime = calculateSunrise(sunset_year, sunset_month, sunset_day, lat, lng, localOffset, daylightSavings);
				sunsetTime = calculateSunset(sunset_year, sunset_month, sunset_day, lat, lng, localOffset, daylightSavings);
			}
		}
	}
	{//RTC and RTCSignal IsPresent update
		if (ds1307_readTime(&ds1307_Time) == ACK) {
			isRTCPresent = 1;
			if (ds1307_Time.year >= 2015) {
				isRTCSignalPresent = 1;
			} else {
				isRTCSignalPresent = 0;
			}
		} else {
			isRTCPresent = 0;
		}
	}
	{//GPS and GPSSignal IsPresent update
		if (gps_isPresent()) {
			NMEA_Time nmea_time_temp;
			LatLong latLong_temp;
			isGPSPresent = 5;
			if (getDateTime(&nmea_time_temp) == 1) {
				isGPSTimeSignalPresent = 5;
				nmea_time = nmea_time_temp;
			} else {
				if (isGPSTimeSignalPresent != 0) {
					isGPSTimeSignalPresent--;
				}
			}
			if (getLatLongNmeaParses(&latLong) == 1) {
				isGPSPositionSignalPresent = 5;
				latLong = latLong;
			} else {
				if (isGPSPositionSignalPresent != 0) {
					isGPSPositionSignalPresent--;
				}
			}
		} else {
			if (isGPSPresent != 0) {
				isGPSPresent--;
			}
		}
	}
	if (guiEnabled) {
		{//Timedate update
			static unsigned int updateTimeCnt = 20;
			updateTimeCnt++;
			if (updateTimeCnt >= 20) {
				updateTimeCnt = 0;
				{//Prio is GPS, then RTC
					if (isGPSTimeSignalPresent) {
						timeDateGui_GPS.sec = nmea_time.sec;
						timeDateGui_GPS.min = nmea_time.min;
						timeDateGui_GPS.hour = nmea_time.hour;
						timeDateGui_GPS.day = nmea_time.day;
						timeDateGui_GPS.month = nmea_time.month;
						timeDateGui_GPS.year = nmea_time.year;
						timeDateGui_GPS.dofw_calendar = 0;
						calendar(&timeDateGui_GPS);
						rtcUTCtoLocalTime(&timeDateGui_GPS, timeZone, 1);
						rtcSetTimeDate(&timeDateGui_GPS);
					} else {
						if (isRTCSignalPresent) {
							TimeDate timeDateGui;
							ds1307_convertToTimeDateFormat(&ds1307_Time, &timeDateGui);
							rtcUTCtoLocalTime(&timeDateGui, timeZone, 1);
							rtcSetTimeDate(&timeDateGui);
						}
					}
				}
			}
		}
		{//RTC Time storing
			if ((isTimeWrittenToRTC == 0x00) || (isTimeWrittenToRTC == 0xFF)) {
				if (isGPSTimeSignalPresent) {
					DS1307_Time ds1307_Time;
					ds1307_convertToDs1307Format(&timeDateGui_GPS, &ds1307_Time);
					{
						int result = ds1307_writeTime(&ds1307_Time);
						if (result == ACK) {
							isTimeWrittenToRTC = 0x55;
							eepManagerWriteAll();
						}
					}
				} else {
					//No GPS time is present, do nothing
				}
			} else {
				//RTC is loaded with a time
				//check if RTC is loaded with a plausible time
				if ((isRTCPresent == 1) && (isRTCSignalPresent == 0)) {
					isTimeWrittenToRTC = 0xFF;
					eepManagerWriteAll();
				}
			}
		}
		{//Time and date
			TimeDate timeDateGui;
			uint8 temp_Daylight;
			rtcGetTimeDate(&timeDateGui);
			temp_Daylight = isDaylightSavings(timeDateGui.year, timeDateGui.month, timeDateGui.day, timeDateGui.hour, timeDateGui.min, timeDateGui.sec);
			lcd_gotoxy(0, 0);
			if (temp_Daylight == DayLightGui_Summer) {
				printf((const char *)"%4.4i.%2.2i.%2.2i S ", (int)timeDateGui.year, (int)timeDateGui.month, (int)timeDateGui.day);
			} else {
				printf((const char *)"%4.4i.%2.2i.%2.2i W ", (int)timeDateGui.year, (int)timeDateGui.month, (int)timeDateGui.day);
			}
			lcd_gotoxy(15, 0);
			printf((const char *)"%2.2i:%2.2i", (int)timeDateGui.hour, (int)timeDateGui.min);
			
			lcd_gotoxy(13, 0);
			switch (timeDateGui.dofw_calendar) {
				case 0 : {
					printf((const char *)"H");
					break;
				}
				case 1 : {
					printf((const char *)"K");
					break;
				}
				case 2 : {
					printf((const char *)"S");
					break;
				}
				case 3 : {
					printf((const char *)"C");
					break;
				}
				case 4 : {
					printf((const char *)"P");
					break;
				}
				case 5 : {
					printf((const char *)"S");
					break;
				}
				case 6 : {
					printf((const char *)"V");
					break;
				}
				default : {
					printf((const char *)"-");
					break;
				}
			}
		}
		{//SunRise
			float intpart = 0.0;
			float fractpart = 0.0;
			int sunrise_hour = 0;
			int sunrise_min = 0;
			fractpart = modff(sunriseTime, &intpart) * 60.0;
			sunrise_hour = intpart;
			sunrise_min = fractpart;
			lcd_gotoxy(15, 1);
			printf((const char *)"%2.2i:%2.2i", (int)sunrise_hour, (int)sunrise_min);
		}
		{//SunSet
			float intpart = 0.0;
			float fractpart = 0.0;
			int sunset_hour = 0;
			int sunset_min = 0;
			fractpart = modff(sunsetTime, &intpart) * 60.0;
			sunset_hour = intpart;
			sunset_min = fractpart;
			lcd_gotoxy(15, 2);
			printf((const char *)"%2.2i:%2.2i", (int)sunset_hour, (int)sunset_min);
		}
		{//Internal Temperature readout
			float temperature = 0;
			unsigned char readSuccess = 0;
			lcd_gotoxy(0, 1);
			if (getTemperature(&temperature)) {
				readSuccess = 1;
			} else {
			}
			if (readSuccess) {
				if (temperature > 99.0) {
					temperature = 99.0;
				} else if (temperature < -99.0) {
					temperature = -99.0;
				}
				if (temperature >= 0.0) {
					unsigned int x = (int)temperature;
					//unsigned int y = (int)((temperature * 100)) % 100;
					//printf((const char *)" %i.%2.2i", x, y);
					if ((x < 10) || (x > -10)) {
						printf((const char *)"  %i", x);
					} else {
						printf((const char *)" %i", x);
					}
					lcd_put_char(0);
				} else {
					temperature = -temperature;
					{
						unsigned int x = (int)temperature;
						//unsigned int y = (int)((temperature * 100)) % 100;
						//printf((const char *)"-%i.%2.2i", x, y);
						if ((x < 10) || (x > -10)) {
							printf((const char *)" -%i", x);
						} else {
							printf((const char *)"-%i", x);
						}
						lcd_put_char(0);
					}
				}
			} else {
				printf((const char *)"T: ERROR");
			}
		}
		{//Humidity
			float humi = getSHTHumi();
			unsigned int x = 0;
			if (humi < 0.0) {
				humi = 0.0;
			} else if (humi > 100.0) {
				humi = 100.0;
			}
			x = (int)humi;
			lcd_gotoxy(5, 1);
			if (x < 10) {
				printf((const char *)"  %i%%", x);
			} else if (x < 100) {
				printf((const char *)" %i%%", x);
			} else {
				printf((const char *)"%i%%", x);
			}
		}
		{//External Temperature readout
			float temperature = 0;
			unsigned char readSuccess = 0;
			lcd_gotoxy(10, 1);
			if (getTemperatureExternal(&temperature)) {
				readSuccess = 1;
			} else {
			}
			temperature = getBMP085Temp();
			if (readSuccess) {
				if (temperature > 99.0) {
					temperature = 99.0;
				} else if (temperature < -99.0) {
					temperature = -99.0;
				}
				if (temperature >= 0.0) {
					unsigned int x = (int)temperature;
					//unsigned int y = (int)((temperature * 100)) % 100;
					//printf((const char *)" %i.%2.2i", x, y);
					if ((x < 10) || (x > -10)) {
						printf((const char *)"  %i", x);
					} else {
						printf((const char *)" %i", x);
					}
					lcd_put_char(0);
				} else {
					temperature = -temperature;
					{
						unsigned int x = (int)temperature;
						//unsigned int y = (int)((temperature * 100)) % 100;
						//printf((const char *)"-%i.%2.2i", x, y);
						if ((x < 10) || (x > -10)) {
							printf((const char *)" -%i", x);
						} else {
							printf((const char *)"-%i", x);
						}
						lcd_put_char(0);
					}
				}
			} else {
				printf((const char *)"T: ERROR");
			}
		}
		{//Airpressure
			int x = 0;
			float pressure = 0.0;
			float pressureAtSeeLevel = 0.0;
			float altitude = 386.0;
			pressureAtCurrentHeight = getBMP085Pressure();
			{
				if (getAltitude(&gps_altitude) == 1) {
					altitude = gps_altitude;
					gps_altitude_valid = 10;
				} else {
					if (gps_altitude_valid != 0) {
						gps_altitude_valid--;
					}
					altitude = (float)averaged_pressure_altitude; //Default Leonberg
				}
			}
			pressureAtSeeLevel = calculateSeeLevelPressure(pressureAtCurrentHeight, altitude);
			
			pressure = pressureAtSeeLevel;
			pressure /= 100.0;
			
			if (pressure < 0.0) {
				pressure = 0.0;
			} else if (pressure > 2000.0) {
				pressure = 2000.0;
			}
			x = (int)pressure;
			lcd_gotoxy(0, 2);
			if (x < 10) {
				printf((const char *)"   %ihPa", x);
			} else if (x < 100) {
				printf((const char *)"  %ihPa", x);
			} else if (x < 1000) {
				printf((const char *)" %ihPa", x);
			} else {
				printf((const char *)"%ihPa", x);
			}
		}
		{//Altitude
			int x = 0;
			lcd_gotoxy(8, 2);
			if (gps_altitude_valid) {
				x = (int)gps_altitude;
			} else {
				static float pressureAtCurrentHeightAverage = 0.0;
				if (pressureAtCurrentHeightAverage == 0.0) {
					pressureAtCurrentHeightAverage = pressureAtCurrentHeight;
				} else {
					pressureAtCurrentHeightAverage += (pressureAtCurrentHeight - pressureAtCurrentHeightAverage) / 100000.0;
					x = (int)convertPressureToAltitude(101325.0, pressureAtCurrentHeightAverage);
					averaged_pressure_altitude = x;
				}
				//printf((const char *)"    m", x);
			}
			if (x < 10) {
				printf((const char *)"   %im", x);
			} else if (x < 100) {
				printf((const char *)"  %im", x);
			} else if (x < 1000) {
				printf((const char *)" %im", x);
			} else {
				printf((const char *)"%im", x);
			}
		}
		{//Nevnap
			TimeDate timeDateGui;
			sint8 specialDayItem = 0;
			rtcGetTimeDate(&timeDateGui);
			specialDayItem = checkIfTodayIsASpecialDay(timeDateGui.month, timeDateGui.day);
			if (specialDayItem != -1) {
					static uint8 alternate  = 0;
					alternate++;
					if (alternate <= 15) {
						printSpecialDayStr(specialDayItem);
					} else if (alternate <= 30) {
						printNormalDayStr(timeDateGui);
					} else {
						alternate = 0;
					}
			} else {
				printNormalDayStr(timeDateGui);
			}
		}
		{//GPS signal icon
			lcd_gotoxy(16, 3);
			if (isGPSPresent) {
				if (isGPSTimeSignalPresent) {
					printf((const char *)"\03");
				} else {
					printf((const char *)"?");
				}
			} else {
				printf((const char *)"X");
			}
		}
		{//RTC icon
			lcd_gotoxy(17, 3);
			if (isRTCPresent) {
				if (isRTCSignalPresent) {
					printf((const char *)"R");
				} else {
					printf((const char *)"?");
				}
			} else {
				printf((const char *)"X");
			}
		}
		{//Battery
			uint16 adResult = getAd(0);
			lcd_gotoxy(18, 3);
			if (adResult >= 200) {
				float adResultToPercentage = (float)adResult;
				uint8 liPoBatteryPercentage = 0;
				adResultToPercentage = (1.607 * adResultToPercentage) + (-416.55);
				if (adResultToPercentage < 0.0) {
					adResultToPercentage = 0.0;
				} else if (adResultToPercentage > 100.0) {
					adResultToPercentage = 100.0;
				}
				liPoBatteryPercentage = adResultToPercentage;
				if ((liPoBatteryPercentage >= 0) && (liPoBatteryPercentage <= 10)) {
					printBatteryIcon(0);
				} else if ((liPoBatteryPercentage >= 0) && (liPoBatteryPercentage < 19)) {
					printBatteryIcon(1);
				} else if ((liPoBatteryPercentage >= 20) && (liPoBatteryPercentage < 39)) {
					printBatteryIcon(2);
				} else if ((liPoBatteryPercentage >= 40) && (liPoBatteryPercentage < 59)) {
					printBatteryIcon(3);
				} else if ((liPoBatteryPercentage >= 60) && (liPoBatteryPercentage < 79)) {
					printBatteryIcon(4);
				} else if ((liPoBatteryPercentage >= 80) && (liPoBatteryPercentage < 89)) {
					printBatteryIcon(5);
				} else if ((liPoBatteryPercentage >= 90) && (liPoBatteryPercentage <= 100)) {
					printBatteryIcon(6);
				} else {
					printBatteryIcon(6);
				}
			} else {
				printf((const char *)"X");
			}
		}
		{//Power type
			lcd_gotoxy(19, 3);
			if (io_get_Usb_Fault()) {
				printf((const char *)"U");
			} else {
				printf((const char *)"B");
			}
		}
	}
}

void isr_gui1ms(void) {
}

void enableGui(void) {
	guiEnabled = 1;
}

void fillEepromDefinedValue(TimeDate *timeDateGui) {
	DS1307_Time ds1307_Time;
	
	rtcLocalTimeToUTC(timeDateGui, timeZone, 1);
	//Now we have UTC
	ds1307_convertToDs1307Format(timeDateGui, &ds1307_Time);
	
	{
		int result = ds1307_writeTime(&ds1307_Time);
		if (result == ACK) {
			isTimeWrittenToRTC = 0x55;
			eepManagerWriteAll();
		}
	}
}

void printSpecialDayStr(sint8 specialDayItem) {
	if (specialDayItem >= 0) {
		lcd_gotoxy(0, 3);
		printf("                 ");
		lcd_gotoxy(0, 3);
		printf("%s", guiSpecialDayEvents[(uint8)specialDayItem].str);
	}
}

void printNormalDayStr(TimeDate timeDateGui) {
	if (getNevnap(timeDateGui.year, timeDateGui.month, timeDateGui.day, nevnapMaStr, (sizeof(nevnapMaStr) / sizeof(*nevnapMaStr)) ) == 1) {
		lcd_gotoxy(0, 3);
		printf("                 ");
		lcd_gotoxy(0, 3);
		printf("%s", nevnapMaStr);
	} else {
		lcd_gotoxy(0, 3);
		printf("                 ");
	}
}

void printBatteryIcon(uint8 lines) {
	static uint8 linesPrev = 255;
	if (lines != linesPrev) {
		linesPrev = lines;
		switch (lines) {
			case 0 : {
				{//Battery 0
					unsigned char ch = 2;
					unsigned char data[8] = {
						0b00001110, 
						0b00010001, 
						0b00010001, 
						0b00010001, 
						0b00010001, 
						0b00010001, 
						0b00010001, 
						0b00011111
					};
					lcd_set_character(ch, data);
				}	
				break;
			}
			case 1 : {
				{//Battery 0
					unsigned char ch = 2;
					unsigned char data[8] = {
						0b00001110, 
						0b00010001, 
						0b00010001, 
						0b00010001, 
						0b00010001, 
						0b00010001, 
						0b00011111, 
						0b00011111
					};
					lcd_set_character(ch, data);
				}	
				break;
			}
			case 2 : {
				{//Battery 0
					unsigned char ch = 2;
					unsigned char data[8] = {
						0b00001110, 
						0b00010001, 
						0b00010001, 
						0b00010001, 
						0b00010001, 
						0b00011111, 
						0b00011111, 
						0b00011111
					};
					lcd_set_character(ch, data);
				}	
				break;
			}
			case 3 : {
				{//Battery 0
					unsigned char ch = 2;
					unsigned char data[8] = {
						0b00001110, 
						0b00010001, 
						0b00010001, 
						0b00010001, 
						0b00011111, 
						0b00011111, 
						0b00011111, 
						0b00011111
					};
					lcd_set_character(ch, data);
				}	
				break;
			}
			case 4 : {
				{//Battery 0
					unsigned char ch = 2;
					unsigned char data[8] = {
						0b00001110, 
						0b00010001, 
						0b00010001, 
						0b00011111, 
						0b00011111, 
						0b00011111, 
						0b00011111, 
						0b00011111
					};
					lcd_set_character(ch, data);
				}	
				break;
			}
			case 5 : {
				{//Battery 0
					unsigned char ch = 2;
					unsigned char data[8] = {
						0b00001110, 
						0b00010001, 
						0b00011111, 
						0b00011111, 
						0b00011111, 
						0b00011111, 
						0b00011111, 
						0b00011111
					};
					lcd_set_character(ch, data);
				}	
				break;
			}
			case 6 : {
				{//Battery 0
					unsigned char ch = 2;
					unsigned char data[8] = {
						0b00001110, 
						0b00011111, 
						0b00011111, 
						0b00011111, 
						0b00011111, 
						0b00011111, 
						0b00011111, 
						0b00011111
					};
					lcd_set_character(ch, data);
				}	
				break;
			}
			default : {
				{//Battery 0
					unsigned char ch = 2;
					unsigned char data[8] = {
						0b00001110, 
						0b00010011, 
						0b00010011, 
						0b00010101, 
						0b00010101, 
						0b00011001, 
						0b00011001, 
						0b00011111
					};
					lcd_set_character(ch, data);
				}	
				break;
			}
		}
	}
	lcd_gotoxy(18, 3);
	printf((const char *)"\02");
}

uint16 liPoAdCntToPercent(uint16 cnt) {
	uint16 result = 0;
	if (cnt < 255) {
		result = 0;
	} else if (cnt < 263) {
		result = 6;
	} else if (cnt < 271) {
		result = 9;
	} else if (cnt < 279) {
		result = 22;
	} else if (cnt < 286) {
		result = 52;
	} else if (cnt < 294) {
		result = 64;
	} else if (cnt < 302) {
		result = 75;
	} else if (cnt < 310) {
		result = 84;
	} else if (cnt < 317) {
		result = 93;
	} else if (cnt < 325) {
		result = 100;
	} else {
		result = 100;
	}
	return result;
}
