#include "mal.h"
#include <stdio.h>
#include "global.h"
#include "iic_master.h"
#include "c_iic_master.h"
#include "i_iic_master.h"
#include "w_iic_master.h"
#include "io_states.h"

#define SDA_HIZ()	IIC_SDA_TRIS = IN;\
					IIC_PORT_SYNC()

#define SCL_HIZ() 	IIC_SCL_TRIS = IN;\
					IIC_PORT_SYNC()

#define SDA_LO()	IIC_SDA_LAT = 0;\
					IIC_PORT_SYNC();\
					IIC_SDA_TRIS = OUT;\
					IIC_PORT_SYNC()

#define SCL_LO() 	IIC_SCL_LAT = 0;\
					IIC_PORT_SYNC();\
					IIC_SCL_TRIS = OUT;\
					IIC_PORT_SYNC()

#define IIC_CLK()		SCL_HIZ();\
						i2c_dly();\
						SCL_LO();\
						i2c_dly();


#define IIC_TX_BIT_1()	SDA_HIZ();\
						i2c_dly();\
						IIC_CLK();\
						SDA_LO();\
						i2c_dly()

#define IIC_TX_BIT_0()	SDA_LO();\
						i2c_dly();\
						IIC_CLK();\
						SDA_LO();\
						i2c_dly()

#define IIC_RX_BIT()	SDA_HIZ();\
						i2c_dly();\
						SCL_HIZ();\
						i2c_dly();\
						b = IIC_SDA_PORT;\
						SCL_LO();\
						i2c_dly();\
						SDA_LO();\
						i2c_dly()
						

static void i2c_dly(void);
static void i2c_start(void);
static void i2c_stop(void);
static unsigned char i2c_rx(unsigned char *data, unsigned char ack);
static unsigned char i2c_tx(unsigned char d);

static unsigned long delay_iic_master_timer = 0;
static unsigned char iic_master_init = 0;

void init_iic_master(void) {
	IIC_MAL_CONFIG();
	IIC_SDA_TRIS = IN;
	IIC_SCL_TRIS = IN;
	IIC_SCL_LAT = 0;
	IIC_SDA_LAT = 0;

	SDA_HIZ();
	i2c_dly();
	SCL_HIZ();
	i2c_dly();
	iic_master_init = 1;
}

void do_iic_master(void) {
}

int writeIIC(unsigned char addr, unsigned char *data, unsigned char size, unsigned char repeat) {
	unsigned char x = 0;
	unsigned char addrByte = addr;
	int result = ACK;
	if (iic_master_init) {
		addrByte = ((addrByte << 1) & 0b11111110);	//lsb is 0 because write
		i2c_start();
		if (i2c_tx(addrByte) == NACK) {
			result = NACK;
		} else {
			for (x = 0; x < size; x++) {
				if (i2c_tx(*(data + x)) == NACK) {
					result = NACK;
				} else {
					// do nothing
				}
			}
		}
		if (repeat == 0) {
			i2c_stop(); //no repated start condition, so stop will be generated.
		}
	} else {
		result = -1;
	}
	return result;
}

int readIIC(unsigned char addr, unsigned char *data, unsigned char size) {
	int result = ACK;
	unsigned char x = 0;
	unsigned char addrByte = addr;
	unsigned char ackBit = NACK;
	if (iic_master_init) {
		addrByte = ((addrByte << 1) & 0b11111110);	//lsb is 1 because read
		addrByte |= 0b00000001;
		if (size > 0) {
			i2c_start();
			if (i2c_tx(addrByte) == NACK) {
				result = NACK;
			} else {
				result = ACK;
				for (x = 0; x < size; x++) {
					if (x < (size - 1)) {
						ackBit = ACK;
					} else {
						ackBit = NACK;
					}
					if (i2c_rx(data + x ,ackBit) == NACK) {
						result = -1;
						break;
					}
				}
			}
			i2c_stop();
		}
	} else {
		result = -1;
	}
	return result;
}

static void i2c_dly(void) {
	#if IIC_BIT_RATE_NOPS == 0
	#elif IIC_BIT_RATE_NOPS == 1
		MAL_NOP();
	#elif IIC_BIT_RATE_NOPS == 2
		MAL_NOP();
		MAL_NOP();
	#elif IIC_BIT_RATE_NOPS == 3
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
	#elif IIC_BIT_RATE_NOPS == 4
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
	#elif IIC_BIT_RATE_NOPS == 5
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
	#elif IIC_BIT_RATE_NOPS == 6
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
	#elif IIC_BIT_RATE_NOPS == 7
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
	#elif IIC_BIT_RATE_NOPS == 8
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
		MAL_NOP();
	#else
		unsigned int t = 0;
		unsigned int m = IIC_BIT_RATE_NOPS;
		for (t = 0; t < m; t++) {
			MAL_NOP();
		}
	#endif
}

static void i2c_start(void) {
	SDA_HIZ();  //hhh|HHH|HHH|LLL|LLL|
	i2c_dly();
	SCL_HIZ();  //hhh|hhh|HHH|HHH|LLL|
	i2c_dly();
	SDA_LO();
	i2c_dly();
	SCL_LO();
	i2c_dly();
}

static void i2c_stop(void) {
	//SDA_LO(); //lll|LLL|LLL|HHH|
	//i2c_dly();
	SCL_HIZ();//lll|lll|HHH|HHH|
	i2c_dly();
	SDA_HIZ();
	i2c_dly();
}

static unsigned char i2c_rx(unsigned char *data, unsigned char ack) {
	unsigned char result = ACK;
	unsigned char x = 0;
	unsigned char temp = 0;
	unsigned char b;
	SDA_HIZ();
	delay_iic_master_timer = 10;
   	do {
		SCL_HIZ();
   	} while ((IIC_SCL_PORT == 0) && (delay_iic_master_timer != 0));    // wait for any SCL clock stretching
	if (delay_iic_master_timer == 0) {
		result = NACK;
	} else {
	 	for(x = 0; x < 8; x++) {
	   		temp <<= 1;
			IIC_RX_BIT();
			if (b) {
				temp |= 1;
			}
		}
		*data = temp;
		if (ack == ACK) {
			IIC_TX_BIT_0();
		} else {
			IIC_TX_BIT_1();
		}
	}
	return result;
}

static unsigned char i2c_tx(unsigned char d) {
	unsigned char x;
	unsigned char b;
  	for(x = 0; x < 8; x++) {
    	if(d & 0x80) {
			IIC_TX_BIT_1();
		} else {
			IIC_TX_BIT_0();
		}
    	d <<= 1;
  	}
	IIC_RX_BIT();	//receive ACK bit
  	return b;
}

void isr_iic_master1ms(void) {
	if (delay_iic_master_timer != 0) {
		delay_iic_master_timer--;
	}
}

void isr_iic_master(void) {
	//not used
}
