#include "lcd_driverhd44780.h"
#include "lcd_hd44780.h"
#include "c_lcd_hd44780.h"
#include "c_lcd_driverhd44780.h"
#include "int_lcd_driverhd44780.h"

#include <stdio.h>
#include <string.h>

uint8 pen_col = 0;
uint8 pen_row = 0;
uint8 screenBuffer[LCD_COLS][LCD_ROWS];
uint8 doLcdUpdate = 1;

void init_lcd(void) {
	pen_col = 0;
	pen_row = 0;
	
	lcd_clearscreen();
	init_lcd_driver();
}

void do_lcd(void) {
	do_lcd_driver();
	if (doLcdUpdate) {
		doLcdUpdate = 0;
		if (is_lcd_driver_inited()) {
			uint32 i = 0;
			for (i = 0; i < LCD_COLS; i++) {
				uint32 j = 0;
				
				#if LCD_COLS == 2
				{
					if (i == 0) {
						#ifdef LCD_ASYNC_INTERFACE
						#endif
						Send_Cmd_LCD(LINE1);
					} else if (i == 1) {
						#ifdef LCD_ASYNC_INTERFACE
						#endif
						Send_Cmd_LCD(LINE2);
					}
				}
				#endif
				#if LCD_COLS == 4
				{
					if (i == 0) {
						#ifdef LCD_ASYNC_INTERFACE
							Send_Async_Cmd_LCD(LINE1);
						#else
							Send_Cmd_LCD(LINE1);
						#endif
					} else if (i == 1) {
						#ifdef LCD_ASYNC_INTERFACE
							Send_Async_Cmd_LCD(LINE2);
						#else
							Send_Cmd_LCD(LINE2);
						#endif
					} else if (i == 2) {
						#ifdef LCD_ASYNC_INTERFACE
							Send_Async_Cmd_LCD(LINE1 + LCD_ROWS);
						#else
							Send_Cmd_LCD(LINE1 + LCD_ROWS);
						#endif
					} else if (i == 3) {
						#ifdef LCD_ASYNC_INTERFACE
							Send_Async_Cmd_LCD(LINE2 + LCD_ROWS);
						#else
							Send_Cmd_LCD(LINE2 + LCD_ROWS);
						#endif
					}
				}
				#endif
				
				for (j = 0; j < LCD_ROWS; j++) {
					#ifdef LCD_ASYNC_INTERFACE
						Send_Async_Data_LCD(screenBuffer[i][j]);
					#else
						Send_Data_LCD(screenBuffer[i][j]);
					#endif
				}				
			}
		}
	}
}

void isr_lcd1ms(void) {
	static uint16 doLcdUpdateCnt = 0;
	doLcdUpdateCnt++;
	if (doLcdUpdateCnt >= 250) {
		doLcdUpdateCnt = 0;
		doLcdUpdate = 1;
	}
}

void lcd_put_char(uint8 c) {
	if ((pen_col >= 0) && (pen_col < LCD_COLS) && (pen_row >= 0) && (pen_row < LCD_ROWS)) {
		screenBuffer[pen_col][pen_row] = c;
		pen_row++;
	}
}

void lcd_clearscreen(void) {
	uint32 i = 0;
	for (i = 0; i < LCD_COLS; i++) {
		memset(screenBuffer[i], ' ', LCD_ROWS);
	}
}

void lcd_gotoxy(uint8 row, uint8 col) {
	pen_col = col;
	pen_row = row;
}

void lcd_set_character(uint8 ch, uint8 *data) {
	uint16 x = 0;
	#ifdef LCD_ASYNC_INTERFACE
		Send_Async_Cmd_LCD(CGRAM | (ch << 3));
	#else
		Send_Cmd_LCD(CGRAM | (ch << 3));
	#endif
	for (x = 0; x < 8; x++) {
		#ifdef LCD_ASYNC_INTERFACE
			Send_Async_Data_LCD(data[x]);
		#else
			Send_Data_LCD(data[x]);
		#endif
	}
	#ifdef LCD_ASYNC_INTERFACE
		Send_Async_Cmd_LCD(DDRAM | 0x00);
	#else
		Send_Cmd_LCD(DDRAM | 0x00);
	#endif
}

void lcd_enable_cursor(void) {
	#ifdef LCD_ASYNC_INTERFACE
		Send_Async_Cmd_LCD(DISP_OFF | 0x04 | 0x02);
	#else
		Send_Cmd_LCD(DISP_OFF | 0x04 | 0x02);
	#endif
}

void lcd_disable_cursor(void) {
	#ifdef LCD_ASYNC_INTERFACE
		Send_Async_Cmd_LCD(DISP_OFF | 0x04 | 0x00);
	#else
		Send_Cmd_LCD(DISP_OFF | 0x04 | 0x00);
	#endif
}

void lcd_enable_cursor_blink(void) {
	#ifdef LCD_ASYNC_INTERFACE
		Send_Async_Cmd_LCD(DISP_OFF | 0x04 | 0x02 | 0x01);
	#else
		Send_Cmd_LCD(DISP_OFF | 0x04 | 0x02 | 0x01);
	#endif
}

#ifdef USE_PRINTF_LCD
	int _usart_putc (sint8 c) {
		lcd_put_char(c);
		return 1;
	}
#endif
