#include "global.h"
#include "mal.h"
#include "main.h"
#include "c_main.h"
#include "i_main.h"
#include "w_main.h"
#include "k_stdtype.h"
#include "version.h"
#include "w_app.h"
#include "w_tmr.h"
#include "w_sio.h"
#include "io.h"
#include "tmr.h"
#include "w_io.h"
#include "w_gui.h"
#include "w_led.h"
#include "w_spi.h"
#include "c_app.h"
#include "c_sio.h"
#include "c_task.h"
#include "w_eep_manager.h"
#include "w_SHT1x.h"
#include "w_bmp085.h"
#include "w_lcd_hd44780.h"
#include "w_ad.h"
#include "w_nmeaparser.h"

#include "w_serial_usart1.h" //not for SIO
#ifdef USE_RS232
	#include "w_serial.h"
#endif
#ifdef USE_USB
	#include "w_serial_usb.h"
#endif
#ifdef USE_I2C_SLAVE
	#include "w_iic_slave.h"
#endif

#ifdef USE_CAN_MASTER
	#include "w_can.h"
#endif
#ifdef USE_CAN_SLAVE
	#include "w_can.h"
#endif

#include "w_temperature.h"
#include "w_ds1307.h"
#include "w_rtc.h"
#include "w_usb.h"
#include "w_nrf24l01.h"
#include "sleep.h"

#define SW_YEAR 0x2016
#define SW_MONTH 0x02
#define SW_DAY 0x29
#define SW_TYPE SIO_COMM
#define SW_VERSION 0x0203

SoftwareIdentification softwareIdentification = {SW_YEAR, SW_MONTH, SW_DAY, SW_VERSION, SW_TYPE};
unsigned char VERSION_ID[] = "pic_time_2_0_3";

// Configuration Bit settings
// SYSCLK = "80 MHz (8MHz Crystal/ FPLLIDIV * FPLLMUL / FPLLODIV)
// PBCLK = 40 MHz
// Primary Osc w/PLL (XT+,HS+,EC+PLL)
// WDT OFF
// Other options are don't care
//
    #pragma config UPLLEN   = ON        // USB PLL Enabled
    #pragma config FPLLMUL  = MUL_20        // PLL Multiplier
    #pragma config UPLLIDIV = DIV_2         // USB PLL Input Divider
    #pragma config FPLLIDIV = DIV_2         // PLL Input Divider
    #pragma config FPLLODIV = DIV_1         // PLL Output Divider
    #pragma config FPBDIV   = DIV_2         // Peripheral Clock divisor
    #pragma config FWDTEN   = OFF           // Watchdog Timer
    #pragma config WDTPS    = PS1           // Watchdog Timer Postscale
    #pragma config FCKSM    = CSDCMD        // Clock Switching & Fail Safe Clock Monitor
    #pragma config OSCIOFNC = OFF           // CLKO Enable
    #pragma config POSCMOD  = HS            // Primary Oscillator
    #pragma config IESO     = OFF           // Internal/External Switch-over
    #pragma config FSOSCEN  = OFF           // Secondary Oscillator Enable (KLO was off)
    #pragma config FNOSC    = PRIPLL        // Oscillator Selection
    #pragma config CP       = OFF           // Code Protect
    #pragma config BWP      = OFF           // Boot Flash Write Protect
    #pragma config PWP      = OFF           // Program Flash Write Protect

unsigned char do_loopCnt = 0;
unsigned long loopCntTemp = 0;
unsigned long loopCnt = 0;
unsigned int tick_count = 0;

unsigned long loopCntHistory[60];
unsigned int loopCntHistoryCnt = 0;


int main (void) {
	DDPCON = 0; //Turn off JTAG and TRACE
	SYSTEMConfig(SYS_FREQ, SYS_CFG_WAIT_STATES | SYS_CFG_PCACHE);

	AD1PCFG = 0xFFFF;
	//DDPCONbits.JTAGEN = 0;	//!!!!  Tiltja a JTAG funkcit RAxx lbakon van
	init_ad();

	init_eepmanager();
	init_task();

	init_tmr(); //this should be the first beceaus it clears registered timers.

	init_io();

	init_iic_master();
	#ifdef USE_I2C_SLAVE
		iic_slave_init();
	#endif
	init_nmeaparser();
	init_serial_usart1(9600);//not for SIO
	#ifdef USE_RS232
		init_serial(115200);
	#endif
	#ifdef USE_USB
		init_serial_usb();
		init_usb();
	#endif
	#ifdef USE_CAN_SLAVE
		init_can();
	#endif
	#ifdef USE_CAN_MASTER
		init_can();
	#endif
	init_sio();
	init_ds1307();
	init_led();
	init_temperature();
	init_oneWire();
	init_gui();
	init_app();
	//init_nrf24l01();
	//init_spi();
	init_aes_helper();
	init_isr();
	init_sht();
	init_bmp085();
	init_lcd();
	init_rtc();
	do_loopCnt = 0;

	while (1) {
		if (do_loopCnt) {
			do_loopCnt = 0;
			//lock_isr();
			loopCnt = loopCntTemp; //Risk is here that interrupt corrupts the value, but it is taken
			//unlock_isr();
			loopCntHistory[loopCntHistoryCnt] = loopCnt;
			loopCntHistoryCnt++;
			loopCntHistoryCnt %= ((sizeof(loopCntHistory)) / (sizeof(*loopCntHistory)));
			loopCntTemp = 0;
			if (loopCnt < 1000) { //1run/ms
				/*while (1) {
					Nop();
					ERROR_LED = 1;
				}*/
			}
		}

		do_task();
		do_ad();
		SHTTask();
		do_eepmanager();
		do_app();
		do_temperature();
		do_io();
		do_ds1307();
		do_tmr();
		do_sio();
		do_gui();
		do_led();
		do_nmeaparser();
		do_rtc();
		#ifdef USE_RS232
			do_serial();
		#endif
		#ifdef USE_USB
			do_usb();
			do_serial_usb();
		#endif
		#ifdef USE_CAN_MASTER
			do_can();
		#endif
		#ifdef USE_CAN_SLAVE
			do_can();
		#endif

		do_iic_master();
		do_bmp085();
		//do_nrf24l01();
		//do_spi();
		do_lcd();
		//idle_Request();
		loopCntTemp++;
	}
	return 0;
}

void isr_main_1ms(void) {
	static uint16 loopCntTmr = 0;

	tick_count++;

	loopCntTmr ++;
	if (loopCntTmr == 1000) {
		loopCntTmr = 0;
		do_loopCnt = 1;
	}
}
