#include <string.h>
#include <stdio.h>
#include "k_stdtype.h"

#include "nevnap.h"
#include "c_nevnap.h"
#include "rtc.h"

#ifdef NEVNAP_EKEZET
const char nevnapok1[] = "\
1 Fruzsina,\
2 bel,\
3 Genovva,\
3 Benjmin,\
4 Titusz,\
4 Leona,\
5 Simon,\
6 Boldizsr,\
7 Attila,\
7 Ramna,\
8 Gyngyvr,\
9 Marcell,\
10 Melnia,\
11 gota,\
12 Ern,\
13 Veronika,\
14 Bdog,\
14 Flix,\
15 Lrnt,\
15 Lrnd,\
16 Gusztv,\
16 Stefnia,\
17 Antal,\
17 Antnia,\
18 Piroska,\
19 Sra,\
19 Mri,\
20 Fbin,\
20 Sebestyn,\
21 gnes,\
22 Vince,\
22 Artr,\
23 Zelma,\
23 Rajmund,\
23 Pl,\
24 Timt,\
25 Pl,\
26 Vanda,\
26 Paula,\
27 Angelika,\
27 Angla,\
28 Kroly,\
28 Karola,\
29 Adl,\
30 Martina,\
30 Gerda,\
31 Marcella,\
";

const char nevnapok2[] = "\
1 Ignc,\
1 Virgnia,\
2 Karolina,\
2 Aida,\
3 Balzs,\
4 Rhel,\
4 Csenge,\
5 gota,\
5 Ingrid,\
6 Dorottya,\
6 Dra,\
7 Tdor,\
7 Rme,\
8 Aranka,\
8 Simon,\
9 Abigl,\
9 Alex,\
10 Elvira,\
11 Bertold,\
11 Marietta,\
12 Ldia,\
12 Lvia,\
13 Ella,\
13 Linda,\
14 Blint,\
14 Valentin,\
15 Kolos,\
15 Georgina,\
16 Julianna,\
16 Lilla,\
17 Dont,\
18 Bernadett,\
19 Zsuzsanna,\
20 Aladr,\
20 lmos,\
21 Eleonra,\
22 Gerzson,\
23 Alfrd,\
24 Mtys,\
25 Gza,\
26 Edina,\
27 kos,\
27 Btor,\
28 Elemr,\
";

const char nevnapok3[] = "\
1 Albin,\
1 Simon,\
2 Lujza,\
3 Kornlia,\
4 Kzmr,\
5 Adorjn,\
5 Adrin,\
6 Leonra,\
6 Inez,\
7 Tams,\
8 Zoltn,\
9 Franciska,\
9 Fanni,\
10 Ildik,\
11 Szilrd,\
12 Gergely,\
13 Krisztin,\
13 Ajtony,\
14 Matild,\
15 Kristf,\
16 Henrietta,\
17 Gertrd,\
17 Patrik,\
18 Sndor,\
18 Ede,\
19 Jzsef,\
19 Bnk,\
20 Klaudia,\
21 Benedek,\
22 Beta,\
22 Izolda,\
23 Emke,\
24 Gbor,\
24 Karina,\
25 Irn,\
25 risz,\
26 Emnuel,\
27 Hajnalka,\
28 Gedeon,\
28 Johanna,\
29 Auguszta,\
30 Zaln,\
31 rpd,\
";

const char nevnapok4[] = "\
1 Hug,\
2 ron,\
3 Buda,\
3 Richrd,\
4 Izidor,\
5 Vince,\
6 Vilmos,\
6 Bborka,\
7 Herman,\
8 Dnes,\
9 Erhard,\
10 Zsolt,\
11 Le,\
11 Szaniszl,\
12 Gyula,\
13 Ida,\
14 Tibor,\
15 Anasztzia,\
15 Tas,\
16 Csongor,\
17 Rudolf,\
18 Andrea,\
19 Ilma,\
20 Tivadar,\
21 Konrd,\
22 Csilla,\
22 Nomi,\
23 Bla,\
24 Gyrgy,\
25 Mrk,\
26 Ervin,\
27 Zita,\
27 Mariann,\
28 Valria,\
29 Pter,\
30 Katalin,\
30 Kitti,\
";

const char nevnapok5[] = "\
1 Flp,\
1 Jakab,\
2 Zsigmond,\
3 Tmea,\
3 Irma,\
4 Mnika,\
4 Flrin,\
5 Gyrgyi,\
6 Ivett,\
6 Frida,\
7 Gizella,\
8 Mihly,\
9 Gergely,\
10 rmin,\
10 Plma,\
11 Ferenc,\
12 Pongrc,\
13 Szervc,\
13 Imola,\
14 Bonifc,\
15 Zsfia,\
15 Szonja,\
16 Mzes,\
16 Botond,\
17 Paszkl,\
18 Erik,\
18 Alexandra,\
19 Iv,\
19 Miln,\
20 Bernt,\
20 Felcia,\
21 Konstantin,\
22 Jlia,\
22 Rita,\
23 Dezs,\
24 Eszter,\
24 Eliza,\
25 Orbn,\
26 Flp,\
26 Evelin,\
27 Hella,\
28 Emil,\
28 Csand,\
29 Magdolna,\
30 Janka,\
30 Zsanett,\
31 Angla,\
31 Petronella,\
";

const char nevnapok6[] = "\
1 Tnde,\
1 Torda,\
2 Krmen,\
2 Anita,\
3 Klotild,\
4 Bulcs,\
4 Torms,\
5 Fatime,\
6 Norbert,\
6 Cintia,\
7 Rbert,\
8 Medrd,\
9 Flix,\
10 Margit,\
10 Grta,\
11 Barnabs,\
12 Vill,\
13 Antal,\
13 Anett,\
14 Vazul,\
15 Joln,\
15 Vid,\
16 Jusztin,\
17 Laura,\
17 Alida,\
18 Arnold,\
18 Levente,\
19 Gyrfs,\
20 Rafael,\
21 Alajos,\
21 Leila,\
22 Paulina,\
23 Zoltn,\
23 Szidnia,\
24 Ivn,\
25 Vilmos,\
25 Viola,\
25 Vilma,\
26 Jnos,\
26 Pl,\
27 Lszl,\
28 Levente,\
28 Irn,\
29 Pter,\
29 Pl,\
30 Pl,\
";

const char nevnapok7[] = "\
1 Tihamr,\
1 Annamria,\
2 Ott,\
3 Kornl,\
3 Soma,\
4 Ulrik,\
5 Emese,\
5 Sarolta,\
6 Csaba,\
7 Apollnia,\
8 Ellk,\
9 Lukrcia,\
10 Amlia,\
11 Nra,\
11 Lili,\
12 Izabella,\
12 Dalma,\
13 Jen,\
14 rs,\
14 Stella,\
15 Henrik,\
15 Roland,\
16 Valter,\
17 Endre,\
17 Elek,\
18 Frigyes,\
19 Emlia,\
20 Ills,\
21 Dniel,\
21 Daniella,\
22 Magdolna,\
23 Lenke,\
24 Kinga,\
24 Kincs,\
25 Kristf,\
25 Jakab,\
26 Anna,\
26 Anik,\
27 Olga,\
27 Lilina,\
28 Szabolcs,\
29 Mria,\
29 Flra,\
30 Judit,\
30 Xnia,\
31 Oszkr,\
";

const char nevnapok8[] = "\
1 Boglrka,\
2 Lehel,\
3 Hermina,\
4 Domonkos,\
4 Dominika,\
5 Krisztina,\
6 Berta,\
6 Bettina,\
7 Ibolya,\
8 Lszl,\
9 Emd,\
10 Lrinc,\
11 Zsuzsanna,\
11 Tiborc,\
12 Klra,\
13 Ipoly,\
14 Marcell,\
15 Mria,\
16 brahm,\
17 Jcint,\
18 Ilona,\
19 Huba,\
20 Istvn,\
20 Vajk,\
21 Smuel,\
21 Hajnalka,\
22 Menyhrt,\
22 Mirjam,\
23 Bence,\
24 Bertalan,\
25 Lajos,\
25 Patrcia,\
26 Izs,\
27 Gspr,\
28 goston,\
29 Beatrix,\
29 Erna,\
30 Rzsa,\
31 Erika,\
31 Bella,\
";

const char nevnapok9[] = "\
1 Egyed,\
1 Egon,\
2 Rebeka,\
2 Dorina,\
3 Hilda,\
4 Rozlia,\
5 Viktor,\
5 Lrinc,\
6 Zakaris,\
7 Regina,\
8 Mria,\
8 Adrienn,\
9 dm,\
10 Nikolett,\
10 Hunor,\
11 Teodra,\
12 Mria,\
13 Kornl,\
14 Szerna,\
14 Roxna,\
15 Enik,\
15 Melitta,\
16 Edit,\
17 Zsfia,\
18 Dina,\
19 Vilhelmina,\
20 Friderika,\
21 Mt,\
21 Mirella,\
22 Mric,\
23 Tekla,\
24 Gellrt,\
24 Mercdesz,\
25 Eufrozina,\
25 Kende,\
25 Karola,\
26 Jusztina,\
27 Adalbert,\
28 Vencel,\
29 Mihly,\
30 Jeromos,\
";

const char nevnapok10[] = "\
1 Malvin,\
2 Petra,\
3 Helga,\
4 Ferenc,\
5 Aurl,\
6 Brn,\
6 Renta,\
7 Amlia,\
8 Koppny,\
9 Dnes,\
10 Gedeon,\
11 Brigitta,\
11 Gitta,\
12 Miksa,\
13 Klmn,\
13 Ede,\
14 Heln,\
15 Terz,\
16 Gl,\
17 Hedvig,\
18 Lukcs,\
19 Ndor,\
20 Vendel,\
21 Orsolya,\
22 Eld,\
23 Gyngyi,\
24 Salamon,\
25 Blanka,\
25 Bianka,\
26 Dmtr,\
27 Szabina,\
28 Simon,\
28 Szimonetta,\
29 Nrcisz,\
30 Alfonz,\
31 Farkas,\
";

const char nevnapok11[] = "\
1 Marianna,\
2 Achilles,\
3 Gyz,\
4 Kroly,\
5 Imre,\
6 Lnrt,\
7 Rezs,\
8 Zsombor,\
9 Tivadar,\
10 Rka,\
11 Mrtonzzz,\
11 Martin,\
12 Jns,\
12 Rent,\
13 Szilvia,\
14 Alz,\
15 Albert,\
15 Lipt,\
16 dn,\
17 Hortezina,\
17 Gerg,\
18 Jen,\
19 Erzsbet,\
19 Zska,\
20 Joln,\
21 Olivr,\
22 Ceclia,\
23 Kelemen,\
23 Klementina,\
24 Emma,\
25 Katalin,\
25 Katinka,\
26 Virg,\
27 Virgil,\
28 Stefnia,\
29 Taksony,\
30 Andrs,\
30 Andor,\
30 Andrea,\
";

const char nevnapok12[] = "\
1 Elza,\
2 Melinda,\
2 Vivien,\
3 Ferenc,\
3 Olvia,\
4 Borbla,\
4 Barbara,\
5 Vilma,\
6 Mikls,\
7 Ambrus,\
8 Mria,\
9 Natlia,\
10 Judit,\
11 rpd,\
12 Gabriella,\
13 Luca,\
13 Otlia,\
14 Szilrda,\
15 Valr,\
16 Etelka,\
16 Aletta,\
17 Lzr,\
17 Olimpia,\
18 Auguszta,\
19 Viola,\
20 Teofil,\
21 Tams,\
22 Zn,\
23 Viktria,\
24 dm,\
24 va,\
25 Eugnia,\
26 Istvn,\
27 Jnos,\
28 Kamilla,\
29 Tams,\
29 Tamara,\
30 Dvid,\
31 Szilveszter,\
";
#else
const char nevnapok1[] = "\
1 Fruzsina,\
2 Abel,\
3 Genoveva,\
3 Benjamin,\
4 Titusz,\
4 Leona,\
5 Simon,\
6 Boldizsar,\
7 Attila,\
7 Ramona,\
8 Gyongyver,\
9 Marcell,\
10 Melania,\
11 Agota,\
12 Erno,\
13 Veronika,\
14 Bodog,\
14 Felix,\
15 Lorant,\
15 Lorand,\
16 Gusztav,\
16 Stefania,\
17 Antal,\
17 Antonia,\
18 Piroska,\
19 Sara,\
19 Mario,\
20 Fabian,\
20 Sebestyen,\
21 Agnes,\
22 Vince,\
22 Artur,\
23 Zelma,\
23 Rajmund,\
23 Pal,\
24 Timot,\
25 Pal,\
26 Vanda,\
26 Paula,\
27 Angelika,\
27 Angela,\
28 Karoly,\
28 Karola,\
29 Adel,\
30 Martina,\
30 Gerda,\
31 Marcella,\
";

const char nevnapok2[] = "\
1 Ignac,\
1 Virginia,\
2 Karolina,\
2 Aida,\
3 Balazs,\
4 Rahel,\
4 Csenge,\
5 Agota,\
5 Ingrid,\
6 Dorottya,\
6 Dora,\
7 Todor,\
7 Romeo,\
8 Aranka,\
8 Simon,\
9 Abigel,\
9 Alex,\
10 Elvira,\
11 Bertold,\
11 Marietta,\
12 Lidia,\
12 Livia,\
13 Ella,\
13 Linda,\
14 Balint,\
14 Valentin,\
15 Kolos,\
15 Georgina,\
16 Julianna,\
16 Lilla,\
17 Donat,\
18 Bernadett,\
19 Zsuzsanna,\
20 Aladar,\
20 Almos,\
21 Eleonora,\
22 Gerzson,\
23 Alfred,\
24 Matyas,\
25 Geza,\
26 Edina,\
27 Akos,\
27 Bator,\
28 Elemer,\
";

const char nevnapok3[] = "\
1 Albin,\
1 Simon,\
2 Lujza,\
3 Kornelia,\
4 Kazmer,\
5 Adorjan,\
5 Adrian,\
6 Leonora,\
6 Inez,\
7 Tamas,\
8 Zoltan,\
9 Franciska,\
9 Fanni,\
10 Ildiko,\
11 Szilard,\
12 Gergely,\
13 Krisztian,\
13 Ajtony,\
14 Matild,\
15 Kristof,\
16 Henrietta,\
17 Gertrud,\
17 Patrik,\
18 Sandor,\
18 Ede,\
19 Jozsef,\
19 Bank,\
20 Klaudia,\
21 Benedek,\
22 Beata,\
22 Izolda,\
23 Emoke,\
24 Gabor,\
24 Karina,\
25 Iren,\
25 Irisz,\
26 Emanuel,\
27 Hajnalka,\
28 Gedeon,\
28 Johanna,\
29 Auguszta,\
30 Zalan,\
31 Arpad,\
";

const char nevnapok4[] = "\
1 Hugo,\
2 Aron,\
3 Buda,\
3 Richard,\
4 Izidor,\
5 Vince,\
6 Vilmos,\
6 Biborka,\
7 Herman,\
8 Denes,\
9 Erhard,\
10 Zsolt,\
11 Leo,\
11 Szaniszlo,\
12 Gyula,\
13 Ida,\
14 Tibor,\
15 Anasztazia,\
15 Tas,\
16 Csongor,\
17 Rudolf,\
18 Andrea,\
19 Ilma,\
20 Tivadar,\
21 Konrad,\
22 Csilla,\
22 Noemi,\
23 Bela,\
24 Gyorgy,\
25 Mark,\
26 Ervin,\
27 Zita,\
27 Mariann,\
28 Valeria,\
29 Peter,\
30 Katalin,\
30 Kitti,\
";

const char nevnapok5[] = "\
1 Fulop,\
1 Jakab,\
2 Zsigmond,\
3 Timea,\
3 Irma,\
4 Monika,\
4 Florian,\
5 Gyorgyi,\
6 Ivett,\
6 Frida,\
7 Gizella,\
8 Mihaly,\
9 Gergely,\
10 Armin,\
10 Palma,\
11 Ferenc,\
12 Pongrac,\
13 Szervac,\
13 Imola,\
14 Bonifac,\
15 Zsofia,\
15 Szonja,\
16 Mozes,\
16 Botond,\
17 Paszkal,\
18 Erik,\
18 Alexandra,\
19 Ivo,\
19 Milan,\
20 Bernat,\
20 Felicia,\
21 Konstantin,\
22 Julia,\
22 Rita,\
23 Dezso,\
24 Eszter,\
24 Eliza,\
25 Orban,\
26 Fulop,\
26 Evelin,\
27 Hella,\
28 Emil,\
28 Csanad,\
29 Magdolna,\
30 Janka,\
30 Zsanett,\
31 Angela,\
31 Petronella,\
";

const char nevnapok6[] = "\
1 Tunde,\
1 Torda,\
2 Karmen,\
2 Anita,\
3 Klotild,\
4 Bulcsu,\
4 Tormas,\
5 Fatime,\
6 Norbert,\
6 Cintia,\
7 Robert,\
8 Medard,\
9 Felix,\
10 Margit,\
10 Greta,\
11 Barnabas,\
12 Villo,\
13 Antal,\
13 Anett,\
14 Vazul,\
15 Jolan,\
15 Vid,\
16 Jusztin,\
17 Laura,\
17 Alida,\
18 Arnold,\
18 Levente,\
19 Gyarfas,\
20 Rafael,\
21 Alajos,\
21 Leila,\
22 Paulina,\
23 Zoltan,\
23 Szidonia,\
24 Ivan,\
25 Vilmos,\
25 Viola,\
25 Vilma,\
26 Janos,\
26 Pal,\
27 Laszlo,\
28 Levente,\
28 Iren,\
29 Peter,\
29 Pal,\
30 Pal,\
";

const char nevnapok7[] = "\
1 Tihamer,\
1 Annamaria,\
2 Otto,\
3 Kornel,\
3 Soma,\
4 Ulrik,\
5 Emese,\
5 Sarolta,\
6 Csaba,\
7 Apollonia,\
8 Ellak,\
9 Lukrecia,\
10 Amalia,\
11 Nora,\
11 Lili,\
12 Izabella,\
12 Dalma,\
13 Jeno,\
14 Ors,\
14 Stella,\
15 Henrik,\
15 Roland,\
16 Valter,\
17 Endre,\
17 Elek,\
18 Frigyes,\
19 Emilia,\
20 Illes,\
21 Daniel,\
21 Daniella,\
22 Magdolna,\
23 Lenke,\
24 Kinga,\
24 Kincso,\
25 Kristof,\
25 Jakab,\
26 Anna,\
26 Aniko,\
27 Olga,\
27 Liliana,\
28 Szabolcs,\
29 Maria,\
29 Flora,\
30 Judit,\
30 Xenia,\
31 Oszkar,\
";

const char nevnapok8[] = "\
1 Boglarka,\
2 Lehel,\
3 Hermina,\
4 Domonkos,\
4 Dominika,\
5 Krisztina,\
6 Berta,\
6 Bettina,\
7 Ibolya,\
8 Laszlo,\
9 Emod,\
10 Lorinc,\
11 Zsuzsanna,\
11 Tiborc,\
12 Klara,\
13 Ipoly,\
14 Marcell,\
15 Maria,\
16 Abraham,\
17 Jacint,\
18 Ilona,\
19 Huba,\
20 Istvan,\
20 Vajk,\
21 Samuel,\
21 Hajnalka,\
22 Menyhert,\
22 Mirjam,\
23 Bence,\
24 Bertalan,\
25 Lajos,\
25 Patricia,\
26 Izso,\
27 Gaspar,\
28 Agoston,\
29 Beatrix,\
29 Erna,\
30 Rozsa,\
31 Erika,\
31 Bella,\
";

const char nevnapok9[] = "\
1 Egyed,\
1 Egon,\
2 Rebeka,\
2 Dorina,\
3 Hilda,\
4 Rozalia,\
5 Viktor,\
5 Lorinc,\
6 Zakarias,\
7 Regina,\
8 Maria,\
8 Adrienn,\
9 Adam,\
10 Nikolett,\
10 Hunor,\
11 Teodora,\
12 Maria,\
13 Kornel,\
14 Szerena,\
14 Roxana,\
15 Eniko,\
15 Melitta,\
16 Edit,\
17 Zsofia,\
18 Diana,\
19 Vilhelmina,\
20 Friderika,\
21 Mate,\
21 Mirella,\
22 Moric,\
23 Tekla,\
24 Gellert,\
24 Mercedesz,\
25 Eufrozina,\
25 Kende,\
25 Karola,\
26 Jusztina,\
27 Adalbert,\
28 Vencel,\
29 Mihaly,\
30 Jeromos,\
";

const char nevnapok10[] = "\
1 Malvin,\
2 Petra,\
3 Helga,\
4 Ferenc,\
5 Aurel,\
6 Bruno,\
6 Renata,\
7 Amalia,\
8 Koppany,\
9 Denes,\
10 Gedeon,\
11 Brigitta,\
11 Gitta,\
12 Miksa,\
13 Kalman,\
13 Ede,\
14 Helen,\
15 Terez,\
16 Gal,\
17 Hedvig,\
18 Lukacs,\
19 Nador,\
20 Vendel,\
21 Orsolya,\
22 Elod,\
23 Gyongyi,\
24 Salamon,\
25 Blanka,\
25 Bianka,\
26 Domotor,\
27 Szabina,\
28 Simon,\
28 Szimonetta,\
29 Narcisz,\
30 Alfonz,\
31 Farkas,\
";

const char nevnapok11[] = "\
1 Marianna,\
2 Achilles,\
3 Gyozo,\
4 Karoly,\
5 Imre,\
6 Lenart,\
7 Rezso,\
8 Zsombor,\
9 Tivadar,\
10 Reka,\
11 Marton,\
11 Martin,\
12 Jonas,\
12 Renato,\
13 Szilvia,\
14 Aliz,\
15 Albert,\
15 Lipot,\
16 Odon,\
17 Hortezina,\
17 Gergo,\
18 Jeno,\
19 Erzsebet,\
19 Zsoka,\
20 Jolan,\
21 Oliver,\
22 Cecilia,\
23 Kelemen,\
23 Klementina,\
24 Emma,\
25 Katalin,\
25 Katinka,\
26 Virag,\
27 Virgil,\
28 Stefania,\
29 Taksony,\
30 Andras,\
30 Andor,\
30 Andrea,\
";

const char nevnapok12[] = "\
1 Elza,\
2 Melinda,\
2 Vivien,\
3 Ferenc,\
3 Olivia,\
4 Borbala,\
4 Barbara,\
5 Vilma,\
6 Miklos,\
7 Ambrus,\
8 Maria,\
9 Natalia,\
10 Judit,\
11 Arpad,\
12 Gabriella,\
13 Luca,\
13 Otilia,\
14 Szilard,\
15 Valer,\
16 Etelka,\
16 Aletta,\
17 Lazar,\
17 Olimpia,\
18 Auguszta,\
19 Viola,\
20 Teofil,\
21 Tamas,\
22 Zeno,\
23 Viktoria,\
24 Adam,\
24 va,\
25 Eugenia,\
26 Istvan,\
27 Janos,\
28 Kamilla,\
29 Tamas,\
29 Tamara,\
30 David,\
31 Szilveszter,\
";
#endif

static uint16 getNevnapIndex(uint8 month, uint8 day, uint8 *str, uint32 strSize, uint8 index);
static const char* getNevnapHelper(uint8 month, uint8 day, uint8 index);

uint16 getNevnap(uint16 year, uint8 month, uint8 day, uint8 *str, uint32 strSize) {
	if (is_leap_year(year) && (month == 2)) {
		if (day >= 25) {
			day -= 1;
		}
	}
	return getNevnapIndex(month, day, str, strSize, 0);
}

static uint16 getNevnapIndex(uint8 month, uint8 day, uint8 *str, uint32 strSize, uint8 index) {
	uint16 result = 0;
	if ((str != NULL) && (strSize != 0)) {
		const char *foundPtr = getNevnapHelper(month, day, index);
		if (foundPtr != NULL) {
			uint32 i = 0;
			uint8 c = 0;
			for (i = 0; i < strSize; i++) {
				c = *(foundPtr + i);
				if (c == ',') {
					str[i] = 0;
					result = 1;
					break;
				} else {
					str[i] = c;
				}
			}						
		}
	}
	return result;
}

static const char* getNevnapHelper(uint8 month, uint8 day, uint8 index) {
	const char* result = NULL;
	const char *monthPtr = NULL;
	switch (month) {
		case 1 : {
			monthPtr = nevnapok1;
			break;
		}
		case 2 : {
			monthPtr = nevnapok2;
			break;
		}
		case 3 : {
			monthPtr = nevnapok3;
			break;
		}
		case 4 : {
			monthPtr = nevnapok4;
			break;
		}
		case 5 : {
			monthPtr = nevnapok5;
			break;
		}
		case 6 : {
			monthPtr = nevnapok6;
			break;
		}
		case 7 : {
			monthPtr = nevnapok7;
			break;
		}
		case 8 : {
			monthPtr = nevnapok8;
			break;
		}
		case 9 : {
			monthPtr = nevnapok9;
			break;
		}
		case 10 : {
			monthPtr = nevnapok10;
			break;
		}
		case 11 : {
			monthPtr = nevnapok11;
			break;
		}
		case 12 : {
			monthPtr = nevnapok12;
			break;
		}
	}
	if (monthPtr != NULL) {
		uint8 cnt = 0;
		char nevnapTemp[12];
		uint32 nevnapTempLen = 0;
		uint32 monthPtrLen = strlen(monthPtr);

		memset(nevnapTemp, 0x00, (sizeof(nevnapTemp) / sizeof(*nevnapTemp)) );
		sprintf(nevnapTemp, "%u ", day);
		nevnapTempLen = strlen(nevnapTemp);
		{
			unsigned int x = 0;
			for (x = 0 ; x < (monthPtrLen - nevnapTempLen); x++) {
				if (strncmp(monthPtr + x, nevnapTemp, nevnapTempLen) == 0) {
					if (cnt == index) {
						result = monthPtr + x + nevnapTempLen;
						break;
					} else {
						cnt++;
					}
				}
			}
		}
	}
	return result;
}
