#include <string.h>
#include "sio.h"
#include "c_sio.h"
#include "e_sio.h"

#include "main.h"

unsigned int * Param(uint16 idx) {
	unsigned int *result = NULL;
	uint16 maxCnt = getsioParamIDXItemCnt();
	uint16 i = 0;
	for (i = 0; i < maxCnt; i++) {
		if (sioParamIDX[i].idx == idx) {
			#ifdef SIO_ACCESS_LEVEL
				if (sio_access_level_current >= sioParamIDX[i].sio_access_level) {
					result = sioParamIDX[i].ptr;
				} else {
					result = NULL;
				}
			#else
				result = sioParamIDX[i].ptr;
			#endif
			break;
		}
	}
	return result;
}

void RdVersionID(void) {
	uint8 data[2];
	uint16 length = 2;
	data[0] = (softwareIdentification.version >> 8) & 0xFF;
	data[1] = softwareIdentification.version & 0xFF;
	sioSendPacketWrapper(CMD_VERSIONID, data, length);
}

void RdVersionStr(void) {
	uint8 versionid_buffer[28];
	memset(versionid_buffer, 0x00, (sizeof(versionid_buffer) / sizeof(*versionid_buffer)));
	strcpy((sint8 *)versionid_buffer, (sint8 *)VERSION_ID);
	sioSendPacketWrapper(CMD_VERSIONSTR, (uint8 *)versionid_buffer, (sizeof(versionid_buffer) / sizeof(*versionid_buffer)));
}

void RdParamBuf(uint8 *payload, uint16 payloadLength) {
	uint16 idx = (payload[0] << 8) + payload[1];
	uint8 data[32];
	uint16 length = 32;
	Param_Rd(idx);
	ParamBuff_Rd(idx, data, &length);
	sioSendPacketWrapper(CMD_RDPARAMBUF, data, length);
}

void WrParamBuf(uint8 *payload, uint16 payloadLength) {
	uint16 idx = (payload[0] << 8) + payload[1];
	Param_Wr(idx);
	ParamBuff_Wr(idx, payload + 2, payloadLength - 2);
	sioSendPacketWrapper(CMD_WRPARAMBUF, payload + 2, payloadLength - 2);	
}

void RdParam(uint8 *payload, uint16 payloadLength) {
	uint16 idx = (payload[0] << 8) + payload[1];
	unsigned int *p = NULL;
	uint8 i = 0;
	Param_Rd(idx);
 	p = Param(idx);
	if (p != NULL) {
		i = *p;
		{
			sioSendPacketWrapper(CMD_RDPARAM, &i, 1);
		}
	} else {
	}
}

void WrParam(uint8 *payload, uint16 payloadLength) {
	uint16 idx = (payload[0] << 8) + payload[1];
	unsigned int *p = NULL;
	uint8 i = *(payload + 2);
 	p = Param(idx);
	if (p != NULL) {
		*p = i;
		Param_Wr(idx);
		{
			sioSendPacketWrapper(CMD_WRPARAM, &i, 1);
		}
	} else {
	}
}

void RdParamW(uint8 *payload, uint16 payloadLength) {
	uint16 idx = (payload[0] << 8) + payload[1];
	unsigned int *p = NULL;
	uint16 i = 0;
	Param_Rd(idx);
 	p = Param(idx);
	if (p != NULL) {
		i = *p;
		{
			uint8 data[2] = {((i >> 8) & 0xFF), ((i) & 0xFF)};
			sioSendPacketWrapper(CMD_RDPARAMW, data, 2);
		}
	} else {
	}
}

void WrparamW(uint8 *payload, uint16 payloadLength) {
	uint16 idx = (payload[0] << 8) + payload[1];
	unsigned int *p = NULL;
	uint16 i = (*(payload + 2) << 8) + (*(payload + 3));
 	p = Param(idx);
	if (p != NULL) {
		*p = i;
		Param_Wr(idx);
		{
			uint8 data[2] = {((i >> 8) & 0xFF), ((i) & 0xFF)};
			sioSendPacketWrapper(CMD_WRPARAMW, data, 2);
		}
	} else {
	}
}

void RdParamL(uint8 *payload, uint16 payloadLength) {
	uint16 idx = (payload[0] << 8) + payload[1];
	uint32 *p = NULL;
	uint32 i = 0;
	Param_Rd(idx);
 	p = (uint32 *)Param(idx);
	if (p != NULL) {
		i = *p;
		{
			uint8 data[4] = {((i >> 24) & 0xFF), ((i >> 16) & 0xFF), ((i >> 8) & 0xFF), ((i) & 0xFF)};
			sioSendPacketWrapper(CMD_RDPARAML, data, 4);
		}
	} else {
	}
}

void WrParamL(uint8 *payload, uint16 payloadLength) {
	uint16 idx = (payload[0] << 8) + payload[1];
	uint32 *p = NULL;
	uint32 i = ((uint32)*(payload + 2) << 24) + ((uint32)*(payload + 3) << 16) + ((uint32)*(payload + 4) << 8) + ((uint32)*(payload + 5));
 	p = (uint32 *)Param(idx);
	if (p != NULL) {
		*p = i;
		Param_Wr(idx);
		{
			uint8 data[4] = {((i >> 24) & 0xFF), ((i >> 16) & 0xFF), ((i >> 8) & 0xFF), ((i) & 0xFF)};
			sioSendPacketWrapper(CMD_WRPARAML, data, 4);
		}
	} else {
	}
}

void RdParamF(uint8 *payload, uint16 payloadLength) {
	uint16 idx = (payload[0] << 8) + payload[1];
	uint32 *p = NULL;
	uint32 i = 0;
	Param_Rd(idx);
 	p = (uint32 *)Param(idx);
	if (p != NULL) {
		i = *p;
		{
			uint8 data[4];
			uint16 length = 4;
			memcpy(data, &i, 4);
			sioSendPacketWrapper(CMD_RDPARAMF, data, length);
		}
	} else {
	}
}

void WrParamF(uint8 *payload, uint16 payloadLength) {
	uint16 idx = (payload[0] << 8) + payload[1];
	uint32 *p = NULL;
	uint32 i = 0;
	memcpy(&i, payload + 2, 4);
 	p = (uint32 *)Param(idx);
	if (p != NULL) {
		*p = i;
		Param_Wr(idx);
		{
			uint8 data[4];
			uint16 length = 4;
			memcpy(data, &i, 4);
			sioSendPacketWrapper(CMD_WRPARAMF, data, length);
		}
	} else {
	}
}

void GetSeed(uint8 *payload, uint16 payloadLength) {
	#ifdef SIO_ACCESS_LEVEL
		uint8 seedTemp[SIO_SEED_LENGTH];
		sio_getSeed(seedTemp);
		sioSendPacketWrapper(CMD_GETSEED, seedTemp, SIO_SEED_LENGTH);	
	#endif
}

void CheckKey(uint8 *payload, uint16 payloadLength) {
	#ifdef SIO_ACCESS_LEVEL
		uint8 data[1] = {0x00};
		uint16 length = 1;
		data[0] = sio_checkKey(payload + 1, payload[0]);
		sioSendPacketWrapper(CMD_CHECKKEY, data, length);
	#endif
}

void GetValidId(uint8 *payload, uint16 payloadLength) {
	uint8 data[33];
	uint32 i = 0;
	uint8 paramCnt = getsioParamIDXItemCnt();
	if (paramCnt > 32) {
		paramCnt = 32;
	}
	data[0] = paramCnt;
	for (i = 0; i < paramCnt; i++) {
		data[1 + (i * 2)] = (sioParamIDX[i].idx >> 8) & 0xFF;
		data[2 + (i * 2)] = (sioParamIDX[i].idx) & 0xFF;
	}
	sioSendPacketWrapper(CMD_GETVALIDID, data, (paramCnt * 2) + 1);	
}
