#include <string.h>
#include "sio_test.h"
//#include "c_sio_test.h"
//#include "i_sio_test.h"
#include "w_sio_test.h"
#include "c_sio.h"
#include "e_sio.h"

#include "k_stdtype.h"
#include "ringbuffer.h"
#include "main.h"

#define SIO_TEST_BUFFER_CNT 128

typedef enum _SioTestResult {
	SioTestResult_NotTested = 0,
	SioTestResult_Passed = 1,
	SioTestResult_Pending = 0x55,
	SioTestResult_Failed = 0xFF,
} SioTestResult;

typedef SioTestResult (*SioTestFnc)(void);

typedef struct _SioTests {
	SioTestResult sioTestResult;
	SioTestFnc fnc;
} SioTests;

RingBuffer myRingBuffer_sio_test_rx;
uint8 myRingBuffer_sio_test_rx_buffer[SIO_TEST_BUFFER_CNT];
RingBuffer myRingBuffer_sio_test_tx;
uint8 myRingBuffer_sio_test_tx_buffer[SIO_TEST_BUFFER_CNT];

unsigned long missedTxChar_test = 0;
unsigned long missedRxChar_test = 0;

unsigned char packetTest[128];
unsigned char packetCnt = 0;
uint8 doSioTest1ms = 0;

SioTestResult sio_test_TC1(void); //CMD_VERSIONID
SioTestResult sio_test_TC2(void); //CMD_VERSIONSTR
SioTestResult sio_test_TC3(void); //CMD_RDPARAM
SioTestResult sio_test_TC4(void); //CMD_WRPARAM
SioTestResult sio_test_TC5(void); //CMD_RDPARAMW
SioTestResult sio_test_TC6(void); //CMD_WRPARAMW
SioTestResult sio_test_TC7(void); //CMD_RDPARAML
SioTestResult sio_test_TC8(void); //CMD_WRPARAML
SioTestResult sio_test_TC9(void); //CMD_WRPARAMF
SioTestResult sio_test_TC10(void); //CMD_RDPARAMF
SioTestResult sio_test_TC11(void); //CMD_RDPARAMBUF
SioTestResult sio_test_TC12(void); //CMD_WRPARAMBUF
SioTestResult sio_test_TC13(void); //CMD_RESET Can not be implemented due to real reset
SioTestResult sio_test_TC14(void); //CMD_GETSEED
SioTestResult sio_test_TC15(void); //CMD_CHECKKEY
SioTestResult sio_test_TC16(void); //CMD_GETVALIDID TODO
SioTestResult sio_test_TC17(void); //CMD_WRPARAMW Find Packet
SioTestResult sio_test_TC18(void); //CMD_WRPARAMW Packet contains end
SioTestResult sio_test_TC19(void); //CMD_WRPARAMW Spamming buffer
int sio_test_get_tx(void);
void sio_test_add_rx(unsigned char data);
uint32 sio_test_calulate_crc32(unsigned char *data, uint16 length);

SioTests sioTests[] = {
	{SioTestResult_NotTested, &sio_test_TC1},
	{SioTestResult_NotTested, &sio_test_TC2},
	{SioTestResult_NotTested, &sio_test_TC3},
	{SioTestResult_NotTested, &sio_test_TC4},
	{SioTestResult_NotTested, &sio_test_TC5},
	{SioTestResult_NotTested, &sio_test_TC6},
	{SioTestResult_NotTested, &sio_test_TC7},
	{SioTestResult_NotTested, &sio_test_TC8},
	{SioTestResult_NotTested, &sio_test_TC9},
	{SioTestResult_NotTested, &sio_test_TC10},
	{SioTestResult_NotTested, &sio_test_TC11},
	{SioTestResult_NotTested, &sio_test_TC12},
	{SioTestResult_NotTested, &sio_test_TC13},
	{SioTestResult_NotTested, &sio_test_TC14},
	{SioTestResult_NotTested, &sio_test_TC15},
	{SioTestResult_NotTested, &sio_test_TC16},
	{SioTestResult_NotTested, &sio_test_TC17},
	{SioTestResult_NotTested, &sio_test_TC18},
	{SioTestResult_NotTested, &sio_test_TC19},
};

void init_sio_test(void) {
	ringBuffer_initBuffer(&myRingBuffer_sio_test_rx, myRingBuffer_sio_test_rx_buffer, SIO_TEST_BUFFER_CNT);
	ringBuffer_initBuffer(&myRingBuffer_sio_test_tx, myRingBuffer_sio_test_tx_buffer, SIO_TEST_BUFFER_CNT);
	
}

void do_sio_test(void) {
	if (doSioTest1ms) {
		doSioTest1ms = 0;
		{
			uint16 i = 0;
			for (i = 0; i < (sizeof(sioTests)/sizeof(*sioTests)); i++) {
				if ((sioTests[i].sioTestResult == SioTestResult_Pending) || (sioTests[i].sioTestResult == SioTestResult_NotTested)) {
					if (sioTests[i].fnc != NULL) {
						sioTests[i].sioTestResult = sioTests[i].fnc();
						break;
					}
				}
			}
		}
		
	}
}

void isr_sio_test_1ms(void) {	
	doSioTest1ms = 1;
}

int getCharTest(void) {
	int result = -1;
	unsigned char data = 0;
	if (ringBuffer_getItem(&myRingBuffer_sio_test_rx, &data) != 0) {
		result = data;
	}
	return result;
}

void putChar_Test(unsigned char data) {
	if (ringBuffer_addItem(&myRingBuffer_sio_test_tx, data) != -1) {
	} else {
		missedTxChar_test++;
	}
}

void flush_Test(void) {
}

SioTestResult sio_test_TC1(void) { //CMD_VERSIONID
	SioTestResult result = SioTestResult_Pending;

	static uint16 tcStateCnt = 0;
	switch (tcStateCnt) {
		case 0 : {
			{
				//unsigned char payload[0];
				uint32 crc = 0;
				uint32 i = 0;
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
				memset(packetTest, 0x00, 128);
				packetCnt = 0;
				packetTest[packetCnt++] = CMD_START; 					//Start

				packetTest[packetCnt++] = 0x00; 						//LengthH
				packetTest[packetCnt++] = 0x00; 						//LengthL

				packetTest[packetCnt++] = (SIO_ADDRESS >> 8) & 0xFF; 	//AddressH
				packetTest[packetCnt++] = (SIO_ADDRESS) & 0xFF; 		//AddressL
				
				packetTest[packetCnt++] = (CMD_VERSIONID >> 8) & 0xFF;	//CommandH
				packetTest[packetCnt++] = (CMD_VERSIONID) & 0xFF; 		//CommandL
				
				packetTest[packetCnt++] = 0; 							//CrcHH
				packetTest[packetCnt++] = 0; 							//CrcHL
				packetTest[packetCnt++] = 0; 							//CrcLH
				packetTest[packetCnt++] = 0; 							//CrcLL

				/*for (i = 0; i < sizeof(payload) / sizeof(payload); i++) {
					sio_test_add_rx(payload[i]); 					//payload
				}*/
				
				packetTest[packetCnt++] = CMD_END;						//Stop
				
				crc = sio_test_calulate_crc32(packetTest, packetCnt);
				packetTest[PACKET_CRCHH_POS] = (crc >> 24) & 0xFF; 			//CrcHH
				packetTest[PACKET_CRCHL_POS] = (crc >> 16) & 0xFF; 			//CrcHL
				packetTest[PACKET_CRCLH_POS] = (crc >> 8) & 0xFF; 			//CrcLH
				packetTest[PACKET_CRCLL_POS] = (crc) & 0xFF; 				//CrcLL

				for (i = 0; i < packetCnt; i++) {
					sio_test_add_rx(packetTest[i]);
				}
				isr_communication();
			}
			tcStateCnt++;
			break;
		}
		case 20 : {
			//Check is SIO was called
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
			result = SioTestResult_Passed;
			if (sio_test_get_tx() != CMD_START) {//Start
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//LengthH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x02) {//LengthL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_VERSIONID >> 8) & 0xFF)) {//CommandH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_VERSIONID) & 0xFF)) {//CommandL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x77) {//CrcHH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x28) {//CrcHL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x50) {//CrcLH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x4A) {//CrcLL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((softwareIdentification.version >> 8)& 0xFF)) {//payload VersionH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != (softwareIdentification.version & 0xFF)) {//payload VersionL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != CMD_END) {//Stop
				result = SioTestResult_Failed;
			}
			tcStateCnt++;
			break;
		}
		case 255 : {
			result = SioTestResult_Failed;
			tcStateCnt++;
			break;
		}
		default : {
			tcStateCnt++;
			break;
		}
	}
	return result;
}

SioTestResult sio_test_TC2(void) {//CMD_VERSIONSTR
	SioTestResult result = SioTestResult_Pending;
	static uint16 tcStateCnt = 0;
	switch (tcStateCnt) {
		case 0 : {
			{
				//unsigned char payload[0];
				uint32 crc = 0;
				uint32 i = 0;
			//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
				memset(packetTest, 0x00, 128);
				packetCnt = 0;
				packetTest[packetCnt++] = CMD_START; 					//Start

				packetTest[packetCnt++] = 0x00; 						//LengthH
				packetTest[packetCnt++] = 0x00; 						//LengthL

				packetTest[packetCnt++] = (SIO_ADDRESS >> 8) & 0xFF; 	//AddressH
				packetTest[packetCnt++] = (SIO_ADDRESS) & 0xFF; 		//AddressL
				
				packetTest[packetCnt++] = (CMD_VERSIONSTR >> 8) & 0xFF;	//CommandH
				packetTest[packetCnt++] = (CMD_VERSIONSTR) & 0xFF; 		//CommandL
				
				packetTest[packetCnt++] = 0; 							//CrcHH
				packetTest[packetCnt++] = 0; 							//CrcHL
				packetTest[packetCnt++] = 0; 							//CrcLH
				packetTest[packetCnt++] = 0; 							//CrcLL

				/*for (i = 0; i < sizeof(payload) / sizeof(payload); i++) {
					sio_test_add_rx(payload[i]); 					//payload
				}*/
				
				packetTest[packetCnt++] = CMD_END;						//Stop
				
				crc = sio_test_calulate_crc32(packetTest, packetCnt);
				packetTest[PACKET_CRCHH_POS] = (crc >> 24) & 0xFF; 			//CrcHH
				packetTest[PACKET_CRCHL_POS] = (crc >> 16) & 0xFF; 			//CrcHL
				packetTest[PACKET_CRCLH_POS] = (crc >> 8) & 0xFF; 			//CrcLH
				packetTest[PACKET_CRCLL_POS] = (crc) & 0xFF; 				//CrcLL

				for (i = 0; i < packetCnt; i++) {
					sio_test_add_rx(packetTest[i]);
				}
				isr_communication();
			}
			tcStateCnt++;
			break;
		}
		case 20 : {
			//Check is SIO was called
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
			result = SioTestResult_Passed;
			if (sio_test_get_tx() != CMD_START) {//Start
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//LengthH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x1C) {//LengthL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_VERSIONSTR >> 8) & 0xFF)) {//CommandH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_VERSIONSTR) & 0xFF)) {//CommandL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x57) {//CrcHH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x46) {//CrcHL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xBD) {//CrcLH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xA3) {//CrcLL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 'P') {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 'I') {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 'C') {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != '3') {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != '2') {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ' ') {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 'R') {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 'A') {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 'D') {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 'I') {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 'O') {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ' ') {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 'M') {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 'A') {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 'S') {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 'T') {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 'E') {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 'R') {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != CMD_END) {//Stop
				result = SioTestResult_Failed;
			}
			tcStateCnt++;
			break;
		}
		case 255 : {
			result = SioTestResult_Failed;
			tcStateCnt++;
			break;
		}
		default : {
			tcStateCnt++;
			break;
		}
	}
	return result;
}

SioTestResult sio_test_TC3(void) {//CMD_RDPARAM
	SioTestResult result = SioTestResult_Pending;
	static uint16 tcStateCnt = 0;
	switch (tcStateCnt) {
		case 0 : {
			{
				unsigned char payload[2] = {((0x0001 >> 8) & 0xFF), ((0x0001) & 0xFF)};
				uint32 crc = 0;
				uint32 i = 0;
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
				memset(packetTest, 0x00, 128);
				packetCnt = 0;
				packetTest[packetCnt++] = CMD_START; 					//Start

				packetTest[packetCnt++] = 0x00; 						//LengthH
				packetTest[packetCnt++] = 0x02; 						//LengthL

				packetTest[packetCnt++] = (SIO_ADDRESS >> 8) & 0xFF; 	//AddressH
				packetTest[packetCnt++] = (SIO_ADDRESS) & 0xFF; 		//AddressL
				
				packetTest[packetCnt++] = (CMD_RDPARAM >> 8) & 0xFF;	//CommandH
				packetTest[packetCnt++] = (CMD_RDPARAM) & 0xFF; 		//CommandL
				
				packetTest[packetCnt++] = 0; 							//CrcHH
				packetTest[packetCnt++] = 0; 							//CrcHL
				packetTest[packetCnt++] = 0; 							//CrcLH
				packetTest[packetCnt++] = 0; 							//CrcLL

				for (i = 0; i < sizeof(payload) / sizeof(*payload); i++) {
					packetTest[packetCnt++] = payload[i]; 							//payload
				}
				
				packetTest[packetCnt++] = CMD_END;						//Stop
				
				crc = sio_test_calulate_crc32(packetTest, packetCnt);
				packetTest[PACKET_CRCHH_POS] = (crc >> 24) & 0xFF; 			//CrcHH
				packetTest[PACKET_CRCHL_POS] = (crc >> 16) & 0xFF; 			//CrcHL
				packetTest[PACKET_CRCLH_POS] = (crc >> 8) & 0xFF; 			//CrcLH
				packetTest[PACKET_CRCLL_POS] = (crc) & 0xFF; 				//CrcLL

				for (i = 0; i < packetCnt; i++) {
					sio_test_add_rx(packetTest[i]);
				}
				isr_communication();
			}
			tcStateCnt++;
			break;
		}
		case 20 : {
			//Check is SIO was called
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
			result = SioTestResult_Passed;
			if (sio_test_get_tx() != CMD_START) {//Start
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//LengthH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x01) {//LengthL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_RDPARAM >> 8) & 0xFF)) {//CommandH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_RDPARAM) & 0xFF)) {//CommandL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x38) {//CrcHH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x22) {//CrcHL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x01) {//CrcLH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x05) {//CrcLL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x01) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != CMD_END) {//Stop
				result = SioTestResult_Failed;
			}
			tcStateCnt++;
			break;
		}
		case 255 : {
			result = SioTestResult_Failed;
			tcStateCnt++;
			break;
		}
		default : {
			tcStateCnt++;
			break;
		}
	}
	return result;
}

SioTestResult sio_test_TC4(void) {//CMD_WRPARAM
	SioTestResult result = SioTestResult_Pending;
	static uint16 tcStateCnt = 0;
	switch (tcStateCnt) {
		case 0 : {
			{
				unsigned char payload[3] = {((0x0001 >> 8) & 0xFF), ((0x0001) & 0xFF), 0x03};
				uint32 crc = 0;
				uint32 i = 0;
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
				memset(packetTest, 0x00, 128);
				packetCnt = 0;
				packetTest[packetCnt++] = CMD_START; 					//Start

				packetTest[packetCnt++] = 0x00; 						//LengthH
				packetTest[packetCnt++] = 0x03; 						//LengthL

				packetTest[packetCnt++] = (SIO_ADDRESS >> 8) & 0xFF; 	//AddressH
				packetTest[packetCnt++] = (SIO_ADDRESS) & 0xFF; 		//AddressL
				
				packetTest[packetCnt++] = (CMD_WRPARAM >> 8) & 0xFF;	//CommandH
				packetTest[packetCnt++] = (CMD_WRPARAM) & 0xFF; 		//CommandL
				
				packetTest[packetCnt++] = 0; 							//CrcHH
				packetTest[packetCnt++] = 0; 							//CrcHL
				packetTest[packetCnt++] = 0; 							//CrcLH
				packetTest[packetCnt++] = 0; 							//CrcLL

				for (i = 0; i < sizeof(payload) / sizeof(*payload); i++) {
					packetTest[packetCnt++] = payload[i]; 							//payload
				}
				
				packetTest[packetCnt++] = CMD_END;						//Stop
				
				crc = sio_test_calulate_crc32(packetTest, packetCnt);
				packetTest[PACKET_CRCHH_POS] = (crc >> 24) & 0xFF; 			//CrcHH
				packetTest[PACKET_CRCHL_POS] = (crc >> 16) & 0xFF; 			//CrcHL
				packetTest[PACKET_CRCLH_POS] = (crc >> 8) & 0xFF; 			//CrcLH
				packetTest[PACKET_CRCLL_POS] = (crc) & 0xFF; 				//CrcLL

				for (i = 0; i < packetCnt; i++) {
					sio_test_add_rx(packetTest[i]);
				}
				isr_communication();
			}
			tcStateCnt++;
			break;
		}
		case 20 : {
			//Check is SIO was called
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
			result = SioTestResult_Passed;
			if (sio_test_get_tx() != CMD_START) {//Start
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//LengthH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x01) {//LengthL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_WRPARAM >> 8) & 0xFF)) {//CommandH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_WRPARAM) & 0xFF)) {//CommandL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x3A) {//CrcHH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x5B) {//CrcHL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x93) {//CrcLH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x52) {//CrcLL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x03) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != CMD_END) {//Stop
				result = SioTestResult_Failed;
			}
			tcStateCnt++;
			break;
		}
		case 255 : {
			result = SioTestResult_Failed;
			tcStateCnt++;
			break;
		}
		default : {
			tcStateCnt++;
			break;
		}
	}
	return result;
}

SioTestResult sio_test_TC5(void) {//CMD_RDPARAMW
	SioTestResult result = SioTestResult_Pending;
	static uint16 tcStateCnt = 0;
	switch (tcStateCnt) {
		case 0 : {
			{
				unsigned char payload[2] = {((0x0001 >> 8) & 0xFF), ((0x0001) & 0xFF)};
				uint32 crc = 0;
				uint32 i = 0;
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
				memset(packetTest, 0x00, 128);
				packetCnt = 0;
				packetTest[packetCnt++] = CMD_START; 					//Start

				packetTest[packetCnt++] = 0x00; 						//LengthH
				packetTest[packetCnt++] = 0x02; 						//LengthL

				packetTest[packetCnt++] = (SIO_ADDRESS >> 8) & 0xFF; 	//AddressH
				packetTest[packetCnt++] = (SIO_ADDRESS) & 0xFF; 		//AddressL
				
				packetTest[packetCnt++] = (CMD_RDPARAMW >> 8) & 0xFF;	//CommandH
				packetTest[packetCnt++] = (CMD_RDPARAMW) & 0xFF; 		//CommandL
				
				packetTest[packetCnt++] = 0; 							//CrcHH
				packetTest[packetCnt++] = 0; 							//CrcHL
				packetTest[packetCnt++] = 0; 							//CrcLH
				packetTest[packetCnt++] = 0; 							//CrcLL

				for (i = 0; i < sizeof(payload) / sizeof(*payload); i++) {
					packetTest[packetCnt++] = payload[i]; 							//payload
				}
				
				packetTest[packetCnt++] = CMD_END;						//Stop
				
				crc = sio_test_calulate_crc32(packetTest, packetCnt);
				packetTest[PACKET_CRCHH_POS] = (crc >> 24) & 0xFF; 			//CrcHH
				packetTest[PACKET_CRCHL_POS] = (crc >> 16) & 0xFF; 			//CrcHL
				packetTest[PACKET_CRCLH_POS] = (crc >> 8) & 0xFF; 			//CrcLH
				packetTest[PACKET_CRCLL_POS] = (crc) & 0xFF; 				//CrcLL

				for (i = 0; i < packetCnt; i++) {
					sio_test_add_rx(packetTest[i]);
				}
				isr_communication();
			}
			tcStateCnt++;
			break;
		}
		case 20 : {
			//Check is SIO was called
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
			result = SioTestResult_Passed;
			if (sio_test_get_tx() != CMD_START) {//Start
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//LengthH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x02) {//LengthL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_RDPARAMW >> 8) & 0xFF)) {//CommandH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_RDPARAMW) & 0xFF)) {//CommandL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x61) {//CrcHH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x23) {//CrcHL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x46) {//CrcLH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x3E) {//CrcLL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x03) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != CMD_END) {//Stop
				result = SioTestResult_Failed;
			}
			tcStateCnt++;
			break;
		}
		case 255 : {
			result = SioTestResult_Failed;
			tcStateCnt++;
			break;
		}
		default : {
			tcStateCnt++;
			break;
		}
	}
	return result;
}

SioTestResult sio_test_TC6(void) {//CMD_WRPARAMW
	SioTestResult result = SioTestResult_Pending;
	static uint16 tcStateCnt = 0;
	switch (tcStateCnt) {
		case 0 : {
			{
				unsigned char payload[4] = {((0x0001 >> 8) & 0xFF), ((0x0001) & 0xFF), 0x00, 0x03};
				uint32 crc = 0;
				uint32 i = 0;
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
				memset(packetTest, 0x00, 128);
				packetCnt = 0;
				packetTest[packetCnt++] = CMD_START; 					//Start

				packetTest[packetCnt++] = 0x00; 						//LengthH
				packetTest[packetCnt++] = 0x04; 						//LengthL

				packetTest[packetCnt++] = (SIO_ADDRESS >> 8) & 0xFF; 	//AddressH
				packetTest[packetCnt++] = (SIO_ADDRESS) & 0xFF; 		//AddressL
				
				packetTest[packetCnt++] = (CMD_WRPARAMW >> 8) & 0xFF;	//CommandH
				packetTest[packetCnt++] = (CMD_WRPARAMW) & 0xFF; 		//CommandL
				
				packetTest[packetCnt++] = 0; 							//CrcHH
				packetTest[packetCnt++] = 0; 							//CrcHL
				packetTest[packetCnt++] = 0; 							//CrcLH
				packetTest[packetCnt++] = 0; 							//CrcLL

				for (i = 0; i < sizeof(payload) / sizeof(*payload); i++) {
					packetTest[packetCnt++] = payload[i]; 							//payload
				}
				
				packetTest[packetCnt++] = CMD_END;						//Stop
				
				crc = sio_test_calulate_crc32(packetTest, packetCnt);
				packetTest[PACKET_CRCHH_POS] = (crc >> 24) & 0xFF; 			//CrcHH
				packetTest[PACKET_CRCHL_POS] = (crc >> 16) & 0xFF; 			//CrcHL
				packetTest[PACKET_CRCLH_POS] = (crc >> 8) & 0xFF; 			//CrcLH
				packetTest[PACKET_CRCLL_POS] = (crc) & 0xFF; 				//CrcLL

				for (i = 0; i < packetCnt; i++) {
					sio_test_add_rx(packetTest[i]);
				}
				isr_communication();
			}
			tcStateCnt++;
			break;
		}
		case 20 : {
			//Check is SIO was called
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
			result = SioTestResult_Passed;
			if (sio_test_get_tx() != CMD_START) {//Start
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//LengthH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x02) {//LengthL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_WRPARAMW >> 8) & 0xFF)) {//CommandH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_WRPARAMW) & 0xFF)) {//CommandL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x61) {//CrcHH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x23) {//CrcHL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x46) {//CrcLH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x3E) {//CrcLL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x03) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != CMD_END) {//Stop
				result = SioTestResult_Failed;
			}
			tcStateCnt++;
			break;
		}
		case 255 : {
			result = SioTestResult_Failed;
			tcStateCnt++;
			break;
		}
		default : {
			tcStateCnt++;
			break;
		}
	}
	return result;
}

SioTestResult sio_test_TC7(void) {//CMD_RDPARAML
	SioTestResult result = SioTestResult_Pending;
	static uint16 tcStateCnt = 0;
	switch (tcStateCnt) {
		case 0 : {
			{
				unsigned char payload[2] = {((0x0001 >> 8) & 0xFF), ((0x0001) & 0xFF)};
				uint32 crc = 0;
				uint32 i = 0;
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
				memset(packetTest, 0x00, 128);
				packetCnt = 0;
				packetTest[packetCnt++] = CMD_START; 					//Start

				packetTest[packetCnt++] = 0x00; 						//LengthH
				packetTest[packetCnt++] = 0x02; 						//LengthL

				packetTest[packetCnt++] = (SIO_ADDRESS >> 8) & 0xFF; 	//AddressH
				packetTest[packetCnt++] = (SIO_ADDRESS) & 0xFF; 		//AddressL
				
				packetTest[packetCnt++] = (CMD_RDPARAML >> 8) & 0xFF;	//CommandH
				packetTest[packetCnt++] = (CMD_RDPARAML) & 0xFF; 		//CommandL
				
				packetTest[packetCnt++] = 0; 							//CrcHH
				packetTest[packetCnt++] = 0; 							//CrcHL
				packetTest[packetCnt++] = 0; 							//CrcLH
				packetTest[packetCnt++] = 0; 							//CrcLL

				for (i = 0; i < sizeof(payload) / sizeof(*payload); i++) {
					packetTest[packetCnt++] = payload[i]; 							//payload
				}
				
				packetTest[packetCnt++] = CMD_END;						//Stop
				
				crc = sio_test_calulate_crc32(packetTest, packetCnt);
				packetTest[PACKET_CRCHH_POS] = (crc >> 24) & 0xFF; 			//CrcHH
				packetTest[PACKET_CRCHL_POS] = (crc >> 16) & 0xFF; 			//CrcHL
				packetTest[PACKET_CRCLH_POS] = (crc >> 8) & 0xFF; 			//CrcLH
				packetTest[PACKET_CRCLL_POS] = (crc) & 0xFF; 				//CrcLL

				for (i = 0; i < packetCnt; i++) {
					sio_test_add_rx(packetTest[i]);
				}
				isr_communication();
			}
			tcStateCnt++;
			break;
		}
		case 20 : {
			//Check is SIO was called
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
			result = SioTestResult_Passed;
			if (sio_test_get_tx() != CMD_START) {//Start
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//LengthH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x04) {//LengthL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_RDPARAML >> 8) & 0xFF)) {//CommandH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_RDPARAML) & 0xFF)) {//CommandL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x03) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != CMD_END) {//Stop
				result = SioTestResult_Failed;
			}
			tcStateCnt++;
			break;
		}
		case 255 : {
			result = SioTestResult_Failed;
			tcStateCnt++;
			break;
		}
		default : {
			tcStateCnt++;
			break;
		}
	}
	return result;
}

SioTestResult sio_test_TC8(void) {//CMD_WRPARAML
	SioTestResult result = SioTestResult_Pending;
	static uint16 tcStateCnt = 0;
	switch (tcStateCnt) {
		case 0 : {
			{
				unsigned char payload[6] = {((0x0001 >> 8) & 0xFF), ((0x0001) & 0xFF), 0x00, 0x00, 0x00, 0x03};
				uint32 crc = 0;
				uint32 i = 0;
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
				memset(packetTest, 0x00, 128);
				packetCnt = 0;
				packetTest[packetCnt++] = CMD_START; 					//Start

				packetTest[packetCnt++] = 0x00; 						//LengthH
				packetTest[packetCnt++] = 0x06; 						//LengthL

				packetTest[packetCnt++] = (SIO_ADDRESS >> 8) & 0xFF; 	//AddressH
				packetTest[packetCnt++] = (SIO_ADDRESS) & 0xFF; 		//AddressL
				
				packetTest[packetCnt++] = (CMD_WRPARAML >> 8) & 0xFF;	//CommandH
				packetTest[packetCnt++] = (CMD_WRPARAML) & 0xFF; 		//CommandL
				
				packetTest[packetCnt++] = 0; 							//CrcHH
				packetTest[packetCnt++] = 0; 							//CrcHL
				packetTest[packetCnt++] = 0; 							//CrcLH
				packetTest[packetCnt++] = 0; 							//CrcLL

				for (i = 0; i < sizeof(payload) / sizeof(*payload); i++) {
					packetTest[packetCnt++] = payload[i]; 							//payload
				}
				
				packetTest[packetCnt++] = CMD_END;						//Stop
				
				crc = sio_test_calulate_crc32(packetTest, packetCnt);
				packetTest[PACKET_CRCHH_POS] = (crc >> 24) & 0xFF; 			//CrcHH
				packetTest[PACKET_CRCHL_POS] = (crc >> 16) & 0xFF; 			//CrcHL
				packetTest[PACKET_CRCLH_POS] = (crc >> 8) & 0xFF; 			//CrcLH
				packetTest[PACKET_CRCLL_POS] = (crc) & 0xFF; 				//CrcLL

				for (i = 0; i < packetCnt; i++) {
					sio_test_add_rx(packetTest[i]);
				}
				isr_communication();
			}
			tcStateCnt++;
			break;
		}
		case 20 : {
			//Check is SIO was called
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
			result = SioTestResult_Passed;
			if (sio_test_get_tx() != CMD_START) {//Start
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//LengthH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x04) {//LengthL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_WRPARAML >> 8) & 0xFF)) {//CommandH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_WRPARAML) & 0xFF)) {//CommandL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x03) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != CMD_END) {//Stop
				result = SioTestResult_Failed;
			}
			tcStateCnt++;
			break;
		}
		case 255 : {
			result = SioTestResult_Failed;
			tcStateCnt++;
			break;
		}
		default : {
			tcStateCnt++;
			break;
		}
	}
	return result;
}

SioTestResult sio_test_TC9(void) {//CMD_WRPARAMF
	SioTestResult result = SioTestResult_Pending;
	static uint16 tcStateCnt = 0;
	switch (tcStateCnt) {
		case 0 : {
			{
				float testValue = 3.1415f;
				unsigned char payload[6] = {((0x0003 >> 8) & 0xFF), ((0x0003) & 0xFF), 0x00, 0x00, 0x00, 0x00};
				uint32 crc = 0;
				uint32 i = 0;
				memcpy(payload + 2, &testValue, 4);
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
				memset(packetTest, 0x00, 128);
				packetCnt = 0;
				packetTest[packetCnt++] = CMD_START; 					//Start

				packetTest[packetCnt++] = 0x00; 						//LengthH
				packetTest[packetCnt++] = 0x06; 						//LengthL

				packetTest[packetCnt++] = (SIO_ADDRESS >> 8) & 0xFF; 	//AddressH
				packetTest[packetCnt++] = (SIO_ADDRESS) & 0xFF; 		//AddressL
				
				packetTest[packetCnt++] = (CMD_WRPARAMF >> 8) & 0xFF;	//CommandH
				packetTest[packetCnt++] = (CMD_WRPARAMF) & 0xFF; 		//CommandL
				
				packetTest[packetCnt++] = 0; 							//CrcHH
				packetTest[packetCnt++] = 0; 							//CrcHL
				packetTest[packetCnt++] = 0; 							//CrcLH
				packetTest[packetCnt++] = 0; 							//CrcLL

				for (i = 0; i < sizeof(payload) / sizeof(*payload); i++) {
					packetTest[packetCnt++] = payload[i]; 							//payload
				}
				
				packetTest[packetCnt++] = CMD_END;						//Stop
				
				crc = sio_test_calulate_crc32(packetTest, packetCnt);
				packetTest[PACKET_CRCHH_POS] = (crc >> 24) & 0xFF; 			//CrcHH
				packetTest[PACKET_CRCHL_POS] = (crc >> 16) & 0xFF; 			//CrcHL
				packetTest[PACKET_CRCLH_POS] = (crc >> 8) & 0xFF; 			//CrcLH
				packetTest[PACKET_CRCLL_POS] = (crc) & 0xFF; 				//CrcLL

				for (i = 0; i < packetCnt; i++) {
					sio_test_add_rx(packetTest[i]);
				}
				isr_communication();
			}
			tcStateCnt++;
			break;
		}
		case 20 : {
			float testValue = 3.1415f;
			unsigned char data[4] = {0x00, 0x00, 0x00, 0x00};
			memcpy(data, &testValue, 4);
			//Check is SIO was called
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
			result = SioTestResult_Passed;
			if (sio_test_get_tx() != CMD_START) {//Start
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//LengthH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x04) {//LengthL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_WRPARAMF >> 8) & 0xFF)) {//CommandH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_WRPARAMF) & 0xFF)) {//CommandL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != data[0]) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != data[1]) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != data[2]) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != data[3]) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != CMD_END) {//Stop
				result = SioTestResult_Failed;
			}
			tcStateCnt++;
			break;
		}
		case 255 : {
			result = SioTestResult_Failed;
			tcStateCnt++;
			break;
		}
		default : {
			tcStateCnt++;
			break;
		}
	}
	return result;
}

SioTestResult sio_test_TC10(void) {//CMD_RDPARAMF
	SioTestResult result = SioTestResult_Pending;
	static uint16 tcStateCnt = 0;
	switch (tcStateCnt) {
		case 0 : {
			{
				unsigned char payload[2] = {((0x0003 >> 8) & 0xFF), ((0x0003) & 0xFF)};
				uint32 crc = 0;
				uint32 i = 0;
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
				memset(packetTest, 0x00, 128);
				packetCnt = 0;
				packetTest[packetCnt++] = CMD_START; 					//Start

				packetTest[packetCnt++] = 0x00; 						//LengthH
				packetTest[packetCnt++] = 0x02; 						//LengthL

				packetTest[packetCnt++] = (SIO_ADDRESS >> 8) & 0xFF; 	//AddressH
				packetTest[packetCnt++] = (SIO_ADDRESS) & 0xFF; 		//AddressL
				
				packetTest[packetCnt++] = (CMD_RDPARAMF >> 8) & 0xFF;	//CommandH
				packetTest[packetCnt++] = (CMD_RDPARAMF) & 0xFF; 		//CommandL
				
				packetTest[packetCnt++] = 0; 							//CrcHH
				packetTest[packetCnt++] = 0; 							//CrcHL
				packetTest[packetCnt++] = 0; 							//CrcLH
				packetTest[packetCnt++] = 0; 							//CrcLL

				for (i = 0; i < sizeof(payload) / sizeof(*payload); i++) {
					packetTest[packetCnt++] = payload[i]; 							//payload
				}
				
				packetTest[packetCnt++] = CMD_END;						//Stop
				
				crc = sio_test_calulate_crc32(packetTest, packetCnt);
				packetTest[PACKET_CRCHH_POS] = (crc >> 24) & 0xFF; 			//CrcHH
				packetTest[PACKET_CRCHL_POS] = (crc >> 16) & 0xFF; 			//CrcHL
				packetTest[PACKET_CRCLH_POS] = (crc >> 8) & 0xFF; 			//CrcLH
				packetTest[PACKET_CRCLL_POS] = (crc) & 0xFF; 				//CrcLL

				for (i = 0; i < packetCnt; i++) {
					sio_test_add_rx(packetTest[i]);
				}
				isr_communication();
			}
			tcStateCnt++;
			break;
		}
		case 20 : {
			float testValue = 3.1415f;
			unsigned char data[4] = {0x00, 0x00, 0x00, 0x00};
			memcpy(data, &testValue, 4);
			//Check is SIO was called
			//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
			result = SioTestResult_Passed;
			if (sio_test_get_tx() != CMD_START) {//Start
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//LengthH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x04) {//LengthL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_RDPARAMF >> 8) & 0xFF)) {//CommandH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_RDPARAMF) & 0xFF)) {//CommandL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != data[0]) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != data[1]) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != data[2]) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != data[3]) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != CMD_END) {//Stop
				result = SioTestResult_Failed;
			}
			tcStateCnt++;
			break;
		}
		case 255 : {
			result = SioTestResult_Failed;
			tcStateCnt++;
			break;
		}
		default : {
			tcStateCnt++;
			break;
		}
	}
	return result;
}

SioTestResult sio_test_TC11(void) {//CMD_RDPARAMBUF
	SioTestResult result = SioTestResult_Pending;
	static uint16 tcStateCnt = 0;
	switch (tcStateCnt) {
		case 0 : {
			{
				unsigned char payload[2] = {0xFE, 0x95};
				uint32 crc = 0;
				uint32 i = 0;
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
				memset(packetTest, 0x00, 128);
				packetCnt = 0;
				packetTest[packetCnt++] = CMD_START; 					//Start

				packetTest[packetCnt++] = 0x00; 						//LengthH
				packetTest[packetCnt++] = 0x02;							//LengthL

				packetTest[packetCnt++] = (SIO_ADDRESS >> 8) & 0xFF; 	//AddressH
				packetTest[packetCnt++] = (SIO_ADDRESS) & 0xFF; 		//AddressL
				
				packetTest[packetCnt++] = (CMD_RDPARAMBUF >> 8) & 0xFF;	//CommandH
				packetTest[packetCnt++] = (CMD_RDPARAMBUF) & 0xFF; 		//CommandL
				
				packetTest[packetCnt++] = 0; 							//CrcHH
				packetTest[packetCnt++] = 0; 							//CrcHL
				packetTest[packetCnt++] = 0; 							//CrcLH
				packetTest[packetCnt++] = 0; 							//CrcLL

				for (i = 0; i < sizeof(payload) / sizeof(*payload); i++) {
					packetTest[packetCnt++] = payload[i]; 							//payload
				}
				
				packetTest[packetCnt++] = CMD_END;						//Stop
				
				crc = sio_test_calulate_crc32(packetTest, packetCnt);
				packetTest[PACKET_CRCHH_POS] = (crc >> 24) & 0xFF; 			//CrcHH
				packetTest[PACKET_CRCHL_POS] = (crc >> 16) & 0xFF; 			//CrcHL
				packetTest[PACKET_CRCLH_POS] = (crc >> 8) & 0xFF; 			//CrcLH
				packetTest[PACKET_CRCLL_POS] = (crc) & 0xFF; 				//CrcLL

				for (i = 0; i < packetCnt; i++) {
					sio_test_add_rx(packetTest[i]);
				}
				isr_communication();
			}
			tcStateCnt++;
			break;
		}
		case 20 : {
			//Check is SIO was called
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
			result = SioTestResult_Passed;
			if (sio_test_get_tx() != CMD_START) {//Start
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//LengthH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x07) {//LengthL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_RDPARAMBUF >> 8) & 0xFF)) {//CommandH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_RDPARAMBUF) & 0xFF)) {//CommandL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x01) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x02) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x03) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x04) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x05) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x06) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != CMD_END) {//Stop
				result = SioTestResult_Failed;
			}
			tcStateCnt++;
			break;
		}
		case 255 : {
			result = SioTestResult_Failed;
			tcStateCnt++;
			break;
		}
		default : {
			tcStateCnt++;
			break;
		}
	}
	return result;
}

SioTestResult sio_test_TC12(void) {//CMD_WRPARAMBUF
	SioTestResult result = SioTestResult_Pending;
	static uint16 tcStateCnt = 0;
	switch (tcStateCnt) {
		case 0 : {
			{
				unsigned char payload[6] = {0xFE, 0x95, 0xDE, 0xAD, 0xBE, 0xAF};
				uint32 crc = 0;
				uint32 i = 0;
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
				memset(packetTest, 0x00, 128);
				packetCnt = 0;
				packetTest[packetCnt++] = CMD_START; 					//Start

				packetTest[packetCnt++] = 0x00; 						//LengthH
				packetTest[packetCnt++] = 0x06; 						//LengthL

				packetTest[packetCnt++] = (SIO_ADDRESS >> 8) & 0xFF; 	//AddressH
				packetTest[packetCnt++] = (SIO_ADDRESS) & 0xFF; 		//AddressL
				
				packetTest[packetCnt++] = (CMD_WRPARAMBUF >> 8) & 0xFF;	//CommandH
				packetTest[packetCnt++] = (CMD_WRPARAMBUF) & 0xFF; 		//CommandL
				
				packetTest[packetCnt++] = 0; 							//CrcHH
				packetTest[packetCnt++] = 0; 							//CrcHL
				packetTest[packetCnt++] = 0; 							//CrcLH
				packetTest[packetCnt++] = 0; 							//CrcLL

				for (i = 0; i < sizeof(payload) / sizeof(*payload); i++) {
					packetTest[packetCnt++] = payload[i]; 							//payload
				}
				
				packetTest[packetCnt++] = CMD_END;						//Stop
				
				crc = sio_test_calulate_crc32(packetTest, packetCnt);
				packetTest[PACKET_CRCHH_POS] = (crc >> 24) & 0xFF; 			//CrcHH
				packetTest[PACKET_CRCHL_POS] = (crc >> 16) & 0xFF; 			//CrcHL
				packetTest[PACKET_CRCLH_POS] = (crc >> 8) & 0xFF; 			//CrcLH
				packetTest[PACKET_CRCLL_POS] = (crc) & 0xFF; 				//CrcLL

				for (i = 0; i < packetCnt; i++) {
					sio_test_add_rx(packetTest[i]);
				}
				isr_communication();
			}
			tcStateCnt++;
			break;
		}
		case 20 : {
			//Check is SIO was called
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
			result = SioTestResult_Passed;
			if (sio_test_get_tx() != CMD_START) {//Start
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//LengthH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x04) {//LengthL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_WRPARAMBUF >> 8) & 0xFF)) {//CommandH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_WRPARAMBUF) & 0xFF)) {//CommandL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xDE) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xAD) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xBE) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xAF) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != CMD_END) {//Stop
				result = SioTestResult_Failed;
			}
			tcStateCnt++;
			break;
		}
		case 255 : {
			result = SioTestResult_Failed;
			tcStateCnt++;
			break;
		}
		default : {
			tcStateCnt++;
			break;
		}
	}
	return result;
}

SioTestResult sio_test_TC13(void) {//CMD_RESET
	SioTestResult result = SioTestResult_Failed;
	return result;
}

SioTestResult sio_test_TC14(void) {//CMD_GETSEED
	SioTestResult result = SioTestResult_Pending;
	extern uint8 sio_Seed[SIO_SEED_LENGTH];
	static uint16 tcStateCnt = 0;
	switch (tcStateCnt) {
		case 0 : {
			{
				//unsigned char payload[0];
				uint32 crc = 0;
				uint32 i = 0;
			//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
				memset(packetTest, 0x00, 128);
				packetCnt = 0;
				packetTest[packetCnt++] = CMD_START; 					//Start

				packetTest[packetCnt++] = 0x00; 						//LengthH
				packetTest[packetCnt++] = 0x00; 						//LengthL

				packetTest[packetCnt++] = (SIO_ADDRESS >> 8) & 0xFF; 	//AddressH
				packetTest[packetCnt++] = (SIO_ADDRESS) & 0xFF; 		//AddressL
				
				packetTest[packetCnt++] = (CMD_GETSEED >> 8) & 0xFF;	//CommandH
				packetTest[packetCnt++] = (CMD_GETSEED) & 0xFF; 		//CommandL
				
				packetTest[packetCnt++] = 0; 							//CrcHH
				packetTest[packetCnt++] = 0; 							//CrcHL
				packetTest[packetCnt++] = 0; 							//CrcLH
				packetTest[packetCnt++] = 0; 							//CrcLL

				/*for (i = 0; i < sizeof(payload) / sizeof(payload); i++) {
					sio_test_add_rx(payload[i]); 					//payload
				}*/
				
				packetTest[packetCnt++] = CMD_END;						//Stop
				
				crc = sio_test_calulate_crc32(packetTest, packetCnt);
				packetTest[PACKET_CRCHH_POS] = (crc >> 24) & 0xFF; 			//CrcHH
				packetTest[PACKET_CRCHL_POS] = (crc >> 16) & 0xFF; 			//CrcHL
				packetTest[PACKET_CRCLH_POS] = (crc >> 8) & 0xFF; 			//CrcLH
				packetTest[PACKET_CRCLL_POS] = (crc) & 0xFF; 				//CrcLL

				for (i = 0; i < packetCnt; i++) {
					sio_test_add_rx(packetTest[i]);
				}
				isr_communication();
			}
			tcStateCnt++;
			break;
		}
		case 20 : {
			//Check is SIO was called
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
			result = SioTestResult_Passed;
			if (sio_test_get_tx() != CMD_START) {//Start
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//LengthH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x04) {//LengthL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_GETSEED >> 8) & 0xFF)) {//CommandH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_GETSEED) & 0xFF)) {//CommandL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != sio_Seed[0]) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != sio_Seed[1]) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != sio_Seed[2]) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != sio_Seed[3]) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != CMD_END) {//Stop
				result = SioTestResult_Failed;
			}
			tcStateCnt++;
			break;
		}
		case 255 : {
			result = SioTestResult_Failed;
			tcStateCnt++;
			break;
		}
		default : {
			tcStateCnt++;
			break;
		}
	}
	return result;
}

SioTestResult sio_test_TC15(void) {//CMD_CHECKKEY
	SioTestResult result = SioTestResult_Pending;
	extern uint8 sio_Seed[SIO_SEED_LENGTH];
	static uint16 tcStateCnt = 0;
	switch (tcStateCnt) {
		case 0 : {
			{
				unsigned char payload[5] = {0x07, 0x3D, 0x93, 0x45, 0x22};
				uint32 crc = 0;
				uint32 i = 0;
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
				memset(packetTest, 0x00, 128);
				packetCnt = 0;
				packetTest[packetCnt++] = CMD_START; 					//Start

				packetTest[packetCnt++] = 0x00; 						//LengthH
				packetTest[packetCnt++] = 0x05; 						//LengthL

				packetTest[packetCnt++] = (SIO_ADDRESS >> 8) & 0xFF; 	//AddressH
				packetTest[packetCnt++] = (SIO_ADDRESS) & 0xFF; 		//AddressL
				
				packetTest[packetCnt++] = (CMD_CHECKKEY >> 8) & 0xFF;	//CommandH
				packetTest[packetCnt++] = (CMD_CHECKKEY) & 0xFF; 		//CommandL
				
				packetTest[packetCnt++] = 0; 							//CrcHH
				packetTest[packetCnt++] = 0; 							//CrcHL
				packetTest[packetCnt++] = 0; 							//CrcLH
				packetTest[packetCnt++] = 0; 							//CrcLL

				for (i = 0; i < sizeof(payload) / sizeof(*payload); i++) {
					packetTest[packetCnt++] = payload[i]; 							//payload
				}
				
				packetTest[packetCnt++] = CMD_END;						//Stop
				
				crc = sio_test_calulate_crc32(packetTest, packetCnt);
				packetTest[PACKET_CRCHH_POS] = (crc >> 24) & 0xFF; 			//CrcHH
				packetTest[PACKET_CRCHL_POS] = (crc >> 16) & 0xFF; 			//CrcHL
				packetTest[PACKET_CRCLH_POS] = (crc >> 8) & 0xFF; 			//CrcLH
				packetTest[PACKET_CRCLL_POS] = (crc) & 0xFF; 				//CrcLL

				for (i = 0; i < packetCnt; i++) {
					sio_test_add_rx(packetTest[i]);
				}
				isr_communication();

				sio_Seed[0] = 0xA9;
				sio_Seed[1] = 0x52;
				sio_Seed[2] = 0xFB;
				sio_Seed[3] = 0xA4;
			}
			tcStateCnt++;
			break;
		}
		case 20 : {
			//Check is SIO was called
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
			result = SioTestResult_Passed;
			if (sio_test_get_tx() != CMD_START) {//Start
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//LengthH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x01) {//LengthL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_CHECKKEY >> 8) & 0xFF)) {//CommandH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_CHECKKEY) & 0xFF)) {//CommandL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 1) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != CMD_END) {//Stop
				result = SioTestResult_Failed;
			}
			if (sio_access_level_current != 0x07) {
				result = SioTestResult_Failed;
			}
			tcStateCnt++;
			break;
		}
		case 255 : {
			result = SioTestResult_Failed;
			tcStateCnt++;
			break;
		}
		default : {
			tcStateCnt++;
			break;
		}
	}
	return result;
}

SioTestResult sio_test_TC16(void) {//CMD_GETVALIDID
	SioTestResult result = SioTestResult_Pending;
	static uint16 tcStateCnt = 0;
	switch (tcStateCnt) {
		case 0 : {
			{
				//unsigned char payload[0];
				uint32 crc = 0;
				uint32 i = 0;
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
				memset(packetTest, 0x00, 128);
				packetCnt = 0;
				packetTest[packetCnt++] = CMD_START; 					//Start

				packetTest[packetCnt++] = 0x00; 						//LengthH
				packetTest[packetCnt++] = 0x00; 						//LengthL

				packetTest[packetCnt++] = (SIO_ADDRESS >> 8) & 0xFF; 	//AddressH
				packetTest[packetCnt++] = (SIO_ADDRESS) & 0xFF; 		//AddressL
				
				packetTest[packetCnt++] = (CMD_GETVALIDID >> 8) & 0xFF;	//CommandH
				packetTest[packetCnt++] = (CMD_GETVALIDID) & 0xFF; 		//CommandL
				
				packetTest[packetCnt++] = 0; 							//CrcHH
				packetTest[packetCnt++] = 0; 							//CrcHL
				packetTest[packetCnt++] = 0; 							//CrcLH
				packetTest[packetCnt++] = 0; 							//CrcLL

				/*for (i = 0; i < sizeof(payload) / sizeof(payload); i++) {
					sio_test_add_rx(payload[i]); 					//payload
				}*/
				
				packetTest[packetCnt++] = CMD_END;						//Stop
				
				crc = sio_test_calulate_crc32(packetTest, packetCnt);
				packetTest[PACKET_CRCHH_POS] = (crc >> 24) & 0xFF; 			//CrcHH
				packetTest[PACKET_CRCHL_POS] = (crc >> 16) & 0xFF; 			//CrcHL
				packetTest[PACKET_CRCLH_POS] = (crc >> 8) & 0xFF; 			//CrcLH
				packetTest[PACKET_CRCLL_POS] = (crc) & 0xFF; 				//CrcLL

				for (i = 0; i < packetCnt; i++) {
					sio_test_add_rx(packetTest[i]);
				}
				isr_communication();
			}
			tcStateCnt++;
			break;
		}
		case 20 : {
			//Check is SIO was called
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
			result = SioTestResult_Passed;
			if (sio_test_get_tx() != CMD_START) {//Start
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//LengthH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x09) {//LengthL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_GETVALIDID >> 8) & 0xFF)) {//CommandH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_GETVALIDID) & 0xFF)) {//CommandL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x4) {//payload
				result = SioTestResult_Failed;
			}
			
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x01) {//payload
				result = SioTestResult_Failed;
			}
			
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x02) {//payload
				result = SioTestResult_Failed;
			}
			
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x03) {//payload
				result = SioTestResult_Failed;
			}
			
			if (sio_test_get_tx() != CMD_END) {//Stop
				result = SioTestResult_Failed;
			}
			tcStateCnt++;
			break;
		}
		case 255 : {
			result = SioTestResult_Failed;
			tcStateCnt++;
			break;
		}
		default : {
			tcStateCnt++;
			break;
		}
	}
	return result;
}

SioTestResult sio_test_TC17(void) {//CMD_WRPARAMW Find Packet
	SioTestResult result = SioTestResult_Pending;
	static uint16 tcStateCnt = 0;
	switch (tcStateCnt) {
		case 0 : {
			{
				unsigned char payload[4] = {((0x0001 >> 8) & 0xFF), ((0x0001) & 0xFF), 0x00, 0x03};
				uint32 crc = 0;
				uint32 i = 0;
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
				memset(packetTest, 0x00, 128);
				packetCnt = 0;
				packetTest[packetCnt++] = CMD_START; 					//Start

				packetTest[packetCnt++] = 0x00; 						//LengthH
				packetTest[packetCnt++] = 0x04; 						//LengthL

				packetTest[packetCnt++] = (SIO_ADDRESS >> 8) & 0xFF; 	//AddressH
				packetTest[packetCnt++] = (SIO_ADDRESS) & 0xFF; 		//AddressL
				
				packetTest[packetCnt++] = (CMD_WRPARAMW >> 8) & 0xFF;	//CommandH
				packetTest[packetCnt++] = (CMD_WRPARAMW) & 0xFF; 		//CommandL
				
				packetTest[packetCnt++] = 0; 							//CrcHH
				packetTest[packetCnt++] = 0; 							//CrcHL
				packetTest[packetCnt++] = 0; 							//CrcLH
				packetTest[packetCnt++] = 0; 							//CrcLL

				for (i = 0; i < sizeof(payload) / sizeof(*payload); i++) {
					packetTest[packetCnt++] = payload[i]; 							//payload
				}
				
				packetTest[packetCnt++] = CMD_END;						//Stop
				
				crc = sio_test_calulate_crc32(packetTest, packetCnt);
				packetTest[PACKET_CRCHH_POS] = (crc >> 24) & 0xFF; 			//CrcHH
				packetTest[PACKET_CRCHL_POS] = (crc >> 16) & 0xFF; 			//CrcHL
				packetTest[PACKET_CRCLH_POS] = (crc >> 8) & 0xFF; 			//CrcLH
				packetTest[PACKET_CRCLL_POS] = (crc) & 0xFF; 				//CrcLL

				
				sio_test_add_rx(CMD_START);
				sio_test_add_rx(CMD_END);
				for (i = 0; i < packetCnt; i++) {
					sio_test_add_rx(packetTest[i]);
				}
				sio_test_add_rx(CMD_START);
				sio_test_add_rx(CMD_END);
				isr_communication();
			}
			tcStateCnt++;
			break;
		}
		case 20 : {
			//Check is SIO was called
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
			result = SioTestResult_Passed;
			if (sio_test_get_tx() != CMD_START) {//Start
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//LengthH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x02) {//LengthL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_WRPARAMW >> 8) & 0xFF)) {//CommandH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_WRPARAMW) & 0xFF)) {//CommandL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x61) {//CrcHH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x23) {//CrcHL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x46) {//CrcLH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x3E) {//CrcLL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x03) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != CMD_END) {//Stop
				result = SioTestResult_Failed;
			}
			tcStateCnt++;
			break;
		}
		case 255 : {
			result = SioTestResult_Failed;
			tcStateCnt++;
			break;
		}
		default : {
			tcStateCnt++;
			break;
		}
	}
	return result;
}

SioTestResult sio_test_TC18(void) {//CMD_WRPARAMW Packet contains end
	SioTestResult result = SioTestResult_Pending;
	static uint16 tcStateCnt = 0;
	switch (tcStateCnt) {
		case 0 : {
			{
				unsigned char payload[4] = {((0x0001 >> 8) & 0xFF), ((0x0001) & 0xFF), CMD_START, CMD_END};
				uint32 crc = 0;
				uint32 i = 0;
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
				memset(packetTest, 0x00, 128);
				packetCnt = 0;
				packetTest[packetCnt++] = CMD_START; 					//Start

				packetTest[packetCnt++] = 0x00; 						//LengthH
				packetTest[packetCnt++] = 0x04; 						//LengthL

				packetTest[packetCnt++] = (SIO_ADDRESS >> 8) & 0xFF; 	//AddressH
				packetTest[packetCnt++] = (SIO_ADDRESS) & 0xFF; 		//AddressL
				
				packetTest[packetCnt++] = (CMD_WRPARAMW >> 8) & 0xFF;	//CommandH
				packetTest[packetCnt++] = (CMD_WRPARAMW) & 0xFF; 		//CommandL
				
				packetTest[packetCnt++] = 0; 							//CrcHH
				packetTest[packetCnt++] = 0; 							//CrcHL
				packetTest[packetCnt++] = 0; 							//CrcLH
				packetTest[packetCnt++] = 0; 							//CrcLL

				for (i = 0; i < sizeof(payload) / sizeof(*payload); i++) {
					packetTest[packetCnt++] = payload[i]; 							//payload
				}
				
				packetTest[packetCnt++] = CMD_END;						//Stop
				
				crc = sio_test_calulate_crc32(packetTest, packetCnt);
				packetTest[PACKET_CRCHH_POS] = (crc >> 24) & 0xFF; 			//CrcHH
				packetTest[PACKET_CRCHL_POS] = (crc >> 16) & 0xFF; 			//CrcHL
				packetTest[PACKET_CRCLH_POS] = (crc >> 8) & 0xFF; 			//CrcLH
				packetTest[PACKET_CRCLL_POS] = (crc) & 0xFF; 				//CrcLL

				
				sio_test_add_rx(CMD_START);
				sio_test_add_rx(CMD_END);
				for (i = 0; i < packetCnt; i++) {
					sio_test_add_rx(packetTest[i]);
				}
				sio_test_add_rx(CMD_START);
				sio_test_add_rx(CMD_END);
				isr_communication();
			}
			tcStateCnt++;
			break;
		}
		case 20 : {
			//Check is SIO was called
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
			result = SioTestResult_Passed;
			if (sio_test_get_tx() != CMD_START) {//Start
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//LengthH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x02) {//LengthL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_WRPARAMW >> 8) & 0xFF)) {//CommandH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_WRPARAMW) & 0xFF)) {//CommandL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x61) {//CrcHH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x23) {//CrcHL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x46) {//CrcLH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x3E) {//CrcLL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x03) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != CMD_END) {//Stop
				result = SioTestResult_Failed;
			}
			tcStateCnt++;
			break;
		}
		case 255 : {
			result = SioTestResult_Failed;
			tcStateCnt++;
			break;
		}
		default : {
			tcStateCnt++;
			break;
		}
	}
	return result;
}

SioTestResult sio_test_TC19(void) {//CMD_WRPARAMW Spamming buffer
	SioTestResult result = SioTestResult_Pending;
	static uint16 tcStateCnt = 0;
	switch (tcStateCnt) {
		case 0 : {
			uint32 i = 0;
			for (i = 0; i < 1024; i++) {
				sio_test_add_rx(CMD_START);
				sio_test_add_rx(CMD_END);
			}
			isr_communication();
			tcStateCnt++;
			break;
		}
		case 10 : {
			{
				unsigned char payload[4] = {((0x0001 >> 8) & 0xFF), ((0x0001) & 0xFF), CMD_START, CMD_END};
				uint32 crc = 0;
				uint32 i = 0;
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
				memset(packetTest, 0x00, 128);
				packetCnt = 0;
				packetTest[packetCnt++] = CMD_START; 					//Start

				packetTest[packetCnt++] = 0x00; 						//LengthH
				packetTest[packetCnt++] = 0x04; 						//LengthL

				packetTest[packetCnt++] = (SIO_ADDRESS >> 8) & 0xFF; 	//AddressH
				packetTest[packetCnt++] = (SIO_ADDRESS) & 0xFF; 		//AddressL
				
				packetTest[packetCnt++] = (CMD_WRPARAMW >> 8) & 0xFF;	//CommandH
				packetTest[packetCnt++] = (CMD_WRPARAMW) & 0xFF; 		//CommandL
				
				packetTest[packetCnt++] = 0; 							//CrcHH
				packetTest[packetCnt++] = 0; 							//CrcHL
				packetTest[packetCnt++] = 0; 							//CrcLH
				packetTest[packetCnt++] = 0; 							//CrcLL

				for (i = 0; i < sizeof(payload) / sizeof(*payload); i++) {
					packetTest[packetCnt++] = payload[i]; 							//payload
				}
				
				packetTest[packetCnt++] = CMD_END;						//Stop
				
				crc = sio_test_calulate_crc32(packetTest, packetCnt);
				packetTest[PACKET_CRCHH_POS] = (crc >> 24) & 0xFF; 			//CrcHH
				packetTest[PACKET_CRCHL_POS] = (crc >> 16) & 0xFF; 			//CrcHL
				packetTest[PACKET_CRCLH_POS] = (crc >> 8) & 0xFF; 			//CrcLH
				packetTest[PACKET_CRCLL_POS] = (crc) & 0xFF; 				//CrcLL

				
				for (i = 0; i < packetCnt; i++) {
					sio_test_add_rx(packetTest[i]);
				}
				sio_test_add_rx(CMD_START);
				sio_test_add_rx(CMD_END);
				isr_communication();
			}
			tcStateCnt++;
			break;
		}
		case 20 : {
			//Check is SIO was called
				//[byte] Start, LengthH, LengthL, AddressH, AddressL, CommandH, CommandL, CrcHH, CrcHL, CrcLH, CrcLL, ... payload .., Stop
			result = SioTestResult_Passed;
			if (sio_test_get_tx() != CMD_START) {//Start
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x00) {//LengthH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x02) {//LengthL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xFF) {//AddressL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_WRPARAMW >> 8) & 0xFF)) {//CommandH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != ((CMD_WRPARAMW) & 0xFF)) {//CommandL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcHL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLH
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() == -1) {//CrcLL
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0x55) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != 0xAA) {//payload
				result = SioTestResult_Failed;
			}
			if (sio_test_get_tx() != CMD_END) {//Stop
				result = SioTestResult_Failed;
			}
			tcStateCnt++;
			break;
		}
		case 255 : {
			result = SioTestResult_Failed;
			tcStateCnt++;
			break;
		}
		default : {
			tcStateCnt++;
			break;
		}
	}
	return result;
}

int sio_test_get_tx(void) {
	int result = -1;
	unsigned char data = 0;
	if (ringBuffer_getItem(&myRingBuffer_sio_test_tx, &data) != 0) {
		result = data;
	}
	return result;
}

void sio_test_add_rx(unsigned char data) {
	if (ringBuffer_addItem(&myRingBuffer_sio_test_rx, data) != -1) {
	} else {
		 missedRxChar_test++;
	}
}

uint32 sio_test_calulate_crc32(unsigned char *data, uint16 length) {
	uint32 result = 0xCAFECAFE;
	if ((data != NULL) && (length != 0)) {
		uint16 x = 0;
		unsigned char tempCh = 0;
		for (x = 0; x < length; x++) {
			uint16 j = 0;
			uint32 byte = 0;
			uint32 mask = 0;
			tempCh = *(data + x);
			result += tempCh;

			byte = tempCh;            // Get next byte.

			result = result ^ byte;
			for (j = 0; j < 8; j++) {    // Do eight times.
				mask = -(result & 1);
				result = (result >> 1) ^ (0xEDB88320 & mask);
			}	
		}
	}
	result = ~result;
	return result;
}
