#ifndef _C_LCD_HD44780_PINS_H_
#define _C_LCD_HD44780_PINS_H_

#define LCD_PORT_SYNC() 	_sync()
#define LCD_ASYNC_INIT
#define LCD_ASYNC_INTERFACE
#define LCD_ASYNC_INTERFACE_ITEMS 256
#define LCD_DELAY_TIME 25
//#define LCD_USE_BACKLIGHT
//#define LCD_USE_USER_BACKLIGHT

//#define LCD_1_LINE
#define LCD_2_LINE

//Port labak
#define		LCD_DATA7_TRIS	TRISBbits.TRISB14	//UPPER NIBBLE
#define		LCD_DATA6_TRIS	TRISGbits.TRISG7	//UPPER NIBBLE
#define		LCD_DATA5_TRIS	TRISDbits.TRISD8	//UPPER NIBBLE
#define		LCD_DATA4_TRIS	TRISDbits.TRISD11	//UPPER NIBBLE

#define		LCD_PORT7		PORTBbits.RB14
#define		LCD_PORT6		PORTGbits.RG7
#define		LCD_PORT5		PORTDbits.RD8
#define		LCD_PORT4		PORTDbits.RD11

#define		LCD_LAT7		LATBbits.LATB14
#define		LCD_LAT6		LATGbits.LATG7
#define		LCD_LAT5		LATDbits.LATD8
#define		LCD_LAT4		LATDbits.LATD11

#define		E_TRIS			TRISDbits.TRISD5		// LCD Enable control line
#define		E_PORT			PORTDbits.RD5		// LCD Enable control line
#define		E_LAT			LATDbits.LATD5 	// LCD Enable control line

#define		R_W_TRIS		TRISDbits.TRISD6		// LCD Read/Write control line
#define		R_W_PORT		PORTDbits.RD6		// LCD Read/Write control line
#define		R_W_LAT			LATDbits.LATD6		// LCD Read/Write control line

#define		RS_TRIS			TRISDbits.TRISD7		// LCD Register Select control line
#define		RS_PORT			PORTDbits.RD7		// LCD Register Select control line
#define		RS_LAT			LATDbits.LATD7		// LCD Register Select control line

	#ifdef LCD_USE_BACKLIGHT
		#ifndef LCD_USE_USER_BACKLIGHT
			#define		BACKLIGHT_TRIS		TRISEbits.TRISE7
			#define 	BACKLIGHT_PORT		PORTEbits.RE7
			#define 	BACKLIGHT_LAT		LATEbits.LATE7
		#else
			extern void lcd_backlight_on(void);
			extern void lcd_backlight_off(void);
		#endif
	#else
		#define 	BACKLIGHT		noPort
		#define		BACKLIGHT_TRIS	noPort
	#endif

#endif
