#ifndef _GPSHELPER_H_
#define _GPSHELPER_H_

typedef struct _LatLong {
	double latitudeRad; //radian  "Y"  
	double longitudeRad;//radian  "X"  <==>
} LatLong;

extern LatLong parseDoubles(double degreeLat, double minLat, double secLat, double degreeLong, double minLong, double secLong);

extern double distanceLatLat(LatLong a, LatLong b);
extern double bearingLatLat(LatLong a, LatLong b);

extern double getEarthRadius (LatLong latLong);

extern double degreeToRadian(double degree);
extern double radianToDegree(double radian);

extern LatLong addDistance(LatLong source, double bearing, double distance);

extern double calcRelBearing(double bearing, double heading);
extern int inrangeLatLat(LatLong currentPos, LatLong desiredPos, double range);

#endif
