#ifndef _LCD_DRIVERHD44780_H_
#define _LCD_DRIVERHD44780_H_

#include "k_stdtype.h"

//Parancsok
#define		HOME			0x02  // HOME
#define		CGRAM			0x040 // Lower 6 bits are address
#define		DDRAM			0x080 // Lower 7 bits are address
#define		LINE1			0x080 // Set display to line 1 character 0
#define		LINE2			0x0C0 // Set display to line 2 character 0
//#define		FUNCTION_SET	0x028 // 4 bits, 2 lines, 5x7 Font 
#define		FUNCTION_SET	0x020 // 4 bits, 2 lines, 5x7 Font 
#define		DISP_ON			0x00C // Display on
#define		DISP_ON_C		0x00E // Display on, Cursor on
#define		DISP_ON_B 		0x00F // Display on, Cursor on, Blink cursor
#define		DISP_OFF 		0x008 // Display off
#define		CLR_DISP 		0x001 // Clear the Display
#define		ENTRY_INC 		0x006 //
#define		ENTRY_INC_S 	0x007 //
#define		ENTRY_DEC 		0x004 //
#define		ENTRY_DEC_S 	0x005 //
#define		DD_RAM_ADDR 	0x080 // Least Significant 7-bit are for address
#define		DD_RAM_UL 		0x080 // Upper Left coner of the Display
#define		CURS_S_L		0b00010000
#define		CURS_S_R		0b00010100

extern void lcd_backlight_on(void);
extern void lcd_backlight_off(void);
extern uint8 Send_Cmd_LCD(uint8);
extern uint8 Send_Data_LCD(uint8 x);
extern uint8 Send_Async_Cmd_LCD(uint8);
extern uint8 Send_Async_Data_LCD(uint8 x);

#endif
