#ifndef _INT_NRF24L01_H_
#define _INT_NRF24L01_H_

#include "c_nrf24l01.h"
#include "k_stdtype.h"
#include "ringBuffer.h"
#include "tmr.h"

#define RADIO_ADDRESS_LENGTH 5
#define REGISTER_MASK 0x1F

typedef enum _NRF24L01_RxTxMode {
	NRF24L01_TX_MODE = 0,
	NRF24L01_RX_MODE,
} NRF24L01_RxTxMode;

typedef enum _radio_ack {
	RADIO_ACK,
	RADIO_NO_ACK,
} RADIO_USE_ACK;

typedef uint8 radio_register_t;

typedef enum _NRF_REGISTERS {
	/// Configure interrupts, CRC, power, and Tx/Rx nrfStatus
	NRF_REGISTERS_CONFIG = 0x00,
	/// Enhanced Shockburst (auto-ack) on the Rx pipes.
	NRF_REGISTERS_EN_AA = 0x01,
	/// Enable or disable the Rx pipes
	NRF_REGISTERS_EN_RXADDR = 0x02,
	/// Set address width (must be the same on all radios)
	NRF_REGISTERS_SETUP_AW = 0x03,
	/// Set retry delay and number of retries for pipes using Enhanced Shockburst
	NRF_REGISTERS_SETUP_RETR = 0x04,
	/// Set the channel to use, from the 2.4 GHz ISM band.
	NRF_REGISTERS_RF_CH = 0x05,
	/// Setup radio data rate, output power, and LNA gain
	NRF_REGISTERS_RF_SETUP = 0x06,
	/// Interrupt nrfStatus, Tx FIFO full, and number of the Rx pipe that received a packet.
	NRF_REGISTERS_nrfStatus = 0x07,
	/// Count lost and resent packets
	NRF_REGISTERS_OBSERVE_TX = 0x08,
	/// Carrier detect (LSB is 1 if the receiver detects an in-band signal for at least 128 us)
	NRF_REGISTERS_CD = 0x09,
	/// Receive address bytes (see documentation for explanation of how they fit 6 5-byte addresses
	/// into 40 bits).  P0 is also used for auto-ack handling.
	NRF_REGISTERS_RX_ADDR_P0 = 0x0A,
	NRF_REGISTERS_RX_ADDR_P1 = 0x0B,
	NRF_REGISTERS_RX_ADDR_P2 = 0x0C,
	NRF_REGISTERS_RX_ADDR_P3 = 0x0D,
	NRF_REGISTERS_RX_ADDR_P4 = 0x0E,
	NRF_REGISTERS_RX_ADDR_P5 = 0x0F,
	/// Transmit destination address.
	NRF_REGISTERS_TX_ADDR = 0x10,
	/// Payload data width for each of the Rx pipes (0x01 bytes to 0x20 bytes, or 0x00 if pipe is not used)
	NRF_REGISTERS_RX_PW_P0 = 0x11,
	NRF_REGISTERS_RX_PW_P1 = 0x12,
	NRF_REGISTERS_RX_PW_P2 = 0x13,
	NRF_REGISTERS_RX_PW_P3 = 0x14,
	NRF_REGISTERS_RX_PW_P4 = 0x15,
	NRF_REGISTERS_RX_PW_P5 = 0x16,
	/// Auto-retransmit nrfStatus (cf. REUSE_TX_PL instruction), Tx FIFO full/empty, Rx FIFO full/empty
	/// (The Rx FIFO is a 3-packet queue shared by all six pipes)
	NRF_REGISTERS_FIFO_nrfStatus = 0x17,
	NRF_REGISTERS_DYNPD = 0x1C,
	NRF_REGISTERS_FEATURE = 0x1D,
} NRF_REGISTERS;

typedef struct _REG_NRF24L01_CONFIG {
	uint8 PRIM_RX:1;
	uint8 PWR_UP:1;
	uint8 CRCO:1;
	uint8 EN_CRC:1;
	uint8 MASK_MAX_RT:1;
	uint8 MASK_TX_DS:1;
	uint8 MASK_RX_DR:1;
	uint8 dummy:1;
} REG_NRF24L01_CONFIG;

typedef struct _REG_NRF24L01_EN_AA {
	uint8 ENAA_P0:1;
	uint8 ENAA_P1:1;
	uint8 ENAA_P2:1;
	uint8 ENAA_P3:1;
	uint8 ENAA_P4:1;
	uint8 ENAA_P5:1;
	uint8 dummy:2;
} REG_NRF24L01_EN_AA;

typedef struct _REG_NRF24L01_EN_RXADDR {
	uint8 ERX_P0:1;
	uint8 ERX_P1:1;
	uint8 ERX_P2:1;
	uint8 ERX_P3:1;
	uint8 ERX_P4:1;
	uint8 ERX_P5:1;
	uint8 dummy:2;
} REG_NRF24L01_EN_RXADDR;

typedef struct _REG_NRF24L01_SETUP_AW {
	uint8 AW:2;
	uint8 dummy:6;
} REG_NRF24L01_SETUP_AW;

typedef struct _REG_NRF24L01_SETUP_RETR {
	uint8 ARC:4;
	uint8 ARD:4;
} REG_NRF24L01_SETUP_RETR;

typedef struct _REG_NRF24L01_RF_CH {
	uint8 CHANNEL:7;
	uint8 dummy:1;
} REG_NRF24L01_RF_CH;

#ifdef NRF24L01P
	typedef struct _REG_NRF24L01_RF_SETUP {
		uint8 dummy1:1; 
		uint8 RF_PWR:2;
		uint8 RF_DR_HIGH:1;
		uint8 PLL_LOCK:1;
		uint8 RF_DR_LOW:1;
		uint8 dummy:1;
		uint8 CONT_WAVE:1;
	} REG_NRF24L01_RF_SETUP;
#else
	typedef struct _REG_NRF24L01_RF_SETUP {
		uint8 LNA_HCURR:1;
		uint8 RF_PWR:2;
		uint8 RF_DR:1;
		uint8 PLL_LOCK:1;
		uint8 dummy:3;
	} REG_NRF24L01_RF_SETUP;
#endif

typedef struct _REG_NRF24L01_nrfStatus {
	uint8 TX_FULL:1;
	uint8 RX_P_NO:3;
	uint8 MAX_RT:1;
	uint8 TX_DS:1;
	uint8 RX_DR:1;
	uint8 dummy:1;
} REG_NRF24L01_nrfStatus;

typedef struct _REG_NRF24L01_OBSERVE_TX {
	uint8 ARC_CNT:4;
	uint8 PLOS_CNT:4;
} REG_NRF24L01_OBSERVE_TX;

/// We skip the CD register, because it just has 1 bit.  0 - No carrier detected.  1 - Carrier detected.

/// We also skip the RX_ADDR, TX_ADDR, and RX_PW registers because they don't use bit shifting.

typedef struct _REG_NRF24L01_FIFO_nrfStatus {
	uint8 RX_FIFO_EMPTY:1;
	uint8 RX_FIFO_FULL:1;
	uint8 dummy2:2;
	uint8 TX_FIFO_EMPTY:1;
	uint8 TX_FIFO_FULL:1;
	uint8 TX_REUSE:1;
	uint8 dummy1:1;
} REG_NRF24L01_FIFO_nrfStatus;

typedef struct _REG_NRF24L01_DYNPD {
	uint8 DPL_P0:1;
	uint8 DPL_P1:1;
	uint8 DPL_P2:1;
	uint8 DPL_P3:1;
	uint8 DPL_P4:1;
	uint8 DPL_P5:1;
	uint8 dummy1:2;
} REG_NRF24L01_DYNPD;

typedef struct _REG_NRF24L01_FEATURE {
	uint8 EN_DYN_ACK:1;
	uint8 EN_ACK_PAY:1;
	uint8 EN_DPL:1;
	uint8 dummy1:5;
} REG_NRF24L01_FEATURE;

typedef union _REG_NRF24L01 {
	uint8 value;
	REG_NRF24L01_CONFIG config;
	REG_NRF24L01_EN_AA en_aa;
	REG_NRF24L01_EN_RXADDR en_rxaddr;
	REG_NRF24L01_SETUP_AW setup_aw;
	REG_NRF24L01_SETUP_RETR setup_retr;
	REG_NRF24L01_RF_CH rf_ch;
	REG_NRF24L01_RF_SETUP rf_setup;
	REG_NRF24L01_nrfStatus nrfStatus;
	REG_NRF24L01_OBSERVE_TX observe_tx;
	REG_NRF24L01_FIFO_nrfStatus fifo_nrfStatus;
	REG_NRF24L01_DYNPD dynpd;
	REG_NRF24L01_FEATURE feature;
} REG_NRF24L01;

typedef enum _COMMAND_NRF24L01 {
	R_REGISTER = 0x00,
	W_REGISTER = 0x20,
	ACTIVATE = 0x50,
	R_RX_PL_WID = 0x60,
	R_RX_PAYLOAD = 0x61,
	W_TX_PAYLOAD = 0xA0,
	FLUSH_TX = 0xE1,
	FLUSH_RX = 0xE2,
	REUSE_TX_PL = 0xE3,
	NRF24L01_NOP = 0xFF,
} COMMAND_NRF24L01;


#endif
