#ifndef _NRF24L01_H_
#define _NRF24L01_H_

#include "k_stdtype.h"
#include "task.h"

typedef enum _radio_packet_type {
	RADIO_PACKET_TYPE_NRF_CONTROL = 0,
	RADIO_PACKET_TYPE_SIO_DATA = 1,
} radio_packet_type;

typedef enum _radio_pipe {
	RADIO_PIPE_0 = 0,
	RADIO_PIPE_1 = 1,
	RADIO_PIPE_2 = 2,
	RADIO_PIPE_3 = 3,
	RADIO_PIPE_4 = 4,
	RADIO_PIPE_5 = 5,
	RADIO_PIPE_EMPTY = 7,	// FIFO is empty when pipe number bits in nrfStatus register are 0b111.
} RADIO_PIPE;

typedef enum _ed {
	DISABLE=0,
	ENABLE=1,
} ON_OFF;		// there's got to be a better name for this.

typedef enum _radio_dr {
	RADIO_1MBPS = 0,		// that's Mbps, not MBps.
	RADIO_2MBPS = 1,
	RADIO_250KPS = 2,
} RADIO_DATA_RATE;

typedef enum _radio_tx_power {
	RADIO_LOWEST_POWER = 0,		// -18 dBm (about 16 uW)
	RADIO_LOW_POWER = 1,		// -12 dBm (about 63 uW)
	RADIO_HIGH_POWER = 2,		// -6 dBm (about 251 uW)
	RADIO_HIGHEST_POWER = 3,	// 0 dBm (1 mW)
} RADIO_TX_POWER;

typedef struct _rp_payload_structure {
	uint8 type;
	uint8 cnt;
	uint8 data[26];//26
	uint32 time;
} radiopacket_payload_structure_t;

typedef union _rp_payload {
	uint8 data[32];
	radiopacket_payload_structure_t structure;
} radiopacket_payload_t;

typedef struct _rp {
	uint8 length;
	radiopacket_payload_t payload;
} radiopacket_t;

typedef enum _radio_receive {
	RADIO_RX_INVALID_ARGS,		// one of the arguments to Radio_Receive was invalid
	RADIO_RX_TRANSMITTING,		// the radio was transmitting
	RADIO_RX_FIFO_EMPTY,		// there aren't any packets in the Rx FIFO to receive (Radio_Receive does not receive data)
	RADIO_RX_MORE_PACKETS,		// after copying out the head of the Rx FIFO, there is still another packet in the FIFO.
	RADIO_RX_SUCCESS,			// there was a packet to receive, it was successfully received, and the Rx FIFO is now empty.
} RADIO_RX_nrfStatus;

typedef enum _radio_transmit {
	RADIO_TX_BUSY,
	RADIO_TX_TIMEOUT,
	RADIO_TX_MAX_RT,
	RADIO_TX_SUCCESS,
} RADIO_TX_nrfStatus;

extern TaskId doNrf24L01HandlerTaskNr;

#endif
