#include "global.h"
#include "mal.h"
#include "i_tmr.h"
#include "i_app.h"
#include "i_spi.h"
#include "i_serial_usart1.h"
#include "i_sio.h"
#include "app.h"
#include "c_io.h"

void __ISR(_TIMER_1_VECTOR, IPL2SOFT) Timer1Handler(void) {
    mT1ClearIntFlag();
	isr_tmr1();
} 

void __ISR(_TIMER_2_VECTOR, IPL2SOFT) Timer2Handler(void) {
    mT2ClearIntFlag();
	isr_tmr2();
}

void __ISR(_SPI_2_VECTOR, IPL3SOFT)__SPI2Interrupt(void) {
	//isr_spi();
	//isr_spi_wifi();
}

void __ISR(_TIMER_4_VECTOR, IPL2SOFT) Timer4Handler(void) {
    mT4ClearIntFlag();
	//isr_t4();
	isr_appCustom();
}

void __ISR(_EXTERNAL_3_VECTOR, IPL13SOFT)__EINT3Interrupt(void) {
	//isr_eint_wifi();
}

void __ISR(_DMA1_VECTOR, ipl5) DmaHandler1(void) {
	//isr_dma1();
} 

void __ISR(_DMA2_VECTOR, ipl6) DmaHandler2(void) {
	//isr_dma2();
}

void __ISR(_UART1_VECTOR, IPL2SOFT) IntUart1Handler(void) {
	if (INTGetFlag(INT_SOURCE_UART_RX(UART1))) {
		INTClearFlag(INT_SOURCE_UART_RX(UART1));
		isrSerialRx_usart1(UARTGetDataByte(UART1));
		isr_communication();
	}
	if ( INTGetFlag(INT_SOURCE_UART_TX(UART1)) ) {
		 INTClearFlag(INT_SOURCE_UART_TX(UART1));
		isrSerialTx_usart1();
	}
	if ( INTGetFlag(INT_SOURCE_UART_ERROR(UART1)) ) {
		 INTClearFlag(INT_SOURCE_UART_ERROR(UART1));
		isrSerialError_usart1();
	}
}

void init_isr(void) {
	//INTEnableSystemMultiVectoredInt();
	INTConfigureSystem(INT_SYSTEM_CONFIG_MULT_VECTOR);
	INTEnableInterrupts();
}
