#include <stdio.h>
#include "nrf24l01.h"
#include "c_nrf24l01.h"
#include "i_nrf24l01.h"
#include "w_nrf24l01.h"
#include "int_nrf24l01.h"
#include "nrf24l01_low.h"
#include "nrf24l01_medium.h"
#include "nrf24l01_radio.h"

#include "spi.h"

unsigned char nrfTempOut1;
unsigned char nrfTempIn1;
unsigned char nrfTemp[8]; //Maximal usage is 5, for safty 8.

void nrf24l01_delay_65us(void) {
	unsigned long x = 0;
	for (x = 0; x < NRFDELAY_CNT; x++) {
		Nop();
	}
}

/**
 * Set a register in the radio
 * \param reg The register value defined in nRF24L01.h (e.g. CONFIG, EN_AA, &c.).
 * \param value The value to write to the given register (the whole register is overwritten).
 * \return The nrfStatus register.
 */
REG_NRF24L01_nrfStatus set_register(radio_register_t reg, uint8* value, uint8 len) {
	REG_NRF24L01_nrfStatus nrfStatus;
	uint8 instruction = W_REGISTER | (REGISTER_MASK & reg);
	memcpy(nrfTemp, value, len);
	nrfStatus = send_instruction(instruction, nrfTemp, NULL, len);
	return nrfStatus;
}

/**
 * Retrieve a register value from the radio.
 * \param reg The register value defined in nRF24L01.h (e.g. CONFIG, EN_AA, &c.).
 * \param buffer A contiguous memory block into which the register contents will be copied.  If the buffer is too long for the
 * 		register contents, then the remaining bytes will be overwritten with 0xFF.
 * \param len The length of the buffer.
 */
REG_NRF24L01_nrfStatus get_register(radio_register_t reg, uint8* buffer, uint8 len) {
	REG_NRF24L01_nrfStatus nrfStatus;
	uint8 instruction = R_REGISTER | (REGISTER_MASK & reg);
	nrfStatus = send_instruction(instruction, NULL, nrfTemp, len);
	memcpy(buffer, nrfTemp, len);
	return nrfStatus;
}

/**
 * Send an instruction to the nRF24L01.
 * \param instruction The instruction to send (see the bottom of nRF24L01.h)
 * \param data An array of argument data to the instruction.  If len is 0, then this may be NULL.
 * \param buffer An array for the instruction's return data.  This can be NULL if the instruction has no output.
 * \param len The length of the data and buffer arrays.
 */
REG_NRF24L01_nrfStatus send_instruction(uint8 instruction, uint8* dataOut, uint8* dataIn, uint8 len) {
	REG_NRF24L01 nrfStatus;
	spi_reconfigure(0, 0, 0, 4);
	CSN_LAT = 0;
	NRF_PORT_SYNC();
	// send the instruction
	nrfTempOut1 = instruction;
	readWriteSPI(&nrfTempOut1, &nrfTempIn1, 1);
	nrfStatus.value = nrfTempIn1;
	// pass in args
	if (len > 0) {
		readWriteSPI(dataOut, dataIn, len);
	}
	// resynch SPI
	CSN_LAT = 1;
	NRF_PORT_SYNC();
	return nrfStatus.nrfStatus;
}
